/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.cocoon;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.util.SizeUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.xslt.TraxErrorListener;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class ThreadSafeTraxProcessor
extends AbstractLogEnabled
implements XSLTProcessor,
Serviceable,
Initializable,
Disposable,
Parameterizable,
URIResolver {
    private static final String _RESOLVE_URI_CACHE_ID = ThreadSafeTraxProcessor.class.getName() + "$request";
    private static final String _TEMPLATES_CACHE_ID = ThreadSafeTraxProcessor.class.getName() + "$templates";
    private String _transformerFactory;
    private SAXTransformerFactory _factory;
    private boolean _incrementalProcessing;
    private SourceResolver _resolver;
    private AbstractCacheManager _cacheManager;
    private XMLizer _xmlizer;
    private ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._xmlizer = (XMLizer)this._manager.lookup(XMLizer.ROLE);
        this._resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._factory = this._createTransformerFactory(this._transformerFactory);
        this._cacheManager.createRequestCache(_RESOLVE_URI_CACHE_ID, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_RESOLVE_URI_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_RESOLVE_URI_DESCRIPTION"), false);
        this._cacheManager.createMemoryCache(_TEMPLATES_CACHE_ID, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_THREAD_TEMPLATES_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_THREAD_TEMPLATES_DESCRIPTION"), true, null);
    }

    public void dispose() {
        if (null != this._manager) {
            this._manager.release((Object)this._resolver);
            this._manager.release((Object)this._xmlizer);
            this._manager = null;
        }
        this._xmlizer = null;
        this._resolver = null;
        this._getTemplatesCache().invalidateAll();
    }

    public void parameterize(Parameters params) throws ParameterException {
        this._incrementalProcessing = params.getParameterAsBoolean("incremental-processing", this._incrementalProcessing);
        this._transformerFactory = params.getParameter("transformer-factory", null);
    }

    public void setTransformerFactory(String classname) {
        throw new UnsupportedOperationException("This implementation is threadsafe, so the TransformerFactory cannot be changed");
    }

    public TransformerHandler getTransformerHandler(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        XSLTProcessor.TransformerHandlerAndValidity validity = this.getTransformerHandlerAndValidity(stylesheet, filter);
        return validity.getTransfomerHandler();
    }

    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet) throws XSLTProcessorException {
        return this.getTransformerHandlerAndValidity(stylesheet, null);
    }

    public XSLTProcessor.TransformerHandlerAndValidity getTransformerHandlerAndValidity(Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        TraxErrorListener errorListener = new TraxErrorListener(this.getLogger(), stylesheet.getURI());
        try {
            Pair<Templates, CacheValidity> templates = this._getTemplates(stylesheet, filter);
            TransformerHandler handler = this._factory.newTransformerHandler((Templates)templates.getLeft());
            handler.getTransformer().setErrorListener((ErrorListener)errorListener);
            handler.getTransformer().setURIResolver(this);
            SourceValidity validity = stylesheet.getValidity();
            ExtendedTransformerHandlerAndValidity handlerAndValidity = new ExtendedTransformerHandlerAndValidity(handler, validity, (CacheValidity)((Object)templates.getRight()));
            return handlerAndValidity;
        }
        catch (IOException e) {
            throw new XSLTProcessorException("Exception when getting Templates for " + stylesheet.getURI(), (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            Throwable realEx = errorListener.getThrowable();
            if (realEx == null) {
                realEx = e;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof XSLTProcessorException) {
                throw (XSLTProcessorException)realEx;
            }
            throw new XSLTProcessorException("Exception when creating Transformer from " + stylesheet.getURI(), realEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Templates, CacheValidity> _getTemplates(Source stylesheet, XMLFilter filter) throws XSLTProcessorException, IOException {
        String uri = stylesheet.getURI().intern();
        long lastModified = stylesheet.getLastModified();
        String string = uri;
        synchronized (string) {
            if (lastModified <= 0L) {
                SAXTransformerFactory factory = this._createTransformerFactory(this._transformerFactory);
                factory.setURIResolver(this);
                return Pair.of((Object)this._createTemplates(factory, stylesheet, filter), (Object)((Object)CacheValidity.NON_CACHED));
            }
            Collection<CachedTemplates> cachedTemplatesForUri = this._getTemplatesCache().get(uri);
            CacheValidity validity = CacheValidity.NON_CACHED;
            if (cachedTemplatesForUri != null) {
                Pair<CachedTemplates, CacheValidity> result = this._getCachedTemplates(cachedTemplatesForUri, stylesheet, this._getResolutionCache());
                validity = (CacheValidity)((Object)result.getRight());
                if (validity == CacheValidity.CACHED && result.getLeft() != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Found Templates in cache for stylesheet : " + uri);
                    }
                    return Pair.of((Object)((CachedTemplates)result.getLeft()).getTemplates(), (Object)((Object)validity));
                }
            } else {
                cachedTemplatesForUri = new ArrayList<CachedTemplates>();
            }
            CachedTemplates cachedTemplates = new CachedTemplates(lastModified, this);
            SAXTransformerFactory factory = this._createTransformerFactory(this._transformerFactory);
            factory.setURIResolver(cachedTemplates);
            Templates templates = this._createTemplates(factory, stylesheet, filter);
            if (this.getLogger().isDebugEnabled()) {
                String[] rawURIs = cachedTemplates.getRawURIs();
                String[] resolvedURIs = cachedTemplates.getResolvedURIs();
                StringBuilder sb = new StringBuilder("Templates created for stylesheet : ");
                sb.append(uri);
                sb.append(" including the following stylesheets : ");
                for (int i = 0; i < rawURIs.length; ++i) {
                    sb.append('\n');
                    sb.append(rawURIs[i]);
                    sb.append(" => ");
                    sb.append(resolvedURIs[i]);
                }
                this.getLogger().debug(sb.toString());
            }
            cachedTemplates.setTemplates(templates);
            cachedTemplatesForUri.add(cachedTemplates);
            this._getTemplatesCache().put(uri, cachedTemplatesForUri);
            return Pair.of((Object)templates, (Object)((Object)validity));
        }
    }

    private Pair<CachedTemplates, CacheValidity> _getCachedTemplates(Collection<CachedTemplates> cachedTemplates, Source stylesheet, Cache<UnresolvedURI, ResolvedURI> resolutionCache) throws IOException {
        CachedTemplates outOfDateTemplates = null;
        Iterator<CachedTemplates> it = cachedTemplates.iterator();
        while (outOfDateTemplates == null && it.hasNext()) {
            CachedTemplates templates = it.next();
            CacheValidity validity = this._isValid(templates, stylesheet, resolutionCache);
            if (validity == CacheValidity.CACHED) {
                return Pair.of((Object)templates, (Object)((Object)CacheValidity.CACHED));
            }
            if (validity != CacheValidity.OUT_OF_DATE) continue;
            outOfDateTemplates = templates;
        }
        if (outOfDateTemplates != null) {
            cachedTemplates.remove(outOfDateTemplates);
            return Pair.of(null, (Object)((Object)CacheValidity.OUT_OF_DATE));
        }
        return Pair.of(null, (Object)((Object)CacheValidity.NON_CACHED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CacheValidity _isValid(CachedTemplates templates, Source stylesheet, Cache<UnresolvedURI, ResolvedURI> resolutionCache) throws IOException {
        CacheValidity cacheValidity;
        String[] rawURIs = templates.getRawURIs();
        String[] baseURIs = templates.getBaseURIs();
        String[] resolvedURIs = templates.getResolvedURIs();
        Long[] timestamps = templates.getTimestamps();
        if (templates.getLastModified() != stylesheet.getLastModified()) {
            return CacheValidity.OUT_OF_DATE;
        }
        boolean outOfDate = false;
        for (int i = 0; i < rawURIs.length; ++i) {
            long lastModified;
            String resolvedURI;
            UnresolvedURI unresolved = new UnresolvedURI(rawURIs[i], baseURIs[i]);
            ResolvedURI resolved = resolutionCache.get(unresolved);
            if (resolved != null) {
                resolvedURI = resolved._resolvedURI;
                lastModified = resolved._timestamp;
            } else {
                Source src = null;
                try {
                    src = this._resolve(rawURIs[i], baseURIs[i]);
                    resolvedURI = src.getURI();
                    lastModified = src.getLastModified();
                }
                catch (Throwable throwable) {
                    this._resolver.release(src);
                    throw throwable;
                }
                this._resolver.release(src);
            }
            if (!resolvedURI.equals(resolvedURIs[i])) {
                return null;
            }
            if (lastModified != 0L && timestamps[i] != 0L && lastModified == timestamps[i]) continue;
            outOfDate = true;
        }
        if (outOfDate) {
            cacheValidity = CacheValidity.OUT_OF_DATE;
            return cacheValidity;
        }
        cacheValidity = CacheValidity.CACHED;
        return cacheValidity;
    }

    private Templates _createTemplates(SAXTransformerFactory factory, Source stylesheet, XMLFilter filter) throws XSLTProcessorException {
        String id = stylesheet.getURI();
        TraxErrorListener errorListener = new TraxErrorListener(this.getLogger(), id);
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Creating new Templates for " + id);
            }
            factory.setErrorListener((ErrorListener)errorListener);
            TemplatesHandler templatesHandler = factory.newTemplatesHandler();
            templatesHandler.setSystemId(id);
            if (filter != null) {
                filter.setContentHandler(templatesHandler);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Source = " + String.valueOf(stylesheet) + ", templatesHandler = " + String.valueOf(templatesHandler));
            }
            this._sourceToSAX(stylesheet, filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
            Templates templates = templatesHandler.getTemplates();
            if (null == templates) {
                throw new XSLTProcessorException("Unable to create templates for stylesheet: " + stylesheet.getURI());
            }
            Class<?> clazz = templates.getClass();
            if (clazz.getName().equals("org.apache.xalan.templates.StylesheetRoot")) {
                Method method = clazz.getMethod("setHref", String.class);
                method.invoke((Object)templates, id);
            }
            return templates;
        }
        catch (Exception e) {
            Throwable realEx = errorListener.getThrowable();
            if (realEx == null) {
                realEx = e;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof XSLTProcessorException) {
                throw (XSLTProcessorException)realEx;
            }
            throw new XSLTProcessorException("Exception when creating Transformer from " + stylesheet.getURI(), realEx);
        }
    }

    private void _sourceToSAX(Source source, ContentHandler handler) throws SAXException, IOException, SourceException {
        if (source instanceof XMLizable) {
            ((XMLizable)source).toSAX(handler);
        } else {
            InputStream inputStream = source.getInputStream();
            String mimeType = source.getMimeType();
            String systemId = source.getURI();
            this._xmlizer.toSAX(inputStream, mimeType, systemId, handler);
        }
    }

    public void transform(Source source, Source stylesheet, Parameters params, Result result) throws XSLTProcessorException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform source = " + String.valueOf(source) + ", stylesheet = " + String.valueOf(stylesheet) + ", parameters = " + String.valueOf(params) + ", result = " + String.valueOf(result));
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                String[] names = params.getNames();
                for (int i = names.length - 1; i >= 0; --i) {
                    transformer.setParameter(names[i], params.getParameter(names[i]));
                }
            }
            handler.setResult(result);
            this._sourceToSAX(source, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Transform done");
            }
        }
        catch (SAXException e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", (Throwable)e);
        }
        catch (Exception e) {
            String message = "Error in running Transformation";
            throw new XSLTProcessorException("Error in running Transformation", (Throwable)e);
        }
    }

    private SAXTransformerFactory _createTransformerFactory(String factoryName) {
        SAXTransformerFactory saxFactory;
        if (null == factoryName) {
            saxFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                saxFactory = (SAXTransformerFactory)loader.loadClass(factoryName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                this.getLogger().error("Cannot find the requested TrAX factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                if (this._factory != null) {
                    return this._factory;
                }
                saxFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                this.getLogger().error("The indicated class '" + factoryName + "' is not a TrAX Transformer Factory. Using default TrAX Transformer Factory instead.");
                if (this._factory != null) {
                    return this._factory;
                }
                saxFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                this.getLogger().error("Error found loading the requested TrAX Transformer Factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                if (this._factory != null) {
                    return this._factory;
                }
                saxFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        saxFactory.setErrorListener((ErrorListener)new TraxErrorListener(this.getLogger(), null));
        saxFactory.setURIResolver(this);
        if (saxFactory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            saxFactory.setAttribute("http://xml.apache.org/xalan/features/incremental", this._incrementalProcessing);
        }
        if (saxFactory.getClass().getName().equals("net.sf.saxon.TransformerFactoryImpl")) {
            saxFactory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        }
        return saxFactory;
    }

    @Override
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        return this._resolve(href, base, null, null, null, null);
    }

    private Source _resolve(String href, String base) throws IOException {
        Source xslSource = this._resolver.resolveURI(href, base, null);
        String uri = xslSource.getURI();
        UnresolvedURI unresolvedURI = new UnresolvedURI(href, base);
        ResolvedURI cachedResolvedURI = this._getResolutionCache().get(unresolvedURI);
        if (cachedResolvedURI == null) {
            this._getResolutionCache().put(unresolvedURI, new ResolvedURI(uri, xslSource.getLastModified()));
        } else if (!uri.equals(cachedResolvedURI._resolvedURI)) {
            this.getLogger().error("The following uri is inconsistent '" + href + "' because it leads to two different files in the same request: '" + uri + "' and '" + cachedResolvedURI._resolvedURI + "'. The XSLT cache is not working so please report this issue to https://issues.ametys.org");
        }
        return xslSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    javax.xml.transform.Source _resolve(String href, String base, Collection<String> rawURIs, Collection<String> baseURIs, Collection<Long> timestamps, Collection<String> resolvedURIs) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolve(href = " + href + ", base = " + base + "); resolver = " + String.valueOf(this._resolver));
        }
        Source xslSource = null;
        try {
            xslSource = this._resolve(href, base);
            if (rawURIs != null) {
                rawURIs.add(href);
            }
            if (baseURIs != null) {
                baseURIs.add(base);
            }
            if (timestamps != null) {
                timestamps.add(xslSource.getLastModified());
            }
            if (resolvedURIs != null) {
                resolvedURIs.add(xslSource.getURI());
            }
            InputSource is = this._getInputSource(xslSource);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("xslSource = " + String.valueOf(xslSource) + ", system id = " + xslSource.getURI());
            }
            StreamSource streamSource = new StreamSource(is.getByteStream(), is.getSystemId());
            return streamSource;
        }
        catch (IOException ioe) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)ioe);
            }
            javax.xml.transform.Source source = null;
            return source;
        }
        finally {
            this._resolver.release(xslSource);
        }
    }

    private InputSource _getInputSource(Source source) throws IOException, SourceException {
        InputSource newObject = new InputSource(source.getInputStream());
        newObject.setSystemId(source.getURI());
        return newObject;
    }

    public void clearResolutionCache() {
        this._getResolutionCache().invalidateAll();
    }

    private Cache<UnresolvedURI, ResolvedURI> _getResolutionCache() {
        return this._cacheManager.get(_RESOLVE_URI_CACHE_ID);
    }

    private Cache<String, Collection<CachedTemplates>> _getTemplatesCache() {
        return this._cacheManager.get(_TEMPLATES_CACHE_ID);
    }

    public static class ExtendedTransformerHandlerAndValidity
    extends XSLTProcessor.TransformerHandlerAndValidity {
        CacheValidity _cacheValidity;

        public ExtendedTransformerHandlerAndValidity(TransformerHandler handler, SourceValidity validity, CacheValidity cacheValidity) {
            super(handler, validity);
            this._cacheValidity = cacheValidity;
        }

        public boolean isFromCache() {
            return this._cacheValidity == CacheValidity.CACHED;
        }

        public CacheValidity getValidity() {
            return this._cacheValidity;
        }
    }

    public static enum CacheValidity {
        CACHED,
        OUT_OF_DATE,
        NON_CACHED;

    }

    private static class CachedTemplates
    implements URIResolver {
        private long _lastModified;
        private List<String> _rawURIs = new ArrayList<String>();
        private List<String> _baseURIs = new ArrayList<String>();
        private List<String> _resolvedURIs = new ArrayList<String>();
        private List<Long> _timestamps = new ArrayList<Long>();
        private Templates _templates;
        @SizeUtils.ExcludeFromSizeCalculation
        private ThreadSafeTraxProcessor _processor;

        CachedTemplates(long lastModified, ThreadSafeTraxProcessor processor) {
            this._lastModified = lastModified;
            this._processor = processor;
        }

        @Override
        public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
            return this._processor._resolve(href, base, this._rawURIs, this._baseURIs, this._timestamps, this._resolvedURIs);
        }

        long getLastModified() {
            return this._lastModified;
        }

        String[] getRawURIs() {
            return this._rawURIs.toArray(new String[0]);
        }

        String[] getBaseURIs() {
            return this._baseURIs.toArray(new String[0]);
        }

        Long[] getTimestamps() {
            return this._timestamps.toArray(new Long[0]);
        }

        String[] getResolvedURIs() {
            return this._resolvedURIs.toArray(new String[0]);
        }

        Templates getTemplates() {
            return this._templates;
        }

        void setTemplates(Templates templates) {
            this._templates = templates;
        }
    }

    private static class UnresolvedURI {
        String _rawURI;
        String _baseURI;

        public UnresolvedURI(String rawURI, String baseURI) {
            this._rawURI = rawURI;
            this._baseURI = baseURI;
        }

        public int hashCode() {
            if (this._rawURI.indexOf(58) > 1) {
                return this._rawURI.hashCode();
            }
            int lastPathElementPos = this._baseURI.lastIndexOf(47);
            if (lastPathElementPos == -1) {
                return this._rawURI.hashCode();
            }
            String uri = this._baseURI.substring(0, lastPathElementPos) + "/" + this._rawURI;
            return uri.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UnresolvedURI)) {
                return false;
            }
            UnresolvedURI unresolved = (UnresolvedURI)obj;
            if (this._rawURI.indexOf(58) > 1) {
                return this._rawURI.equals(unresolved._rawURI);
            }
            int lastPathElementPos = this._baseURI.lastIndexOf(47);
            if (lastPathElementPos == -1) {
                return false;
            }
            if (unresolved._baseURI.length() <= lastPathElementPos) {
                return false;
            }
            String uri1 = this._baseURI.substring(0, lastPathElementPos) + "/" + this._rawURI;
            String uri2 = unresolved._baseURI.substring(0, lastPathElementPos) + "/" + unresolved._rawURI;
            return uri1.equals(uri2);
        }
    }

    private static class ResolvedURI {
        String _resolvedURI;
        long _timestamp;

        public ResolvedURI(String resolvedURI, long timestamp) {
            this._resolvedURI = resolvedURI;
            this._timestamp = timestamp;
        }
    }
}

