/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.config;

import java.util.Collection;
import java.util.Comparator;
import org.ametys.runtime.config.ConfigParameterDefinitionWrapper;
import org.ametys.runtime.model.CategorizedElementDefinitionHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;

public class ConfigParameterDefinitionComparator
implements Comparator<ModelItem> {
    private final Collection<ConfigParameterDefinitionWrapper> _configParameterDefinitionWrappers;

    public ConfigParameterDefinitionComparator(Collection<ConfigParameterDefinitionWrapper> configParameterDefinitionWrappers) {
        this._configParameterDefinitionWrappers = configParameterDefinitionWrappers;
    }

    @Override
    public int compare(ModelItem item1, ModelItem item2) {
        if (!(item1 instanceof ElementDefinition) || !(item2 instanceof ElementDefinition)) {
            throw new IllegalArgumentException("This comparator can only be called with element definitions");
        }
        ElementDefinition definition1 = (ElementDefinition)item1;
        ConfigParameterDefinitionWrapper wrapper1 = this.getWrapperFromDefinition((ElementDefinition)item1);
        ElementDefinition definition2 = (ElementDefinition)item2;
        ConfigParameterDefinitionWrapper wrapper2 = this.getWrapperFromDefinition((ElementDefinition)item2);
        int positionComparison = CategorizedElementDefinitionHelper.compareWrapperPositions(wrapper1, wrapper2);
        if (positionComparison != 0) {
            return positionComparison;
        }
        return definition1.compareTo(definition2);
    }

    protected ConfigParameterDefinitionWrapper getWrapperFromDefinition(ElementDefinition definition) {
        ModelItemGroup category = null;
        ModelItemGroup group = definition.getParent();
        if (group != null) {
            category = group.getParent();
        }
        for (ConfigParameterDefinitionWrapper wrapper : this._configParameterDefinitionWrappers) {
            if (category != null && !category.getLabel().equals(wrapper.getDisplayCategory()) || group != null && !group.getLabel().equals(wrapper.getDisplayGroup()) || !definition.getName().equals(wrapper.getDefinition().getName())) continue;
            return wrapper;
        }
        return null;
    }
}

