/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.config.ConfigParameterDefinitionWrapper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.CategorizedElementDefinitionHelper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;

public final class ConfigParameterDefinitionHelper {
    private ConfigParameterDefinitionHelper() {
    }

    public static Map<String, ElementDefinition> getFlatDefinitions(Collection<ConfigParameterDefinitionWrapper> elements) {
        HashMap<String, ElementDefinition> flatDefinitions = new HashMap<String, ElementDefinition>();
        for (ConfigParameterDefinitionWrapper element : elements) {
            ElementDefinition definition = element.getDefinition();
            flatDefinitions.put(definition.getName(), definition);
        }
        return flatDefinitions;
    }

    public static List<ModelItem> categorizeConfigParameters(Collection<ConfigParameterDefinitionWrapper> elements) {
        ConfigManager model = ConfigManager.getInstance();
        Map<I18nizableText, Map<I18nizableText, List<ConfigParameterDefinitionWrapper>>> categories = CategorizedElementDefinitionHelper.categorizeElementDefinitionWrappers(elements);
        ArrayList<ModelItem> modelItems = new ArrayList<ModelItem>();
        for (Map.Entry<I18nizableText, Map<I18nizableText, List<ConfigParameterDefinitionWrapper>>> categoryEntry : categories.entrySet()) {
            ModelItemGroup category = new ModelItemGroup();
            category.setModel(model);
            category.setLabel(categoryEntry.getKey());
            modelItems.add(category);
            Map<I18nizableText, List<ConfigParameterDefinitionWrapper>> values = categoryEntry.getValue();
            for (Map.Entry<I18nizableText, List<ConfigParameterDefinitionWrapper>> groupEntry : values.entrySet()) {
                ModelItemGroup group = new ModelItemGroup();
                group.setModel(model);
                group.setLabel(groupEntry.getKey());
                category.addChild(group);
                for (ConfigParameterDefinitionWrapper orderedDefinition : groupEntry.getValue()) {
                    ElementDefinition definition = orderedDefinition.getDefinition();
                    group.addChild(definition, orderedDefinition.isGroupSwitch());
                }
            }
        }
        return modelItems;
    }

    public static View buildConfigParametersView(Collection<? extends ModelItem> categories, Comparator<? super ModelItem> categoriesComparator, Comparator<? super ModelItem> groupsComparator, Comparator<? super ModelItem> elementsComparator) throws IllegalArgumentException {
        View view = new View();
        Collection<? extends ModelItem> sorted = ConfigParameterDefinitionHelper._sort(categories, categoriesComparator);
        for (ModelItem modelItem : sorted) {
            view.addViewItem(ConfigParameterDefinitionHelper._buildCategoryViewItem(modelItem, groupsComparator, elementsComparator));
        }
        return view;
    }

    private static ModelViewItemGroup _buildCategoryViewItem(ModelItem modelItem, Comparator<? super ModelItem> groupsComparator, Comparator<? super ModelItem> elementsComparator) throws IllegalArgumentException {
        if (modelItem instanceof ModelItemGroup) {
            ModelItemGroup category = (ModelItemGroup)modelItem;
            ModelViewItemGroup<ModelItemGroup> categoryViewItem = new ModelViewItemGroup<ModelItemGroup>();
            categoryViewItem.setRole("tab");
            categoryViewItem.setDefinition(category);
            Collection<? extends ModelItem> groups = ConfigParameterDefinitionHelper._sort(category.getChildren(), groupsComparator);
            for (ModelItem modelItem2 : groups) {
                categoryViewItem.addViewItem(ConfigParameterDefinitionHelper._buildGroupViewItem(modelItem2, elementsComparator));
            }
            return categoryViewItem;
        }
        throw new IllegalArgumentException("Category " + modelItem.getPath() + " should be an instance of ModelItemGroup");
    }

    private static ModelViewItemGroup _buildGroupViewItem(ModelItem modelItem, Comparator<? super ModelItem> elementsComparator) throws IllegalArgumentException {
        if (modelItem instanceof ModelItemGroup) {
            ModelItemGroup group = (ModelItemGroup)modelItem;
            ModelViewItemGroup<ModelItemGroup> groupViewItem = new ModelViewItemGroup<ModelItemGroup>();
            groupViewItem.setRole("fieldset");
            groupViewItem.setDefinition(group);
            Collection<? extends ModelItem> items = ConfigParameterDefinitionHelper._sort(group.getChildren(), elementsComparator);
            for (ModelItem modelItem2 : items) {
                groupViewItem.addViewItem(ConfigParameterDefinitionHelper._buildElementViewItem(modelItem2));
            }
            return groupViewItem;
        }
        throw new IllegalArgumentException("Group " + modelItem.getPath() + " should be an instance of ModelItemGroup");
    }

    private static ModelViewItem _buildElementViewItem(ModelItem modelItem) throws IllegalArgumentException {
        if (modelItem instanceof ElementDefinition) {
            ElementDefinition definition = (ElementDefinition)modelItem;
            ViewElement parameterViewItem = new ViewElement();
            parameterViewItem.setDefinition(definition);
            return parameterViewItem;
        }
        throw new IllegalArgumentException("Item " + modelItem.getPath() + " should be an instance of ElementDefinition");
    }

    private static Collection<? extends ModelItem> _sort(Collection<? extends ModelItem> items, Comparator<? super ModelItem> comparator) {
        if (comparator == null) {
            return items;
        }
        ArrayList<? extends ModelItem> sorted = new ArrayList<ModelItem>(items);
        sorted.sort(comparator);
        return sorted;
    }
}

