/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.data;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.ametys.runtime.data.AmetysHomeLockException;

public class AmetysHomeLock {
    private static final String __LOCK_FILE = ".lock";
    private File _directory;
    private File _file;
    private RandomAccessFile _randomAccessFile;
    private String _identifier;
    private FileLock _lock;

    public AmetysHomeLock(File ametysHome) throws AmetysHomeLockException {
        try {
            this._directory = ametysHome.getCanonicalFile();
            this._file = new File(this._directory, __LOCK_FILE);
            this._identifier = (AmetysHomeLock.class.getName() + ":" + this._directory.getPath()).intern();
            this._lock = null;
        }
        catch (IOException e) {
            throw new AmetysHomeLockException("Unable to construct the Ametys home lock instance at path " + ametysHome.getPath(), e);
        }
    }

    public void acquire() throws AmetysHomeLockException {
        if (this._file.exists()) {
            System.out.println("[WARN] Existing lock file " + String.valueOf(this._file) + " detected. Previous lock was not released properly.");
        }
        try {
            this._tryLock();
        }
        catch (AmetysHomeLockException e) {
            this._closeRandomAccessFile();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _tryLock() throws AmetysHomeLockException {
        try {
            this._randomAccessFile = new RandomAccessFile(this._file, "rw");
            this._lock = this._randomAccessFile.getChannel().tryLock();
        }
        catch (IOException e) {
            throw new AmetysHomeLockException("Unable to create or lock file " + String.valueOf(this._file), e);
        }
        catch (OverlappingFileLockException e) {
            throw new AmetysHomeLockException("The Ametys home " + String.valueOf(this._directory) + " appears to be in use since the file named " + this._file.getName() + " is already locked by the current process.");
        }
        if (this._lock == null) {
            throw new AmetysHomeLockException("The Ametys home " + String.valueOf(this._directory) + " appears to be in use since the file named " + this._file.getName() + " is locked by another process.");
        }
        String string = this._identifier;
        synchronized (string) {
            if (null != System.getProperty(this._identifier)) {
                throw new AmetysHomeLockException("The Ametys home " + String.valueOf(this._directory) + " appears to be already locked by the current process.");
            }
            try {
                System.setProperty(this._identifier, this._identifier);
            }
            catch (SecurityException e) {
                System.out.println("[WARN] Unable to set system property: " + this._identifier);
                e.printStackTrace();
            }
        }
    }

    private void _closeRandomAccessFile() {
        if (this._randomAccessFile != null) {
            try {
                this._randomAccessFile.close();
            }
            catch (IOException e) {
                System.out.println("[WARN] Unable to close the random access file " + String.valueOf(this._file));
                e.printStackTrace();
            }
            this._randomAccessFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this._lock != null) {
            try (FileChannel channel = this._lock.channel();){
                this._lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._lock = null;
            this._closeRandomAccessFile();
        }
        if (!this._file.delete()) {
            System.out.println("[WARN] Unable to delete repository lock file");
        }
        String string = this._identifier;
        synchronized (string) {
            try {
                System.getProperties().remove(this._identifier);
            }
            catch (SecurityException e) {
                System.out.println("[WARN] Unable to clear system property: " + this._identifier);
                e.printStackTrace();
            }
        }
    }
}

