/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.i18n;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.i18n.FormatableI18nizable;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class I18nizableDate
implements FormatableI18nizable,
I18nizableTextParameter {
    private LocalDate _date;
    private DateTimeFormatter _formatter;
    private String _pattern;

    public I18nizableDate(LocalDate date, FormatStyle style) {
        this._date = date;
        this._formatter = DateTimeFormatter.ofLocalizedDate(style);
        this._pattern = style.name();
    }

    public I18nizableDate(LocalDate date, String pattern) {
        this._date = date;
        this._formatter = DateTimeFormatter.ofPattern(pattern);
        this._pattern = pattern;
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "pattern", "pattern", this._pattern);
        atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "src-pattern", "src-pattern", "yyyy-MM-dd");
        atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "value", "value", DateUtils.localDateToString(this._date));
        handler.startElement("http://apache.org/cocoon/i18n/2.1", "date", "i18n:date", (Attributes)atts);
        handler.endElement("http://apache.org/cocoon/i18n/2.1", "date", "i18n:date");
    }

    @Override
    public void toSAXAsParam(ContentHandler handler) throws SAXException {
        this.toSAX(handler);
    }

    @Override
    public String format(Locale locale) {
        return this._formatter.withLocale(locale).format(this._date);
    }
}

