/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.i18n;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.i18n.FormatableI18nizable;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class I18nizableDateTime
implements FormatableI18nizable,
I18nizableTextParameter {
    private ZonedDateTime _dateTime;
    private DateTimeFormatter _formatter;
    private String _pattern;

    public I18nizableDateTime(ZonedDateTime dateTime, ZoneId zoneId, FormatStyle style) {
        this._dateTime = dateTime.withZoneSameInstant(zoneId);
        this._formatter = DateTimeFormatter.ofLocalizedDateTime(style);
        this._pattern = style.name();
    }

    public I18nizableDateTime(ZonedDateTime dateTime, ZoneId zoneId, String pattern) {
        this._dateTime = dateTime.withZoneSameInstant(zoneId);
        this._formatter = DateTimeFormatter.ofPattern(pattern);
        this._pattern = pattern;
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "pattern", "pattern", this._pattern);
        atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "src-pattern", "src-pattern", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "value", "value", DateUtils.zonedDateTimeToString(this._dateTime));
        handler.startElement("http://apache.org/cocoon/i18n/2.1", "date-time", "i18n:date-time", (Attributes)atts);
        handler.endElement("http://apache.org/cocoon/i18n/2.1", "date-time", "i18n:date-time");
    }

    @Override
    public void toSAXAsParam(ContentHandler handler) throws SAXException {
        this.toSAX(handler);
    }

    @Override
    public String format(Locale locale) {
        return this._formatter.withLocale(locale).format(this._dateTime);
    }
}

