/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.i18n;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableTextParameter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class I18nizableText
implements I18nizable,
I18nizableTextParameter {
    private final boolean _i18n;
    private String _directLabel;
    private String _key;
    private String _catalogue;
    private List<String> _parameters;
    private Map<String, I18nizableTextParameter> _parameterMap;
    private String _catalogueLocation;
    private String _catalogueBundleName;

    public I18nizableText(String label) {
        this._i18n = false;
        this._directLabel = label;
    }

    public I18nizableText(String catalogue, String key) {
        this(catalogue, key, (List<String>)null);
    }

    public I18nizableText(String catalogue, String key, List<String> parameters) {
        String i18nCatalogue;
        this._i18n = true;
        String i18nKey = key.substring(key.indexOf(":") + 1);
        this._catalogue = i18nCatalogue = i18nKey.length() == key.length() ? catalogue : key.substring(0, key.length() - i18nKey.length() - 1);
        this._key = i18nKey;
        this._parameters = parameters;
        this._parameterMap = null;
    }

    public I18nizableText(String catalogue, String key, Map<String, I18nizableTextParameter> parameters) {
        String i18nCatalogue;
        this._i18n = true;
        String i18nKey = key.substring(key.indexOf(":") + 1);
        this._catalogue = i18nCatalogue = i18nKey.length() == key.length() ? catalogue : key.substring(0, key.length() - i18nKey.length() - 1);
        this._key = i18nKey;
        this._parameterMap = parameters;
        this._parameters = null;
    }

    public I18nizableText(String catalogueLocation, String catalogueFilename, String key) {
        this(catalogueLocation, catalogueFilename, key, (List<String>)null);
    }

    public I18nizableText(String catalogueLocation, String catalogueFilename, String key, List<String> parameters) {
        this._i18n = true;
        this._catalogueLocation = catalogueLocation;
        this._catalogueBundleName = catalogueFilename;
        this._catalogue = null;
        this._key = key;
        this._parameters = parameters;
        this._parameterMap = null;
    }

    public I18nizableText(String catalogueLocation, String catalogueFilename, String key, Map<String, I18nizableTextParameter> parameters) {
        this._i18n = true;
        this._catalogueLocation = catalogueLocation;
        this._catalogueBundleName = catalogueFilename;
        this._catalogue = null;
        this._key = key;
        this._parameterMap = parameters;
        this._parameters = null;
    }

    public boolean isI18n() {
        return this._i18n;
    }

    public String getCatalogue() {
        if (this._i18n) {
            return this._catalogue;
        }
        throw new IllegalArgumentException("This text is not i18nized and so do not have catalogue. Use the 'isI18n' method to know whether a text is i18nized");
    }

    public String getLocation() {
        if (this._i18n) {
            return this._catalogueLocation;
        }
        throw new IllegalArgumentException("This text is not i18nized and so do not have location. Use the 'isI18n' method to know whether a text is i18nized");
    }

    public String getBundleName() {
        if (this._i18n) {
            return this._catalogueBundleName;
        }
        throw new IllegalArgumentException("This text is not i18nized and so do not have location. Use the 'isI18n' method to know whether a text is i18nized");
    }

    public String getKey() {
        if (this._i18n) {
            return this._key;
        }
        throw new IllegalArgumentException("This text is not i18nized and so do not have key. Use the 'isI18n' method to know whether a text is i18nized");
    }

    public List<String> getParameters() {
        if (this._i18n) {
            return this._parameters;
        }
        throw new IllegalArgumentException("This text is not i18nized and so do not have parameters. Use the 'isI18n' method to know whether a text is i18nized");
    }

    public Map<String, I18nizableTextParameter> getParameterMap() {
        if (this._i18n) {
            return this._parameterMap;
        }
        throw new IllegalArgumentException("This text is not i18nized and so do not have parameters. Use the 'isI18n' method to know whether a text is i18nized");
    }

    public String getLabel() {
        if (!this._i18n) {
            return this._directLabel;
        }
        throw new IllegalArgumentException("This text is i18nized and so do not have label. Use the 'isI18n' method to know whether a text is i18nized");
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        if (this.isI18n()) {
            List<String> parameters = this.getParameters();
            Map<String, I18nizableTextParameter> parameterMap = this.getParameterMap();
            boolean hasParameter = parameters != null && parameters.size() > 0 || parameterMap != null && !parameterMap.isEmpty();
            handler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
            if (hasParameter) {
                handler.startElement("http://apache.org/cocoon/i18n/2.1", "translate", "i18n:translate", (Attributes)new AttributesImpl());
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "key", "i18n:key", this.getKey());
            if (this.getCatalogue() != null) {
                atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "catalogue", "i18n:catalogue", this.getCatalogue());
            }
            handler.startElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text", (Attributes)atts);
            handler.endElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text");
            if (hasParameter) {
                if (parameters != null) {
                    for (String parameter : parameters) {
                        if (parameter == null) continue;
                        handler.startElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param", (Attributes)new AttributesImpl());
                        handler.characters(parameter.toCharArray(), 0, parameter.length());
                        handler.endElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param");
                    }
                } else if (parameterMap != null) {
                    for (String parameterName : parameterMap.keySet()) {
                        I18nizableTextParameter value = parameterMap.get(parameterName);
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addCDATAAttribute("name", parameterName);
                        handler.startElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param", (Attributes)attrs);
                        value.toSAXAsParam(handler);
                        handler.endElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param");
                    }
                }
                handler.endElement("http://apache.org/cocoon/i18n/2.1", "translate", "i18n:translate");
            }
            handler.endPrefixMapping("i18n");
        } else {
            handler.characters(this.getLabel().toCharArray(), 0, this.getLabel().length());
        }
    }

    @Override
    public void toSAXAsParam(ContentHandler handler) throws SAXException {
        if (this.isI18n()) {
            AttributesImpl atts = new AttributesImpl();
            if (this.getCatalogue() != null) {
                atts.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "catalogue", "i18n:catalogue", this.getCatalogue());
            }
            handler.startElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text", (Attributes)atts);
            handler.characters(this._key.toCharArray(), 0, this._key.length());
            handler.endElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text");
        } else {
            handler.characters(this.getLabel().toCharArray(), 0, this.getLabel().length());
        }
    }

    public String toString() {
        Object result = "";
        if (this.isI18n()) {
            result = (String)result + this.getCatalogue() + ":" + this.getKey();
            List<String> parameters = this.getParameters();
            if (parameters != null) {
                result = (String)result + "[";
                boolean isFirst = true;
                for (String parameter : parameters) {
                    if (!isFirst) {
                        result = (String)result + "; param : " + parameter;
                        continue;
                    }
                    result = (String)result + "param : " + parameter;
                    isFirst = false;
                }
                result = (String)result + "]";
            }
        } else {
            result = this.getLabel();
        }
        return result;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append(this._i18n);
        hashCodeBuilder.append((Object)this._key);
        hashCodeBuilder.append((Object)this._catalogueLocation);
        hashCodeBuilder.append((Object)this._catalogueBundleName);
        hashCodeBuilder.append((Object)this._catalogue);
        hashCodeBuilder.append((Object)this._directLabel);
        if (this._parameters == null) {
            hashCodeBuilder.append(null);
        } else {
            hashCodeBuilder.append((Object[])this._parameters.toArray(new String[this._parameters.size()]));
        }
        hashCodeBuilder.append(this._parameterMap);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof I18nizableText)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        I18nizableText i18nObj = (I18nizableText)obj;
        if (this._i18n != i18nObj._i18n) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        if (this._i18n) {
            equalsBuilder.append((Object)this._key, (Object)i18nObj._key);
            if (this._catalogue == null) {
                equalsBuilder.append((Object)this._catalogueLocation, (Object)i18nObj._catalogueLocation);
                equalsBuilder.append((Object)this._catalogueBundleName, (Object)i18nObj._catalogueBundleName);
            } else {
                equalsBuilder.append((Object)this._catalogue, (Object)i18nObj._catalogue);
            }
            if (this._parameters == null) {
                equalsBuilder.append(this._parameters, i18nObj._parameters);
            } else {
                Object[] otherParameters = null;
                if (i18nObj._parameters != null) {
                    otherParameters = i18nObj._parameters.toArray(new String[i18nObj._parameters.size()]);
                }
                equalsBuilder.append((Object[])this._parameters.toArray(new String[this._parameters.size()]), otherParameters);
            }
            equalsBuilder.append(this._parameterMap, i18nObj.getParameterMap());
        } else {
            equalsBuilder.append((Object)this._directLabel, (Object)i18nObj._directLabel);
        }
        return equalsBuilder.isEquals();
    }

    public static boolean isI18n(Configuration config) {
        return config.getAttributeAsBoolean("i18n", false) || config.getAttribute("type", "").equals("i18n");
    }

    private static I18nizableText getI18nizableTextValue(Configuration config, String catalogueLocation, String catalogueFilename, String value) {
        return new I18nizableText(catalogueLocation, catalogueFilename, value);
    }

    public static I18nizableText getI18nizableTextValue(Configuration config, String defaultCatalogue, String value) {
        if (config != null) {
            if (I18nizableText.isI18n(config)) {
                String catalogue = config.getAttribute("catalogue", defaultCatalogue);
                return new I18nizableText(catalogue, value);
            }
            return new I18nizableText(value);
        }
        return null;
    }

    public static I18nizableText parseI18nizableText(Configuration config, String catalogueLocation, String catalogueFilename, String defaultValue) {
        if (config != null) {
            String text = config.getValue(defaultValue);
            return I18nizableText.getI18nizableTextValue(config, catalogueLocation, catalogueFilename, text);
        }
        return null;
    }

    public static I18nizableText parseI18nizableText(Configuration config, String defaultCatalogue, String defaultValue) {
        return Optional.ofNullable(config).map(cfg -> cfg.getValue(defaultValue)).map(text -> I18nizableText.getI18nizableTextValue(config, defaultCatalogue, text)).orElse(new I18nizableText(defaultValue));
    }

    public static I18nizableText parseI18nizableText(Configuration config, String defaultCatalogue, I18nizableText defaultValue) {
        return Optional.ofNullable(config).map(cfg -> cfg.getValue(null)).map(text -> I18nizableText.getI18nizableTextValue(config, defaultCatalogue, text)).orElse(defaultValue);
    }

    public static I18nizableText parseI18nizableText(Configuration config, String defaultCatalogue) throws ConfigurationException {
        if (config != null) {
            String text = config.getValue();
            return I18nizableText.getI18nizableTextValue(config, defaultCatalogue, text);
        }
        return null;
    }

    public static String i18nizableTextToString(I18nizableText i18nizableText) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (i18nizableText.isI18n()) {
            map.put("key", i18nizableText.getKey());
            map.put("catalogue", i18nizableText.getCatalogue());
            map.put("parameters", i18nizableText.getParameters());
        } else {
            map.put("label", i18nizableText.getLabel());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (XMLEncoder xmlEncoder = new XMLEncoder(bos);){
            xmlEncoder.writeObject(map);
            xmlEncoder.flush();
        }
        try {
            return bos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static I18nizableText stringToI18nizableText(String str) {
        Map map;
        try (XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(str.getBytes("UTF-8")));){
            map = (Map)xmlDecoder.readObject();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (map.get("label") != null) {
            return new I18nizableText((String)map.get("label"));
        }
        String key = (String)map.get("key");
        String catalogue = (String)map.get("catalogue");
        List parameters = (List)map.get("parameters");
        return new I18nizableText(catalogue, key, parameters);
    }
}

