/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.log;

import java.io.IOException;
import org.ametys.core.util.AmetysExceptionFilter;
import org.ametys.runtime.log.ExternalLog;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.rolling.RollingFileAppender;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.TimeBasedRollingPolicy;
import org.apache.log4j.spi.Filter;

public class StaticExternalLog
implements ExternalLog,
Configurable,
PluginAware {
    protected static final String PATTERN_LAYOUT = "%d %-5p [%c] (%t;%X{requestURI}) %m%n";
    protected static final Level DEFAULT_LEVEL = Level.WARN;
    private String _appenderName;
    private String _categoryName;
    private String _filePrefix;
    private boolean _additive;
    private Level _level;
    private boolean _rollingFileAppender;
    private Appender _appender;

    @Override
    public Appender getAppender() throws IOException {
        if (this._appender == null) {
            this._appender = this._rollingFileAppender ? this._createRollingFileAppender() : this._createFileAppender();
        }
        return this._appender;
    }

    private RollingFileAppender _createRollingFileAppender() {
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setName(this._appenderName);
        fileAppender.setEncoding("UTF-8");
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        String filePattern = String.valueOf(AmetysHomeHelper.getAmetysHome()) + "/logs/" + this._filePrefix + "-%d.log";
        rollingPolicy.setFileNamePattern(filePattern);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        PatternLayout layout = new PatternLayout(PATTERN_LAYOUT);
        fileAppender.setLayout((Layout)layout);
        AmetysExceptionFilter filter = new AmetysExceptionFilter();
        fileAppender.addFilter((Filter)filter);
        fileAppender.activateOptions();
        return fileAppender;
    }

    private FileAppender _createFileAppender() throws IOException {
        String filename = String.valueOf(AmetysHomeHelper.getAmetysHome()) + "/logs/" + this._filePrefix + ".log";
        PatternLayout layout = new PatternLayout(PATTERN_LAYOUT);
        FileAppender fileAppender = new FileAppender((Layout)layout, filename);
        AmetysExceptionFilter filter = new AmetysExceptionFilter();
        fileAppender.addFilter((Filter)filter);
        fileAppender.activateOptions();
        return fileAppender;
    }

    @Override
    public Logger getCategory() {
        Logger logger = LogManager.getLogger((String)this._categoryName);
        logger.setAdditivity(this._additive);
        logger.setLevel(this._level);
        return logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._categoryName = configuration.getChild("category-name").getValue("").trim();
        this._filePrefix = configuration.getChild("file-prefix").getValue("").trim();
        this._additive = configuration.getChild("additive").getValueAsBoolean(true);
        this._rollingFileAppender = configuration.getChild("rolling-file").getValueAsBoolean(true);
        String levelAsString = configuration.getChild("log-level").getValue(DEFAULT_LEVEL.toString());
        this._level = Level.toLevel((String)levelAsString);
        if (StringUtils.isBlank((CharSequence)this._filePrefix)) {
            throw new ConfigurationException("<file-prefix> is mandatory and should not be blank", configuration);
        }
        if (StringUtils.isBlank((CharSequence)this._categoryName)) {
            throw new ConfigurationException("<category-name> is mandatory and should not be blank", configuration);
        }
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._appenderName = id;
    }
}

