/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.maintenance;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.exception.ServiceUnavailableException;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class MaintenanceAction
extends ServiceableAction {
    protected static final Collection<Pattern> ACCEPTED_URL_PATTERNS = Arrays.asList(Pattern.compile("^plugins/core-ui/user/[^/]+/[^/]+/image_[0-9]+$"));
    private CurrentUserProvider _currentUserProvider;
    private RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        UserIdentity user;
        if (RuntimeServlet.getMaintenanceStatus() != RuntimeServlet.MaintenanceStatus.NONE && !MaintenanceAction.acceptedUrl(ObjectModelHelper.getRequest((Map)objectModel)) && ((user = this._currentUserProvider.getUser()) == null || user.getPopulationId() != "admin_population" && this._rightManager.hasRight(user, "Runtime_Rights_Admin_Maintenance_Access", "/admin") != RightManager.RightResult.RIGHT_ALLOW) && !this._isACaptchaUrl((String)ObjectModelHelper.getRequest((Map)objectModel).getAttribute("inWorkspaceURL"))) {
            throw new ServiceUnavailableException("User " + (user != null ? UserIdentity.userIdentityToString(user) : "[anonymous]") + " cannot access during maintenance");
        }
        return EMPTY_MAP;
    }

    private boolean _isACaptchaUrl(String url) {
        for (Pattern pattern : CaptchaHelper.getUsedUrlPatterns()) {
            if (!pattern.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean acceptedUrl(Request request) {
        String url = (String)request.getAttribute("inWorkspaceURL");
        for (Pattern pattern : ACCEPTED_URL_PATTERNS) {
            if (!pattern.matcher(url).matches()) continue;
            return true;
        }
        return false;
    }
}

