/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.maintenance;

import java.util.Map;
import java.util.Optional;
import org.ametys.runtime.exception.ExceptionAction;
import org.ametys.runtime.exception.ServiceUnavailableException;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;

public class MaintenanceExceptionAction
extends ExceptionAction {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Throwable throwable = ObjectModelHelper.getThrowable((Map)objectModel);
        boolean forceMaintenanceMode = this._forceMaintenanceMode(throwable);
        if (forceMaintenanceMode) {
            Response response = ObjectModelHelper.getResponse((Map)objectModel);
            response.setHeader("X-Ametys-Maintenance", "");
        }
        Map<String, String> results = super.act(redirector, resolver, objectModel, source, parameters);
        String comment = Optional.ofNullable(RuntimeServlet.getMaintenanceStatusForcedInformations()).map(s -> s.comment()).orElse("");
        results.put("comment", comment);
        return results;
    }

    private boolean _forceMaintenanceMode(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof ServiceUnavailableException) {
            ServiceUnavailableException sue = (ServiceUnavailableException)throwable;
            return sue.forceMaintenanceMode();
        }
        return this._forceMaintenanceMode(throwable.getCause());
    }
}

