/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractModelItemParser;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.StaticEnumerator;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractElementDefinitionParser<D extends DisableConditions>
extends AbstractModelItemParser<D> {
    private ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    private ThreadSafeComponentManager<Validator> _validatorManager;
    private final Map<String, ElementDefinition> _validatorsToLookup = new HashMap<String, ElementDefinition>();
    private final Map<String, ElementDefinition> _enumeratorsToLookup = new HashMap<String, ElementDefinition>();

    public AbstractElementDefinitionParser(ModelItemTypeExtensionPoint modelItemTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
        super(modelItemTypeExtensionPoint, disableConditionsManager);
        this._enumeratorManager = enumeratorManager;
        this._validatorManager = validatorManager;
    }

    @Override
    public <T extends ModelItem> T parse(ServiceManager serviceManager, String pluginName, String catalog, Configuration definitionConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        ElementDefinition definition = (ElementDefinition)super.parse(serviceManager, pluginName, catalog, definitionConfig, model, parent);
        definition.setParsedDefaultValues(this._parseDefaultValues(definitionConfig, definition));
        definition.setMultiple(ItemParserHelper.parseMultiple(definitionConfig));
        this._parseAndSetEnumerator(pluginName, catalog, definition, definitionConfig);
        this._parseAndSetValidator(pluginName, definition, definitionConfig);
        return (T)definition;
    }

    @Override
    protected ElementDefinition _createModelItem(Configuration definitionConfig) throws ConfigurationException {
        return new DefaultElementDefinition();
    }

    protected List<Pair<String, Object>> _parseDefaultValues(Configuration definitionConfig, ElementDefinition definition) throws ConfigurationException {
        return ItemParserHelper.parseDefaultValues(definitionConfig, definition, ItemParserHelper::parseDefaultValue);
    }

    protected void _parseAndSetEnumerator(String pluginName, String catalog, ElementDefinition definition, Configuration definitionConfig) throws ConfigurationException {
        Configuration enumeratorConfig = definitionConfig.getChild("enumeration", false);
        if (enumeratorConfig != null) {
            Configuration customEnumerator = enumeratorConfig.getChild("custom-enumerator", false);
            if (customEnumerator != null) {
                String enumeratorClassName = customEnumerator.getAttribute("class");
                String enumeratorRole = definition.getPath() + "$" + UUID.randomUUID().toString();
                try {
                    Class<?> enumeratorClass = Class.forName(enumeratorClassName);
                    this._enumeratorManager.addComponent(pluginName, null, enumeratorRole, enumeratorClass, definitionConfig);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to instantiate enumerator for class: " + enumeratorClassName, (Throwable)e);
                }
                this._enumeratorsToLookup.put(enumeratorRole, definition);
                definition.setCustomEnumerator(enumeratorClassName);
                definition.setEnumeratorConfiguration(customEnumerator);
            } else {
                StaticEnumerator staticEnumerator = new StaticEnumerator();
                for (Configuration entryConfig : enumeratorConfig.getChildren("entry")) {
                    Configuration valueConfiguration = entryConfig.getChild("value");
                    Object value = definition.getType().parseConfiguration(valueConfiguration);
                    I18nizableText label = null;
                    if (entryConfig.getChild("label", false) != null) {
                        label = this._parseI18nizableText(entryConfig, catalog, "label");
                    }
                    staticEnumerator.add(label, value);
                }
                definition.setEnumerator(staticEnumerator);
            }
        }
    }

    protected void _parseAndSetValidator(String pluginName, ElementDefinition definition, Configuration definitionConfig) throws ConfigurationException {
        Configuration validatorConfig = definitionConfig.getChild("validation", false);
        if (validatorConfig != null) {
            String validatorClassName;
            Configuration customValidator = validatorConfig.getChild("custom-validator", false);
            if (customValidator != null) {
                validatorClassName = customValidator.getAttribute("class");
                definition.setCustomValidator(validatorClassName);
                definition.setValidatorConfiguration(customValidator);
            } else {
                validatorClassName = DefaultValidator.class.getName();
            }
            String validatorRole = definition.getPath() + "$" + UUID.randomUUID().toString();
            try {
                Class<?> validatorClass = Class.forName(validatorClassName);
                this._validatorManager.addComponent(pluginName, null, validatorRole, validatorClass, definitionConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate validator for class: " + validatorClassName, (Throwable)e);
            }
            this._validatorsToLookup.put(validatorRole, definition);
        }
    }

    @Override
    public void lookupComponents() throws Exception {
        ElementDefinition definition;
        super.lookupComponents();
        this._validatorManager.initialize();
        this._enumeratorManager.initialize();
        for (Map.Entry<String, ElementDefinition> entry : this._validatorsToLookup.entrySet()) {
            String validatorRole = entry.getKey();
            definition = entry.getValue();
            try {
                definition.setValidator(this._validatorManager.lookup(validatorRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup validator role: '" + validatorRole + "' for parameter: " + String.valueOf(definition), e);
            }
        }
        for (Map.Entry<String, ElementDefinition> entry : this._enumeratorsToLookup.entrySet()) {
            String enumeratorRole = entry.getKey();
            definition = entry.getValue();
            try {
                definition.setEnumerator(this._enumeratorManager.lookup(enumeratorRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup enumerator role: '" + enumeratorRole + "' for parameter: " + String.valueOf(definition), e);
            }
        }
    }
}

