/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.core.model.ModelItemHelper;
import org.ametys.core.util.XMLUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractModelItem
implements ModelItem {
    protected static ServiceManager __serviceManager;
    protected static Context __context;
    private ModelItemHelper _modelItemHelper;
    private String _name;
    private String _pluginName;
    private I18nizableText _label;
    private I18nizableText _description;
    private Set<ItemCheckerDescriptor> _itemCheckers = new HashSet<ItemCheckerDescriptor>();
    private String _widget;
    private Map<String, I18nizableText> _widgetParams = new HashMap<String, I18nizableText>();
    private DisableConditions<? extends DisableCondition> _disableConditions;
    private Model _model;
    private ModelItemGroup _parent;
    private String _path;

    public AbstractModelItem() {
    }

    public AbstractModelItem(String name) {
        this._name = name;
    }

    public AbstractModelItem(ModelItem modelItemToCopy) {
        this.setName(modelItemToCopy.getName());
        this.setPluginName(modelItemToCopy.getPluginName());
        this.setLabel(modelItemToCopy.getLabel());
        this.setDescription(modelItemToCopy.getDescription());
        for (ItemCheckerDescriptor itemChecker : modelItemToCopy.getItemCheckers()) {
            this.addItemChecker(itemChecker);
        }
        this.setModel(modelItemToCopy.getModel());
        this.setParent(modelItemToCopy.getParent());
        this.setWidget(modelItemToCopy.getWidget());
        this.setWidgetParameters(modelItemToCopy.getWidgetParameters());
        this.setDisableConditions(modelItemToCopy.getDisableConditions());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
        this._path = null;
    }

    @Override
    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this._pluginName = pluginName;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    @Override
    public void addItemChecker(ItemCheckerDescriptor itemChecker) {
        this._itemCheckers.add(itemChecker);
    }

    @Override
    public Set<ItemCheckerDescriptor> getItemCheckers() {
        return Collections.unmodifiableSet(this._itemCheckers);
    }

    @Override
    public String getWidget() {
        return this._widget;
    }

    @Override
    public void setWidget(String widget) {
        this._widget = widget;
    }

    @Override
    public Map<String, I18nizableText> getWidgetParameters() {
        return this._widgetParams;
    }

    @Override
    public void setWidgetParameters(Map<String, I18nizableText> params) {
        this._widgetParams = params;
    }

    @Override
    public DisableConditions<? extends DisableCondition> getDisableConditions() {
        return this._disableConditions;
    }

    @Override
    public void setDisableConditions(DisableConditions disableConditions) {
        this._disableConditions = disableConditions;
    }

    @Override
    public String getPath() {
        if (this._path != null) {
            return this._path;
        }
        if (this.getName() == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        ModelItemGroup parent = this.getParent();
        if (parent != null && parent.getPath() != null) {
            path.append(parent.getPath()).append("/");
        }
        path.append(this.getName());
        this._path = path.toString();
        return this._path;
    }

    @Override
    public Model getModel() {
        return this._model;
    }

    @Override
    public void setModel(Model model) {
        this._model = model;
    }

    @Override
    public ModelItemGroup getParent() {
        return this._parent;
    }

    @Override
    public void setParent(ModelItemGroup parent) {
        this._parent = parent;
    }

    @Override
    public Map<String, Object> toJSON(DefinitionContext context) {
        if (this._shouldJSONBeEmpty(context)) {
            return Map.of();
        }
        return this._toJSON(context);
    }

    protected Map<String, Object> _toJSON(DefinitionContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DefinitionContext newContext = context.cloneContext().withModelItem(this);
        result.put("name", this.getName());
        result.put("plugin", this.getPluginName());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        result.put("path", this.getPath());
        if (!this.getItemCheckers().isEmpty()) {
            ArrayList<Map<String, Object>> checkers2json = new ArrayList<Map<String, Object>>();
            for (ItemCheckerDescriptor paramChecker : this.getItemCheckers()) {
                checkers2json.add(paramChecker.toJSON());
            }
            result.put("field-checker", checkers2json);
        }
        result.putAll(this._widgetToJSON(newContext));
        if (ModelHelper.hasDisableConditions(this)) {
            result.put("disableCondition", this.disableConditionsToJSON(newContext));
        }
        return result;
    }

    protected Map<String, Object> _widgetToJSON(DefinitionContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("widget", this.getWidget());
        Map<String, I18nizableText> widgetParameters = this.getWidgetParameters();
        if (widgetParameters != null && !widgetParameters.isEmpty()) {
            result.put("widget-params", widgetParameters);
        }
        return result;
    }

    protected Map<String, Object> disableConditionsToJSON(DefinitionContext context) {
        return this._getModelItemHelper().disableConditionsToJSON(this, context);
    }

    protected boolean _shouldJSONBeEmpty(DefinitionContext context) {
        return false;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        if (!this.getItemCheckers().isEmpty()) {
            for (ItemCheckerDescriptor paramChecker : this.getItemCheckers()) {
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"field-checker");
                paramChecker.toSAX(contentHandler);
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"field-checker");
            }
        }
        this._widgetToSAX(contentHandler, context);
        if (this.getDisableConditions() != null) {
            this._disableConditionsToSAX(contentHandler, this.getDisableConditions());
        }
    }

    protected void _widgetToSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        XMLUtils.createElementIfNotNull(contentHandler, "widget", this.getWidget());
        Map<String, I18nizableText> widgetParameters = this.getWidgetParameters();
        if (widgetParameters != null && !widgetParameters.isEmpty()) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"widget-params");
            for (Map.Entry<String, I18nizableText> param : widgetParameters.entrySet()) {
                this._widgetParameterToSAX(contentHandler, param.getKey(), param.getValue(), context);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"widget-params");
        }
    }

    protected void _widgetParameterToSAX(ContentHandler contentHandler, String parameterName, I18nizableText parameterValue, DefinitionContext context) throws SAXException {
        AttributesImpl paramAttributes = new AttributesImpl();
        paramAttributes.addCDATAAttribute("name", parameterName);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"param", (Attributes)paramAttributes);
        parameterValue.toSAX(contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"param");
    }

    private void _disableConditionsToSAX(ContentHandler contentHandler, DisableConditions<? extends DisableCondition> disableConditions) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addCDATAAttribute("type", disableConditions.getAssociationType().toString().toLowerCase());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"disable-conditions", (Attributes)attributes);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"conditions");
        for (DisableCondition disableCondition : disableConditions.getConditions()) {
            this._disableConditionToSAX(contentHandler, disableCondition);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"conditions");
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"nested-conditions");
        for (DisableConditions disableConditions2 : disableConditions.getSubConditions()) {
            this._disableConditionsToSAX(contentHandler, disableConditions2);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"nested-conditions");
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"disable-conditions");
    }

    private void _disableConditionToSAX(ContentHandler contentHandler, DisableCondition disableCondition) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addCDATAAttribute("id", disableCondition.getName());
        attributes.addCDATAAttribute("operator", disableCondition.getOperator().toString().toLowerCase());
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"condition", (Attributes)attributes, (String)disableCondition.getValue());
    }

    @Override
    public int compareTo(ModelItem item) {
        if (item == null) {
            return 1;
        }
        String name = this.getName();
        if (name != null) {
            return name.compareTo(item.getName());
        }
        I18nizableText label = this.getLabel();
        if (label != null) {
            I18nizableText otherLabel = item.getLabel();
            if (otherLabel == null) {
                return 1;
            }
            return label.toString().compareTo(otherLabel.toString());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ModelItem item = (ModelItem)obj;
        if (this.getModel() != item.getModel()) {
            if (this.getModel() == null ^ item.getModel() == null) {
                return false;
            }
            if (!Objects.equals(this.getModel().getFamilyId(), item.getModel().getFamilyId()) || !Objects.equals(this.getModel().getId(), item.getModel().getId())) {
                return false;
            }
        }
        if (this.getPath() != null || item.getPath() != null) {
            return Objects.equals(this.getPath(), item.getPath());
        }
        if (this.getLabel() != null || item.getLabel() != null) {
            return Objects.equals(this.getLabel(), item.getLabel());
        }
        return false;
    }

    public int hashCode() {
        if (this.getPath() != null) {
            return this.getPath().hashCode();
        }
        return this.getLabel().hashCode();
    }

    public String toString() {
        if (this.getPath() != null) {
            return this.getPath();
        }
        return this.getLabel().toString();
    }

    protected ModelItemHelper _getModelItemHelper() {
        if (this._modelItemHelper == null) {
            try {
                this._modelItemHelper = (ModelItemHelper)__serviceManager.lookup(ModelItemHelper.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Unable to lookup after the model item helper", e);
            }
        }
        return this._modelItemHelper;
    }

    public static void setServiceManager(ServiceManager manager) {
        __serviceManager = manager;
    }

    public static void setContext(Context context) {
        __context = context;
    }
}

