/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.model.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.ametys.runtime.util.ParameterizedTypesHelper;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractModelItemParser<D extends DisableConditions> {
    protected ModelItemTypeExtensionPoint _modelItemTypeExtensionPoint;
    protected ThreadSafeComponentManager<DisableConditions> _disableConditionsManager;
    protected final Map<String, ModelItem> _disableConditionsToLookup = new HashMap<String, ModelItem>();
    private Class<D> _disableConditionsType = ParameterizedTypesHelper.getFirstActualClassArgument(AbstractModelItemParser.class, this.getClass());

    public AbstractModelItemParser(ModelItemTypeExtensionPoint modelItemTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager) {
        this._modelItemTypeExtensionPoint = modelItemTypeExtensionPoint;
        this._disableConditionsManager = disableConditionsManager;
    }

    public <T extends ModelItem> T parse(ServiceManager serviceManager, String pluginName, Configuration itemConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        return this.parse(serviceManager, pluginName, "plugin." + pluginName, itemConfig, model, parent);
    }

    public <T extends ModelItem> T parse(ServiceManager serviceManager, String pluginName, String catalog, Configuration itemConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        ModelItem modelItem = this._createModelItem(itemConfig);
        modelItem.setModel(model);
        if (parent != null) {
            parent.addChild(modelItem);
        }
        modelItem.setName(this._parseName(itemConfig));
        modelItem.setPluginName(pluginName);
        modelItem.setLabel(this._parseI18nizableText(itemConfig, catalog, "label"));
        modelItem.setDescription(this._parseI18nizableText(itemConfig, catalog, "description"));
        modelItem.setType(this._parseType(itemConfig));
        modelItem.setWidget(this._parseWidget(itemConfig));
        modelItem.setWidgetParameters(this._parseWidgetParameters(itemConfig, pluginName));
        this._parseDisableConditions(itemConfig, pluginName, modelItem);
        return (T)modelItem;
    }

    protected abstract ModelItem _createModelItem(Configuration var1) throws ConfigurationException;

    protected String _parseName(Configuration itemConfig) throws ConfigurationException {
        return ItemParserHelper.parseName(itemConfig, this._getNameConfigurationAttribute());
    }

    protected String _getNameConfigurationAttribute() {
        return "name";
    }

    protected I18nizableText _parseI18nizableText(Configuration config, String catalog, String name) throws ConfigurationException {
        return I18nizableText.parseI18nizableText(config.getChild(name), catalog);
    }

    protected I18nizableText _parseI18nizableText(Configuration config, String catalog, String name, String defaultValueCatalog, String defaultValue) {
        return I18nizableText.parseI18nizableText(config.getChild(name), catalog, new I18nizableText(defaultValueCatalog, defaultValue));
    }

    protected ModelItemType _parseType(Configuration config) throws ConfigurationException {
        String typeId = config.getAttribute("type");
        if (!this._modelItemTypeExtensionPoint.hasExtension(typeId)) {
            String modelItemName = this._parseName(config);
            String availableTypes = StringUtils.join(this._modelItemTypeExtensionPoint.getExtensionsIds(), (String)", ");
            UnknownTypeException ute = new UnknownTypeException("The type '" + typeId + "' is not available for the extension point '" + String.valueOf(this._modelItemTypeExtensionPoint) + "'. Available types are: '" + availableTypes + "'.");
            throw new ConfigurationException("Unable to find the type '" + typeId + "' defined on the item '" + modelItemName + "'.", (Throwable)ute);
        }
        return (ModelItemType)this._modelItemTypeExtensionPoint.getExtension(typeId);
    }

    protected void _parseDisableConditions(Configuration definitionConfiguration, String pluginName, ModelItem modelItem) throws ConfigurationException {
        Configuration disableConditionsConfiguration = definitionConfiguration.getChild("disable-conditions", false);
        if (disableConditionsConfiguration != null) {
            Class<D> conditionsClass = this._disableConditionsType;
            String conditionsRole = String.valueOf(conditionsClass) + "$" + UUID.randomUUID().toString();
            this._disableConditionsManager.addComponent(pluginName, null, conditionsRole, conditionsClass, disableConditionsConfiguration);
            this._disableConditionsToLookup.put(conditionsRole, modelItem);
        }
    }

    protected String _parseWidget(Configuration definitionConfig) throws ConfigurationException {
        return ItemParserHelper.parseWidget(definitionConfig);
    }

    protected Map<String, I18nizableText> _parseWidgetParameters(Configuration definitionConfig, String pluginName) throws ConfigurationException {
        return ItemParserHelper.parseWidgetParameters(definitionConfig, pluginName);
    }

    public void lookupComponents() throws Exception {
        this._disableConditionsManager.initialize();
        for (Map.Entry<String, ModelItem> entry : this._disableConditionsToLookup.entrySet()) {
            String conditionsRole = entry.getKey();
            ModelItem modelItem = entry.getValue();
            try {
                modelItem.setDisableConditions(this._disableConditionsManager.lookup(conditionsRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup disable conditions role: '" + conditionsRole + "' for parameter: " + String.valueOf(modelItem), e);
            }
        }
    }
}

