/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemGroup;

public abstract class AbstractViewItemGroup
implements ViewItemGroup {
    protected String _role;
    protected I18nizableText _label;
    protected I18nizableText _description;
    protected List<ViewItem> _children = new ArrayList<ViewItem>();

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    @Override
    public String getRole() {
        return this._role;
    }

    @Override
    public void setRole(String role) {
        this._role = role;
    }

    @Override
    public List<ViewItem> getViewItems() {
        return Collections.unmodifiableList(this._children);
    }

    @Override
    public void addViewItem(ViewItem item) {
        this._children.add(item);
        item.setParent(this);
    }

    @Override
    public void insertViewItem(ViewItem item, int index) {
        if (index < 0 || index > this._children.size()) {
            throw new IllegalArgumentException("Unable to insert an item at index " + index + ". This group contains " + this._children.size() + " items.");
        }
        this._children.add(index, item);
        item.setParent(this);
    }

    @Override
    public boolean removeViewItem(ViewItem item) {
        return this._children.remove(item);
    }

    @Override
    public void clear() {
        this._children.clear();
    }

    @Override
    public void copyTo(ViewItem item) {
        assert (item instanceof AbstractViewItemGroup);
        AbstractViewItemGroup viewItemGroup = (AbstractViewItemGroup)item;
        viewItemGroup.setRole(this.getRole());
        viewItemGroup.setLabel(this.getLabel());
        viewItemGroup.setDescription(this.getDescription());
    }

    public int hashCode() {
        return Objects.hash(this._children);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractViewItemGroup other = (AbstractViewItemGroup)obj;
        return Objects.equals(this._children, other._children);
    }

    @Override
    public boolean equals(Object obj, boolean checkDetails) {
        if (!this.equals(obj)) {
            return false;
        }
        if (checkDetails) {
            AbstractViewItemGroup other = (AbstractViewItemGroup)obj;
            for (int i = 0; i < this._children.size(); ++i) {
                ViewItem otherChild;
                ViewItem child = this._children.get(i);
                if (child.equals(otherChild = other._children.get(i), checkDetails)) continue;
                return false;
            }
            return Objects.equals(this._label, other._label) && Objects.equals(this._description, other._description) && Objects.equals(this._role, other._role);
        }
        return true;
    }
}

