/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.ViewParser;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public abstract class AbstractViewParser
extends AbstractLogEnabled
implements ViewParser {
    protected static final String __VIEW_REFERENCE_REGEX = "\\[(.+)\\]";
    protected static final Pattern __VIEW_REFERENCE_PATTERN = Pattern.compile("^[^\\[]+\\[(.+)\\]$");

    @Override
    public View parseView(ItemParserHelper.ConfigurationAndPluginName viewConfiguration) throws ConfigurationException {
        View view = new View();
        view.setName(this._parseViewName(viewConfiguration));
        Collection<? extends Model> model = this._getModel();
        this._fillViewGeneralInformation(viewConfiguration, view, view, model);
        for (Configuration itemConfiguration : viewConfiguration.configuration().getChildren()) {
            this._parseViewChild(new ItemParserHelper.ConfigurationAndPluginName(itemConfiguration, viewConfiguration.pluginName()), view, model, false);
        }
        return view;
    }

    protected String _parseViewName(ItemParserHelper.ConfigurationAndPluginName viewConfiguration) throws ConfigurationException {
        return viewConfiguration.configuration().getAttribute("name");
    }

    @Override
    public View overrideView(ItemParserHelper.ConfigurationAndPluginName viewConfiguration, View existingView) throws ConfigurationException {
        View view = new View();
        view.setName(existingView.getName());
        Collection<? extends Model> model = this._getModel();
        this._fillViewGeneralInformation(viewConfiguration, view, existingView, model);
        view.addViewItems(existingView.getViewItems());
        for (Configuration itemConfiguration : viewConfiguration.configuration().getChildren()) {
            this._parseViewChild(new ItemParserHelper.ConfigurationAndPluginName(itemConfiguration, viewConfiguration.pluginName()), view, model, true);
        }
        return view;
    }

    protected abstract Collection<? extends Model> _getModel();

    protected void _fillViewGeneralInformation(ItemParserHelper.ConfigurationAndPluginName viewConfiguration, View view, View existingView, Collection<? extends Model> model) throws ConfigurationException {
        view.setInternal(viewConfiguration.configuration().getAttributeAsBoolean("internal", existingView.isInternal()));
        I18nizableText label = existingView.getLabel() == null ? ItemParserHelper.parseI18nizableText(viewConfiguration, "label", existingView.getName()) : ItemParserHelper.parseI18nizableText(viewConfiguration, "label", existingView.getLabel());
        view.setLabel(label);
        I18nizableText description = existingView.getDescription() == null ? ItemParserHelper.parseI18nizableText(viewConfiguration, "description") : ItemParserHelper.parseI18nizableText(viewConfiguration, "description", existingView.getDescription());
        view.setDescription(description);
    }

    protected void _parseViewChild(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, View view, Collection<? extends Model> model, boolean override) throws ConfigurationException {
        if (this._isAddingItemConfiguration(itemConfiguration.configuration())) {
            this._parseModelViewItem(itemConfiguration, view, model, view, override);
        } else if (this._isRemovingItemConfiguration(itemConfiguration.configuration())) {
            this._removeViewItemFromView(view, itemConfiguration.configuration());
        } else if (this._isAddingGroupConfiguration(itemConfiguration.configuration())) {
            this._parseSimpleViewItemGroup(itemConfiguration, "tab", view, model, view, override);
        }
    }

    protected boolean _isAddingItemConfiguration(Configuration itemConfiguration) {
        String itemConfigurationName = itemConfiguration.getName();
        return "item".equals(itemConfigurationName);
    }

    protected boolean _isRemovingItemConfiguration(Configuration itemConfiguration) {
        String itemConfigurationName = itemConfiguration.getName();
        return "remove-item".equals(itemConfigurationName);
    }

    protected boolean _isAddingGroupConfiguration(Configuration itemConfiguration) {
        String itemConfigurationName = itemConfiguration.getName();
        return "group".equals(itemConfigurationName);
    }

    protected void _parseModelViewItem(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, ViewItemAccessor parentViewItemAccessor, Collection<? extends ModelItemAccessor> parentModelItemAccessors, View referenceView, boolean override) throws ConfigurationException {
        String modelItemReference = this._getModelItemReference(itemConfiguration.configuration());
        Matcher viewReferenceMatcher = __VIEW_REFERENCE_PATTERN.matcher(modelItemReference);
        boolean hasViewReference = viewReferenceMatcher.matches();
        String modelItemPath = hasViewReference ? modelItemReference.replaceAll(__VIEW_REFERENCE_REGEX, "") : modelItemReference;
        int lastIndexOfItemPathSeparator = !hasViewReference ? modelItemPath.lastIndexOf("/") : modelItemPath.length();
        ViewItemAccessor finalParentViewItemAccessor = parentViewItemAccessor;
        Collection<? extends ModelItemAccessor> finalParentModelItemAccessors = parentModelItemAccessors;
        String modelItemName = modelItemPath;
        if (lastIndexOfItemPathSeparator > -1) {
            String parentRelativePath = modelItemPath.substring(0, lastIndexOfItemPathSeparator);
            finalParentViewItemAccessor = this._createViewItemAccessor(itemConfiguration.configuration(), parentRelativePath, parentViewItemAccessor, parentModelItemAccessors, referenceView, override);
            finalParentModelItemAccessors = List.of((ModelItemAccessor)((ModelViewItem)((Object)finalParentViewItemAccessor)).getDefinition());
            String string = modelItemName = !hasViewReference ? modelItemPath.substring(lastIndexOfItemPathSeparator + "/".length()) : "";
        }
        if (hasViewReference) {
            String viewName = viewReferenceMatcher.group(1);
            this._parseViewReference(viewName, finalParentViewItemAccessor, finalParentModelItemAccessors.iterator().next());
        } else if ("*".equals(modelItemName)) {
            this.parseAllModelViewItems(itemConfiguration, finalParentViewItemAccessor, finalParentModelItemAccessors, referenceView, override);
        } else {
            ModelItem modelItem = this._getModelItem(itemConfiguration, modelItemName, finalParentModelItemAccessors);
            ModelViewItem viewItem = this.createModelViewItem(itemConfiguration, modelItem, referenceView, override);
            this._addItemToViewItemAccessor(finalParentViewItemAccessor, viewItem, itemConfiguration.configuration(), referenceView, override);
        }
    }

    protected abstract void _parseViewReference(String var1, ViewItemAccessor var2, ModelItemAccessor var3) throws ConfigurationException;

    protected void parseAllModelViewItems(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, ViewItemAccessor parentViewItemAccessor, Collection<? extends ModelItemAccessor> parentModelItemAccessors, View referenceView, boolean override) throws ConfigurationException {
        for (ModelItem modelItem : ModelHelper.getModelItems(parentModelItemAccessors)) {
            ModelViewItem viewItem = this.createModelViewItemForAllItemsReference(itemConfiguration, modelItem, referenceView, override);
            this._addItemToViewItemAccessor(parentViewItemAccessor, viewItem, itemConfiguration.configuration(), referenceView, override);
            if (!(modelItem instanceof ModelItemContainer)) continue;
            ModelItemContainer modelItemContainer = (ModelItemContainer)((Object)modelItem);
            if (!(viewItem instanceof ViewItemContainer)) continue;
            ViewItemContainer viewItemContainer = (ViewItemContainer)((Object)viewItem);
            this.parseAllModelViewItems(itemConfiguration, viewItemContainer, List.of(modelItemContainer), referenceView, override);
        }
    }

    protected ModelViewItem createModelViewItemForAllItemsReference(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, ModelItem modelItem, View referenceView, boolean override) throws ConfigurationException {
        return this.createModelViewItem(itemConfiguration, modelItem, referenceView, override);
    }

    protected ModelViewItem createModelViewItem(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, ModelItem modelItem, View referenceView, boolean override) throws ConfigurationException {
        ModelViewItem viewItem;
        if (modelItem instanceof ModelItemGroup) {
            ModelItemGroup modelItemGroup = (ModelItemGroup)modelItem;
            viewItem = this._createModelViewItemInstance(modelItemGroup);
            for (Configuration childConfiguration : itemConfiguration.configuration().getChildren()) {
                this._parseViewItemAccessorChild(new ItemParserHelper.ConfigurationAndPluginName(childConfiguration, itemConfiguration.pluginName()), (ViewItemAccessor)((Object)viewItem), modelItemGroup, referenceView, override);
            }
        } else {
            viewItem = this._parseViewElement(itemConfiguration, (ElementDefinition)modelItem, referenceView, override);
        }
        if (itemConfiguration.configuration().getChild("label", false) != null) {
            viewItem.setLabel(ItemParserHelper.parseI18nizableText(itemConfiguration, "label"));
        }
        if (itemConfiguration.configuration().getChild("description", false) != null) {
            viewItem.setDescription(ItemParserHelper.parseI18nizableText(itemConfiguration, "description"));
        }
        return viewItem;
    }

    protected ViewItemAccessor _createViewItemAccessor(Configuration itemConfiguration, String modelItemAccessorPath, ViewItemAccessor viewItemAccessor, Collection<? extends ModelItemAccessor> modelItemAccessors, View referenceView, boolean override) throws ConfigurationException {
        int firstIndexOfItemPathSeparator = modelItemAccessorPath.indexOf("/");
        String firstPathSegment = firstIndexOfItemPathSeparator > -1 ? modelItemAccessorPath.substring(0, modelItemAccessorPath.indexOf("/")) : modelItemAccessorPath;
        ModelItem modelItem = ModelHelper.getModelItem(firstPathSegment, modelItemAccessors);
        if (modelItem instanceof ModelItemAccessor) {
            ModelViewItem viewItem = ViewHelper.createModelViewItemInstance(modelItem);
            viewItem.setDefinition(modelItem);
            this._addItemToViewItemAccessor(viewItemAccessor, viewItem, itemConfiguration, referenceView, override);
            if (firstIndexOfItemPathSeparator > -1) {
                String subPath = modelItemAccessorPath.substring(firstIndexOfItemPathSeparator + 1);
                return this._createViewItemAccessor(itemConfiguration, subPath, (ViewItemAccessor)((Object)viewItem), List.of((ModelItemAccessor)((Object)modelItem)), referenceView, override);
            }
            return (ViewItemAccessor)((Object)viewItem);
        }
        throw new ConfigurationException("Unable to get or create a view item accessor, the given path '" + modelItemAccessorPath + "' refers to a model item that is not an accessor");
    }

    protected ModelItem _getModelItem(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, String modelItemName, Collection<? extends ModelItemAccessor> parents) throws ConfigurationException {
        try {
            return ModelHelper.getModelItem(modelItemName, parents);
        }
        catch (IllegalArgumentException | UndefinedItemPathException e) {
            throw new ConfigurationException("The item '" + modelItemName + "' is not defined in model.", itemConfiguration.configuration(), (Throwable)e);
        }
    }

    protected String _getModelItemReference(Configuration itemConfiguration) throws ConfigurationException {
        return itemConfiguration.getAttribute("ref");
    }

    protected Configuration _getAddItemChildConfiguration(Configuration accessorConfiguration) {
        return accessorConfiguration.getChild("item", false);
    }

    protected ViewElement _parseViewElement(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, ElementDefinition definition, View referenceView, boolean override) throws ConfigurationException {
        return (ViewElement)this._createModelViewItemInstance(definition);
    }

    protected ModelViewItem _createModelViewItemInstance(ModelItem modelItem) {
        ModelViewItem modelViewItem = ViewHelper.createModelViewItemInstance(modelItem);
        modelViewItem.setDefinition(modelItem);
        return modelViewItem;
    }

    protected void _parseViewItemAccessorChild(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, ViewItemAccessor viewItemAccessor, ModelItemAccessor modelItemAccessor, View referenceView, boolean override) throws ConfigurationException {
        if (this._isAddingItemConfiguration(itemConfiguration.configuration())) {
            this._parseModelViewItem(itemConfiguration, viewItemAccessor, List.of(modelItemAccessor), referenceView, override);
        } else if (this._isAddingGroupConfiguration(itemConfiguration.configuration())) {
            this._parseSimpleViewItemGroup(itemConfiguration, "fieldset", viewItemAccessor, List.of(modelItemAccessor), referenceView, override);
        }
    }

    protected void _parseSimpleViewItemGroup(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, String role, ViewItemAccessor parent, Collection<? extends ModelItemAccessor> modelItemAccessors, View referenceView, boolean override) throws ConfigurationException {
        SimpleViewItemGroup group = new SimpleViewItemGroup();
        group.setRole(itemConfiguration.configuration().getAttribute("role", role));
        group.setName(itemConfiguration.configuration().getAttribute("name", null));
        group.setLabel(ItemParserHelper.parseI18nizableText(itemConfiguration, "label"));
        group.setDescription(ItemParserHelper.parseI18nizableText(itemConfiguration, "description"));
        for (Configuration childConfiguration : itemConfiguration.configuration().getChildren()) {
            this._parseSimpleViewItemGroupChild(new ItemParserHelper.ConfigurationAndPluginName(childConfiguration, itemConfiguration.pluginName()), group, modelItemAccessors, referenceView, override);
        }
        this._addItemToViewItemAccessor(parent, group, itemConfiguration.configuration(), referenceView, override);
    }

    protected void _parseSimpleViewItemGroupChild(ItemParserHelper.ConfigurationAndPluginName itemConfiguration, SimpleViewItemGroup group, Collection<? extends ModelItemAccessor> modelItemAccessors, View referenceView, boolean override) throws ConfigurationException {
        if (this._isAddingItemConfiguration(itemConfiguration.configuration())) {
            this._parseModelViewItem(itemConfiguration, group, modelItemAccessors, referenceView, override);
        } else if (this._isAddingGroupConfiguration(itemConfiguration.configuration())) {
            this._parseSimpleViewItemGroup(itemConfiguration, "fieldset", group, modelItemAccessors, referenceView, override);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _addItemToViewItemAccessor(ViewItemAccessor viewItemAccessor, ViewItem viewItem, Configuration itemConfiguration, View referenceView, boolean override) throws ConfigurationException {
        ModelViewItem modelViewItem;
        if (this.getLogger().isWarnEnabled() && viewItem instanceof ModelViewItem && (viewItemAccessor.hasModelViewItem(modelViewItem = (ModelViewItem)viewItem) || referenceView.hasModelViewItem(modelViewItem))) {
            String itemPath = modelViewItem.getDefinition().getPath();
            this.getLogger().warn("The item '" + itemPath + "' is already referenced by the view '" + referenceView.getName() + "'.");
        }
        if (viewItemAccessor instanceof View) {
            View view = (View)viewItemAccessor;
            if (override) {
                this._addItemToOverriddenView(view, viewItem, itemConfiguration);
                return;
            }
        }
        viewItemAccessor.addViewItem(viewItem);
    }

    protected void _addItemToOverriddenView(View view, ViewItem viewItem, Configuration itemConfiguration) throws ConfigurationException {
        String group = itemConfiguration.getAttribute("group", null);
        ViewItemContainer viewItemAccessor = view;
        if (group != null) {
            try {
                viewItemAccessor = ViewHelper.getSimpleViewItemGroup(view, group);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("The path to the requested group where to add the view item " + viewItem.getName() + " in the initial view " + view.getName() + " is empty.", itemConfiguration, (Throwable)e);
            }
            catch (UndefinedItemPathException e) {
                this.getLogger().warn("The group requested " + group + " does not exist in the initial view " + view.getName() + ". The item '" + viewItem.getName() + "' will be inserted at the end of the view", (Throwable)e);
            }
        }
        this._insertItemInViewItemAccessor(viewItemAccessor, viewItem, itemConfiguration);
    }

    protected void _insertItemInViewItemAccessor(ViewItemAccessor viewItemAccessor, ViewItem viewItem, Configuration itemConfiguration) throws ConfigurationException {
        String before = itemConfiguration.getAttribute("order-before", null);
        String after = itemConfiguration.getAttribute("order-after", null);
        if (after != null && before != null) {
            throw new ConfigurationException("The item " + viewItem.getName() + " cannot be added both after and before attributes", itemConfiguration);
        }
        if (after != null || before != null) {
            ViewHelper.InsertMode insertMode = after != null ? ViewHelper.InsertMode.AFTER : ViewHelper.InsertMode.BEFORE;
            String insertAfterOrBefore = after != null ? after : before;
            try {
                ViewHelper.insertItemAfterOrBefore(viewItemAccessor, viewItem, insertAfterOrBefore, insertMode);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Unable to insert view item " + viewItem.getName() + " " + String.valueOf((Object)insertMode) + " the specified view item. The name is empty or is a path.", itemConfiguration, (Throwable)e);
            }
            catch (UndefinedItemPathException e) {
                if (this.getLogger().isWarnEnabled()) {
                    String string;
                    if (viewItemAccessor instanceof View) {
                        View view = (View)viewItemAccessor;
                        string = view.getName();
                    } else if (viewItemAccessor instanceof ViewItem) {
                        ViewItem vI = (ViewItem)((Object)viewItemAccessor);
                        string = vI.getName();
                    } else {
                        string = viewItemAccessor.toString();
                    }
                    String viewItemAccessorName = string;
                    this.getLogger().warn("Unable to insert view item " + viewItem.getName() + " " + String.valueOf((Object)insertMode) + " the view item named " + insertAfterOrBefore + ". No view item has been found with this name. This item will be inserted at the end of the view item accessor '" + viewItemAccessorName + "'.", (Throwable)e);
                }
                viewItemAccessor.addViewItem(viewItem);
            }
        } else {
            viewItemAccessor.addViewItem(viewItem);
        }
    }

    protected void _removeViewItemFromView(View view, Configuration itemConfiguration) throws ConfigurationException {
        String viewItemPath = itemConfiguration.getAttribute("ref");
        try {
            ViewItem viewItem = ViewHelper.getViewItem(view, viewItemPath);
            ViewItemAccessor parent = viewItem.getParent();
            parent.removeViewItem(viewItem);
        }
        catch (Exception e) {
            this.getLogger().warn("[View Item removal] Unable to remove " + viewItemPath + " from " + view.getName(), (Throwable)e);
        }
    }
}

