/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.CategorizedElementDefinitionWrapper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.ValidationResults;
import org.slf4j.Logger;

public final class CategorizedElementDefinitionHelper {
    private CategorizedElementDefinitionHelper() {
    }

    public static <T extends CategorizedElementDefinitionWrapper> View buildViewFromCategories(Collection<T> wrappers, Comparator<I18nizableText> categoriesComparator, Comparator<I18nizableText> groupsComparator, Comparator<T> elementsComparator) {
        View view = new View();
        Map<I18nizableText, Map<I18nizableText, List<T>>> categories = CategorizedElementDefinitionHelper.categorizeElementDefinitionWrappers(wrappers);
        Collection<I18nizableText> sortedCategories = CategorizedElementDefinitionHelper.sortItemsList(categories.keySet(), categoriesComparator);
        for (I18nizableText categoryLabel : sortedCategories) {
            ViewItem categoryViewItem = CategorizedElementDefinitionHelper._buildCategoryViewItem(categoryLabel, categories.get(categoryLabel), groupsComparator, elementsComparator);
            view.addViewItem(categoryViewItem);
        }
        return view;
    }

    public static <T extends CategorizedElementDefinitionWrapper> Map<I18nizableText, Map<I18nizableText, List<T>>> categorizeElementDefinitionWrappers(Collection<T> wrappers) {
        HashMap<I18nizableText, Map<I18nizableText, List<T>>> categories = new HashMap<I18nizableText, Map<I18nizableText, List<T>>>();
        for (CategorizedElementDefinitionWrapper parameter : wrappers) {
            ArrayList<CategorizedElementDefinitionWrapper> group;
            I18nizableText displayCategory = parameter.getDisplayCategory();
            I18nizableText displayGroup = parameter.getDisplayGroup();
            HashMap<I18nizableText, ArrayList<CategorizedElementDefinitionWrapper>> category = (HashMap<I18nizableText, ArrayList<CategorizedElementDefinitionWrapper>>)categories.get(displayCategory);
            if (category == null) {
                category = new HashMap<I18nizableText, ArrayList<CategorizedElementDefinitionWrapper>>();
                categories.put(displayCategory, category);
            }
            if ((group = (ArrayList<CategorizedElementDefinitionWrapper>)category.get(displayGroup)) == null) {
                group = new ArrayList<CategorizedElementDefinitionWrapper>();
                category.put(displayGroup, group);
            }
            group.add(parameter);
        }
        return categories;
    }

    private static <T extends CategorizedElementDefinitionWrapper> ViewItem _buildCategoryViewItem(I18nizableText categoryLabel, Map<I18nizableText, List<T>> groups, Comparator<I18nizableText> groupsComparator, Comparator<T> elementsComparator) throws IllegalArgumentException {
        SimpleViewItemGroup categoryViewItem = new SimpleViewItemGroup();
        categoryViewItem.setRole("tab");
        categoryViewItem.setLabel(categoryLabel);
        Collection<I18nizableText> sortedGroups = CategorizedElementDefinitionHelper.sortItemsList(groups.keySet(), groupsComparator);
        for (I18nizableText groupLabel : sortedGroups) {
            ViewItem groupViewItem = CategorizedElementDefinitionHelper._buildGroupViewItem(groupLabel, groups.get(groupLabel), elementsComparator);
            categoryViewItem.addViewItem(groupViewItem);
        }
        return categoryViewItem;
    }

    private static <T extends CategorizedElementDefinitionWrapper> ViewItem _buildGroupViewItem(I18nizableText groupLabel, List<T> wrappers, Comparator<T> elementsComparator) throws IllegalArgumentException {
        SimpleViewItemGroup groupViewItem = new SimpleViewItemGroup();
        groupViewItem.setRole("fieldset");
        groupViewItem.setLabel(groupLabel);
        Collection<CategorizedElementDefinitionWrapper> items = CategorizedElementDefinitionHelper.sortItemsList(wrappers, elementsComparator);
        for (CategorizedElementDefinitionWrapper item : items) {
            ViewElement parameterViewItem = new ViewElement();
            parameterViewItem.setDefinition(item.getDefinition());
            groupViewItem.addViewItem(parameterViewItem);
        }
        return groupViewItem;
    }

    public static <T> Collection<T> sortItemsList(Collection<T> items, Comparator<T> comparator) {
        if (comparator == null) {
            return items;
        }
        ArrayList<T> sorted = new ArrayList<T>(items);
        sorted.sort(comparator);
        return sorted;
    }

    public static ValidationResults validateValuesForWriting(Map<String, Object> values, Collection<? extends ElementDefinition> definitions, DisableConditionsEvaluator disableConditionsEvaluator, Logger logger) {
        ValidationResults results = new ValidationResults();
        for (ElementDefinition elementDefinition : definitions) {
            boolean isGroupSwitchOn = ModelHelper.isGroupSwitchOn(elementDefinition, values);
            boolean isDisabled = disableConditionsEvaluator.evaluateDisableConditions((ModelItem)elementDefinition, elementDefinition.getName(), values);
            if (!isGroupSwitchOn || isDisabled) continue;
            Object value = values.get(elementDefinition.getName());
            ValidationResult result = ModelHelper.validateValue(elementDefinition, value);
            results.addResult(elementDefinition.getName(), result);
            if (!result.hasErrors()) continue;
            logger.warn("The configuration parameter '{}' is not valid", (Object)elementDefinition.getName());
        }
        if (results.hasErrors()) {
            logger.debug("Failed to save configuration because of invalid parameter values");
        }
        return results;
    }

    public static <T extends CategorizedElementDefinitionWrapper> int compareWrapperPositions(T wrapper1, T wrapper2) {
        return CategorizedElementDefinitionHelper.comparePositions(wrapper1.getPosition(), wrapper2.getPosition());
    }

    public static int comparePositions(Long position1, Long position2) {
        int positionComparison = position1.compareTo(position2);
        if (position1 < 0L && position2 < 0L) {
            positionComparison = 0;
        } else if (position1 < 0L && position2 >= 0L) {
            positionComparison = 1;
        } else if (position2 < 0L) {
            positionComparison = -1;
        }
        return positionComparison;
    }
}

