/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import org.ametys.runtime.model.AbstractElementDefinitionParser;
import org.ametys.runtime.model.CategorizedElementDefinitionWrapper;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;

public class CategorizedElementDefinitionParser {
    private AbstractElementDefinitionParser<? extends DisableConditions> _parser;

    public CategorizedElementDefinitionParser(AbstractElementDefinitionParser<? extends DisableConditions> parser) {
        this._parser = parser;
    }

    public CategorizedElementDefinitionWrapper parse(ServiceManager serviceManager, String pluginName, Configuration definitionConfig, Model model, ModelItemGroup parent) throws ConfigurationException {
        ElementDefinition definition = (ElementDefinition)this._parser.parse(serviceManager, pluginName, definitionConfig, model, parent);
        CategorizedElementDefinitionWrapper elementDefinitionWrapper = this._createElementDefinitionWrapper();
        elementDefinitionWrapper.setDefinition(definition);
        ItemParserHelper.ConfigurationAndPluginName definitionConfigAndPluginName = new ItemParserHelper.ConfigurationAndPluginName(definitionConfig, pluginName);
        elementDefinitionWrapper.setDisplayCategory(ItemParserHelper.parseI18nizableText(definitionConfigAndPluginName, "category"));
        elementDefinitionWrapper.setDisplayGroup(ItemParserHelper.parseI18nizableText(definitionConfigAndPluginName, "group"));
        elementDefinitionWrapper.setPosition(definitionConfig.getChild("order").getValueAsLong(-1L));
        return elementDefinitionWrapper;
    }

    protected CategorizedElementDefinitionWrapper _createElementDefinitionWrapper() {
        return new CategorizedElementDefinitionWrapper();
    }
}

