/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractModelItem;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DefaultElementDefinition<T>
extends AbstractModelItem
implements ElementDefinition<T> {
    protected Logger _logger = LoggerFactory.getLogger(this.getClass());
    private ElementType<T> _type;
    private Enumerator<T> _enumerator;
    private String _customEnumerator;
    private Configuration _enumeratorConfiguration;
    private Validator _validator;
    private String _customValidator;
    private Configuration _validatorConfiguration;
    private boolean _isMultiple;
    private List<Pair<String, Object>> _parsedDefaultValues;

    public DefaultElementDefinition() {
    }

    public DefaultElementDefinition(String name, boolean isMultiple, ElementType<T> type) {
        super(name);
        this._type = type;
        this._isMultiple = isMultiple;
    }

    public DefaultElementDefinition(ElementDefinition<T> definitionToCopy) {
        super(definitionToCopy);
        this.setType(definitionToCopy.getType());
        this.setEnumerator(definitionToCopy.getEnumerator());
        this.setCustomEnumerator(definitionToCopy.getCustomEnumerator());
        this.setEnumeratorConfiguration(definitionToCopy.getEnumeratorConfiguration());
        this.setValidator(definitionToCopy.getValidator());
        this.setCustomValidator(definitionToCopy.getCustomValidator());
        this.setValidatorConfiguration(definitionToCopy.getValidatorConfiguration());
        this.setParsedDefaultValues(definitionToCopy.getParsedDefaultValues());
        this.setMultiple(definitionToCopy.isMultiple());
    }

    @Override
    public ElementType<T> getType() {
        return this._type;
    }

    @Override
    public void setType(ModelItemType type) {
        if (!(type instanceof ElementType)) {
            throw new IllegalArgumentException("Unable to set the type '" + String.valueOf(type.getClass()) + "' on the element type '" + this.getName() + "'");
        }
        this._type = (ElementType)type;
    }

    @Override
    public Enumerator<T> getEnumerator() {
        return this._enumerator;
    }

    @Override
    public void setEnumerator(Enumerator<T> enumerator) {
        this._enumerator = enumerator;
    }

    @Override
    public String getCustomEnumerator() {
        return this._customEnumerator;
    }

    @Override
    public void setCustomEnumerator(String customEnumerator) {
        this._customEnumerator = customEnumerator;
    }

    @Override
    public Configuration getEnumeratorConfiguration() {
        return this._enumeratorConfiguration;
    }

    @Override
    public void setEnumeratorConfiguration(Configuration enumeratorConfiguration) {
        this._enumeratorConfiguration = enumeratorConfiguration;
    }

    @Override
    public Validator getValidator() {
        if (this.isEditable()) {
            return this._validator;
        }
        throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a validator");
    }

    @Override
    public void setValidator(Validator validator) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a validator");
        }
        this._validator = validator;
    }

    @Override
    public String getCustomValidator() {
        if (this.isEditable()) {
            return this._customValidator;
        }
        throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a validator");
    }

    @Override
    public void setCustomValidator(String customValidator) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a validator");
        }
        this._customValidator = customValidator;
    }

    @Override
    public Configuration getValidatorConfiguration() {
        if (this.isEditable()) {
            return this._validatorConfiguration;
        }
        throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a validator configuration");
    }

    @Override
    public String getWidget() {
        if (this.isEditable()) {
            return super.getWidget();
        }
        throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a widget");
    }

    @Override
    public void setWidget(String widget) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a widget");
        }
        super.setWidget(widget);
    }

    @Override
    public Map<String, I18nizableText> getWidgetParameters() {
        if (this.isEditable()) {
            return super.getWidgetParameters();
        }
        throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have widget parameters");
    }

    @Override
    public void setWidgetParameters(Map<String, I18nizableText> params) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have widget parameters");
        }
        super.setWidgetParameters(params);
    }

    @Override
    public void setValidatorConfiguration(Configuration validatorConfiguration) {
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("The definition '" + this.getPath() + "' is not editable, it cannot have a validator configuration");
        }
        this._validatorConfiguration = validatorConfiguration;
    }

    @Override
    public <X> X getDefaultValue() {
        if (this._parsedDefaultValues != null) {
            if (this.isMultiple()) {
                ArrayList<T> defaultValues = new ArrayList<T>();
                for (Pair<String, Object> parsedDefaultValue : this._parsedDefaultValues) {
                    List<T> defaultValue = this._getDefaultValues((String)parsedDefaultValue.getLeft(), parsedDefaultValue.getRight());
                    defaultValues.addAll(defaultValue);
                }
                Object[] defaultValuesAsArray = (Object[])Array.newInstance(this.getType().getManagedClass(), defaultValues.size());
                return (X)defaultValues.toArray(defaultValuesAsArray);
            }
            if (!this._parsedDefaultValues.isEmpty()) {
                Pair<String, Object> parsedDefaultValue;
                List<T> defaultValue;
                if (this._parsedDefaultValues.size() > 1) {
                    this._logger.warn("the data '" + String.valueOf(this) + "' is single, only the first declared default value will be used");
                }
                return (defaultValue = this._getDefaultValues((String)(parsedDefaultValue = this._parsedDefaultValues.get(0)).getLeft(), parsedDefaultValue.getRight())).isEmpty() ? null : (X)defaultValue.get(0);
            }
            return null;
        }
        return null;
    }

    protected List<T> _getDefaultValues(String defaultValueType, Object parsedDefaultValue) {
        if ("config".equals(defaultValueType) && parsedDefaultValue instanceof String) {
            String configParameterName = (String)parsedDefaultValue;
            ElementDefinition configParameter = (ElementDefinition)ConfigManager.getInstance().getModelItem(configParameterName);
            if (configParameter.isMultiple()) {
                Object[] configParameterValues = (Object[])Config.getInstance().getValue(configParameterName);
                return Arrays.asList(configParameterValues);
            }
            Object configParameterValue = Config.getInstance().getValue(configParameterName);
            ArrayList defaultValues = new ArrayList();
            defaultValues.add(configParameterValue);
            return defaultValues;
        }
        ArrayList<T> defaultValues = new ArrayList<T>();
        defaultValues.add(this._getSimpleDefaultValue(parsedDefaultValue));
        return defaultValues;
    }

    protected T _getSimpleDefaultValue(Object parsedDefaultValue) {
        return this.getType().castValue(parsedDefaultValue);
    }

    @Override
    public void setParsedDefaultValues(List<Pair<String, Object>> parsedDefaultValues) {
        this._parsedDefaultValues = parsedDefaultValues;
    }

    @Override
    public void setDefaultValue(T defaultValue) {
        this._parsedDefaultValues = List.of(new ImmutablePair(null, defaultValue));
    }

    @Override
    public List<Pair<String, Object>> getParsedDefaultValues() {
        return this._parsedDefaultValues;
    }

    @Override
    public boolean isMultiple() {
        return this._isMultiple;
    }

    @Override
    public void setMultiple(boolean isMultiple) {
        this._isMultiple = isMultiple;
    }

    @Override
    protected Map<String, Object> _toJSON(DefinitionContext context) {
        Map<String, Object> result = super._toJSON(context);
        result.put("multiple", this.isMultiple());
        if (this.getType() != null) {
            result.put("type", this.getType().getId());
            result.put("default-value", this._defaultValueToJSON(context));
        }
        if (this.isEditable() && this.getValidator() != null) {
            result.put("validation", this.getValidator().getConfiguration());
        }
        if (this.getEnumerator() != null) {
            ArrayList enumeration = new ArrayList();
            try {
                Map<T, I18nizableText> entries = this.getEnumerator().getEntries();
                for (Map.Entry<T, I18nizableText> entry : entries.entrySet()) {
                    HashMap<String, Object> option = new HashMap<String, Object>();
                    option.put("value", this.getType().valueToJSONForClient(entry.getKey(), DataContext.newInstance()));
                    option.put("label", entry.getValue());
                    enumeration.add(option);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to enumerate entries with enumerator: " + String.valueOf(this.getEnumerator()), e);
            }
            result.put("enumeration", enumeration);
            result.put("enumerationConfig", this.getEnumerator().getConfiguration());
        }
        return result;
    }

    protected Object _defaultValueToJSON(DefinitionContext context) {
        return this.getType().valueToJSONForClient(this.getDefaultValue(), DataContext.newInstance());
    }

    @Override
    protected Map<String, Object> _widgetToJSON(DefinitionContext context) {
        return this.isEditable() ? super._widgetToJSON(context) : new HashMap();
    }

    @Override
    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        super.toSAX(contentHandler, context);
        if (this.getType() != null) {
            this.getType().valueToSAX(contentHandler, "default-value", this.getDefaultValue(), DataContext.newInstance());
            if (this.getEnumerator() != null) {
                XMLUtils.startElement((ContentHandler)contentHandler, (String)"enumeration");
                try {
                    Map<T, I18nizableText> entries = this.getEnumerator().getEntries();
                    for (Map.Entry<String, Object> entry : entries.entrySet()) {
                        XMLUtils.startElement((ContentHandler)contentHandler, (String)"entry");
                        this.getType().valueToSAX(contentHandler, "value", entry.getKey(), DataContext.newInstance());
                        ((I18nizableText)entry.getValue()).toSAX(contentHandler, "label");
                        XMLUtils.endElement((ContentHandler)contentHandler, (String)"entry");
                    }
                }
                catch (Exception e) {
                    throw new SAXException("Unable to enumerate entries with enumerator: " + String.valueOf(this.getEnumerator()), e);
                }
                XMLUtils.endElement((ContentHandler)contentHandler, (String)"enumeration");
            }
        }
        if (this.isEditable() && this.getValidator() != null) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"validation");
            Map<String, Object> configuration = this.getValidator().getConfiguration();
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                DefaultElementDefinition._validatorConfigurationObjectToSAX(contentHandler, entry.getKey(), entry.getValue());
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"validation");
        }
    }

    private static void _validatorConfigurationObjectToSAX(ContentHandler handler, String name, Object value) throws SAXException {
        if (value instanceof I18nizableText) {
            ((I18nizableText)value).toSAX(handler, name);
        } else if (value instanceof Collection) {
            for (Object item : (Collection)value) {
                if (item == null) continue;
                DefaultElementDefinition._validatorConfigurationObjectToSAX(handler, name, item);
            }
        } else if (value instanceof Map) {
            XMLUtils.startElement((ContentHandler)handler, (String)name);
            for (Map.Entry subEntry : ((Map)value).entrySet()) {
                DefaultElementDefinition._validatorConfigurationObjectToSAX(handler, (String)subEntry.getKey(), subEntry.getValue());
            }
            XMLUtils.endElement((ContentHandler)handler, (String)name);
        } else if (value instanceof Object[]) {
            for (Object item : (Object[])value) {
                if (item == null) continue;
                DefaultElementDefinition._validatorConfigurationObjectToSAX(handler, name, item);
            }
        } else {
            XMLUtils.createElement((ContentHandler)handler, (String)name, (String)String.valueOf(value));
        }
    }

    @Override
    protected void _widgetToSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        if (this.isEditable()) {
            super._widgetToSAX(contentHandler, context);
        }
    }

    public static DefaultElementDefinition of(String name, boolean isMultiple, String typeId, String availableTypesExtensionPoint) throws UnknownTypeException, BadItemTypeException, ServiceException {
        ExtensionPoint availableTypes = (ExtensionPoint)__serviceManager.lookup(availableTypesExtensionPoint);
        if (!availableTypes.hasExtension(typeId)) {
            throw new UnknownTypeException("The type '" + typeId + "' (used for data '" + name + "') is not available for the given extension point.");
        }
        ModelItemType type = (ModelItemType)availableTypes.getExtension(typeId);
        if (!(type instanceof ElementType)) {
            throw new BadItemTypeException("The type '" + typeId + "' (used for data '" + name + "') can not be used for an element definition.");
        }
        return new DefaultElementDefinition(name, isMultiple, (ElementType)type);
    }
}

