/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.Optional;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.apache.commons.lang3.StringUtils;

public final class DefinitionContext {
    private Optional<Object> _object = Optional.empty();
    private boolean _isEdition;
    private Optional<String> _itemTagName = Optional.empty();
    private Optional<ModelItem> _modelItem = Optional.empty();
    private Optional<View> _view = Optional.empty();

    private DefinitionContext() {
    }

    private DefinitionContext(DefinitionContext context) {
        this.withEdition(context.isEdition());
        this.withObject(context.getObject().orElse(null));
        this.withItemTagName(context.getItemTagName().orElse(null));
        this.withModelItem(context.getModelItem().orElse(null));
        this.withView(context.getView().orElse(null));
    }

    public static DefinitionContext newInstance() {
        return new DefinitionContext();
    }

    public static DefinitionContext newInstance(DefinitionContext context) {
        return new DefinitionContext(context);
    }

    public DefinitionContext cloneContext() {
        return DefinitionContext.newInstance(this);
    }

    public Optional<Object> getObject() {
        return this._object;
    }

    public DefinitionContext withObject(Object object) {
        this._object = Optional.ofNullable(object);
        return this;
    }

    public boolean isEdition() {
        return this._isEdition;
    }

    public DefinitionContext withEdition(boolean isEdition) {
        this._isEdition = isEdition;
        return this;
    }

    public Optional<String> getItemTagName() {
        return this._itemTagName;
    }

    public DefinitionContext withItemTagName(String itemTagName) {
        this._itemTagName = Optional.ofNullable(itemTagName).filter(StringUtils::isNotEmpty);
        return this;
    }

    public Optional<ModelItem> getModelItem() {
        return this._modelItem;
    }

    public DefinitionContext withModelItem(ModelItem modelItem) {
        this._modelItem = Optional.ofNullable(modelItem);
        return this;
    }

    public Optional<View> getView() {
        return this._view;
    }

    public DefinitionContext withView(View view) {
        this._view = Optional.ofNullable(view);
        return this;
    }
}

