/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemParserHelper {
    private static final Logger __LOGGER = LoggerFactory.getLogger(ModelHelper.class);

    private ItemParserHelper() {
    }

    public static String parseName(Configuration itemConfig, String nameConfigurationAttribute) throws ConfigurationException {
        return ItemParserHelper.parseName(itemConfig, nameConfigurationAttribute, true);
    }

    public static String parseName(Configuration itemConfig, String nameConfigurationAttribute, boolean acceptDots) throws ConfigurationException {
        String regex;
        String itemName = itemConfig.getAttribute(nameConfigurationAttribute);
        String string = regex = acceptDots ? "^[a-zA-Z]((?!__)[a-zA-Z0-9_\\.-])*$" : "^[a-zA-Z]((?!__)[a-zA-Z0-9_-])*$";
        if (!itemName.matches(regex)) {
            StringBuilder message = new StringBuilder().append("Invalid model item name: ").append(itemName).append(".").append(" The item name must start with a letter and must contain only letters, digits, underscores").append(acceptDots ? ", dots " : " ").append("or dashes.");
            throw new ConfigurationException(message.toString(), itemConfig);
        }
        return itemName;
    }

    public static Boolean parseMultiple(Configuration itemConfig) throws ConfigurationException {
        return itemConfig.getAttributeAsBoolean("multiple", false);
    }

    public static List<Pair<String, Object>> parseDefaultValues(Configuration itemConfig, ElementDefinition definition, DefaultValueParser defaultValueParser) throws ConfigurationException {
        Configuration[] defaultValueConfigs = itemConfig.getChildren("default-value");
        if (defaultValueConfigs.length > 0) {
            ArrayList<Pair<String, Object>> defaultValues = new ArrayList<Pair<String, Object>>();
            for (Configuration defaultValueConfig : defaultValueConfigs) {
                String defaultValueType = defaultValueConfig.getAttribute("type", null);
                Object defaultValue = defaultValueParser.parseDefaultValue(defaultValueConfig, definition, defaultValueType);
                defaultValues.add((Pair<String, Object>)new ImmutablePair((Object)defaultValueType, defaultValue));
            }
            return defaultValues;
        }
        return null;
    }

    public static Object parseDefaultValue(Configuration defaultValueConfig, ElementDefinition definition, String defaultValueType) throws ConfigurationException {
        ModelItemType type = definition.getType();
        if (defaultValueType != null) {
            if ("config".equals(defaultValueType)) {
                String configParamName = defaultValueConfig.getValue();
                if (ConfigManager.getInstance().hasModelItem(configParamName)) {
                    ModelItem configParamDefinition = ConfigManager.getInstance().getModelItem(configParamName);
                    String configParamTypeId = configParamDefinition.getType().getId();
                    if (configParamTypeId.equals(type.getId())) {
                        return configParamName;
                    }
                    throw new ConfigurationException("The configuration parameter '" + configParamName + " (" + configParamTypeId + ")' cannot be used as default value for item '" + definition.getPath() + " (" + type.getId() + ")': types are not the same.", defaultValueConfig);
                }
                throw new ConfigurationException("The configuration parameter '" + configParamName + "' does not exist, it cannot be used as default value for item '" + definition.getPath() + " (" + type.getId() + ")'.", defaultValueConfig);
            }
            throw new ConfigurationException("The type '" + defaultValueType + "' is not available for the default value of item '" + definition.getPath() + " (" + type.getId() + ")'.", defaultValueConfig);
        }
        return type.parseDefaultValue(defaultValueConfig);
    }

    public static String parseWidget(Configuration itemConfig) throws ConfigurationException {
        return itemConfig.getChild("widget").getValue(null);
    }

    public static Map<String, I18nizableText> parseWidgetParameters(Configuration itemConfig, String pluginName) throws ConfigurationException {
        HashMap<String, I18nizableText> widgetParams = new HashMap<String, I18nizableText>();
        Configuration widgetParamsConfig = itemConfig.getChild("widget-params", false);
        if (widgetParamsConfig != null) {
            Map<String, Object> parsedParams = ConfigurationHelper.parsePluginParameters(widgetParamsConfig, pluginName, __LOGGER);
            for (Map.Entry<String, Object> param : parsedParams.entrySet()) {
                String paramName = param.getKey();
                Object value = param.getValue();
                if (value instanceof I18nizableText) {
                    widgetParams.put(paramName, (I18nizableText)value);
                    continue;
                }
                if (value instanceof String) {
                    widgetParams.put(paramName, new I18nizableText((String)value));
                    continue;
                }
                __LOGGER.warn("Widget parameter '{}' at location {} is of type [{}] which is not supported. It will be ignored.", new Object[]{paramName, itemConfig.getLocation(), value.getClass()});
            }
        }
        return widgetParams;
    }

    public static I18nizableText parseI18nizableText(ConfigurationAndPluginName configurationAndPluginName, String name) throws ConfigurationException {
        return ItemParserHelper.parseI18nizableText(configurationAndPluginName, name, "");
    }

    public static I18nizableText parseI18nizableText(ConfigurationAndPluginName configurationAndPluginName, String name, String defaultValue) throws ConfigurationException {
        return I18nizableText.parseI18nizableText(configurationAndPluginName.configuration().getChild(name), "plugin." + configurationAndPluginName.pluginName(), defaultValue);
    }

    public static I18nizableText parseI18nizableText(ConfigurationAndPluginName configurationAndPluginName, String name, I18nizableText defaultValue) throws ConfigurationException {
        return I18nizableText.parseI18nizableText(configurationAndPluginName.configuration().getChild(name), "plugin." + configurationAndPluginName.pluginName(), defaultValue);
    }

    @FunctionalInterface
    public static interface DefaultValueParser {
        public Object parseDefaultValue(Configuration var1, ElementDefinition var2, String var3) throws ConfigurationException;
    }

    public record ConfigurationAndPluginName(Configuration configuration, String pluginName) {
    }
}

