/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelHelper {
    private static final Logger __LOGGER = LoggerFactory.getLogger(ModelHelper.class);

    private ModelHelper() {
    }

    public static boolean hasModelItem(String path, Collection<? extends ModelItemAccessor> itemAccessors) throws IllegalArgumentException {
        try {
            ModelHelper.getModelItem(path, itemAccessors);
            return true;
        }
        catch (UndefinedItemPathException e) {
            return false;
        }
    }

    public static ModelItem getModelItem(String path, Collection<? extends ModelItemAccessor> itemAccessors) throws IllegalArgumentException, UndefinedItemPathException {
        ModelItemAccessor modelItemAccessor;
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Unable to retrieve the model item at the given path. This path is empty.");
        }
        String definitionPath = ModelHelper.getDefinitionPathFromDataPath(path);
        ModelItem item = null;
        for (ModelItemAccessor modelItemAccessor2 : itemAccessors) {
            if (!modelItemAccessor2.hasModelItem(definitionPath)) continue;
            item = modelItemAccessor2.getModelItem(definitionPath);
            break;
        }
        if (item != null) {
            return item;
        }
        Object absolutePath = path;
        if (itemAccessors.size() == 1 && (modelItemAccessor = itemAccessors.iterator().next()) instanceof ModelItemGroup) {
            absolutePath = ((ModelItemGroup)modelItemAccessor).getPath() + "/" + path;
        }
        throw new UndefinedItemPathException("Unable to retrieve the model item at path '" + (String)absolutePath + "'. This path is not defined by the model.");
    }

    public static Collection<? extends ModelItem> getModelItems(Collection<? extends ModelItemAccessor> itemAccessors) {
        LinkedHashMap<String, ModelItem> items = new LinkedHashMap<String, ModelItem>();
        for (ModelItemAccessor modelItemAccessor : itemAccessors) {
            for (ModelItem modelItem : modelItemAccessor.getModelItems()) {
                String currentItemName = modelItem.getName();
                if (items.containsKey(currentItemName)) {
                    ModelItem existingItem = (ModelItem)items.get(currentItemName);
                    if (modelItem.getModel().equals(existingItem.getModel())) continue;
                    throw new IllegalArgumentException("The model item '" + currentItemName + "' defined in model '" + modelItem.getModel().getId() + "' is already defined in another model '" + existingItem.getModel().getId() + "'");
                }
                items.put(currentItemName, modelItem);
            }
        }
        return items.values();
    }

    public static Map<String, List<ModelItem>> getAllModelItemsInPaths(Set<String> paths, Collection<? extends ModelItemAccessor> itemAccessors) throws IllegalArgumentException, UndefinedItemPathException {
        HashMap<String, List<ModelItem>> result = new HashMap<String, List<ModelItem>>();
        for (String path : paths) {
            result.put(path, ModelHelper.getAllModelItemsInPath(path, itemAccessors));
        }
        return result;
    }

    public static List<ModelItem> getAllModelItemsInPath(String path, Collection<? extends ModelItemAccessor> itemAccessors) throws IllegalArgumentException, UndefinedItemPathException {
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Unable to retrieve the model item at the given path. This path is empty.");
        }
        String definitionPath = ModelHelper.getDefinitionPathFromDataPath(path);
        for (ModelItemAccessor modelItemAccessor : itemAccessors) {
            List<ModelItem> modelItemPath = ModelHelper._getAllModelItemsInPath(definitionPath, modelItemAccessor);
            if (modelItemPath.isEmpty()) continue;
            return modelItemPath;
        }
        throw new UndefinedItemPathException("Unable to retrieve the model items at path '" + definitionPath + "'. This path is not defined by the model.");
    }

    private static List<ModelItem> _getAllModelItemsInPath(String definitionPath, ModelItemAccessor itemAccessor) {
        ArrayList<ModelItem> definitions = new ArrayList<ModelItem>();
        String[] pathSegments = StringUtils.split((String)definitionPath, (String)"/");
        ModelItemAccessor currentModelItemAccessor = itemAccessor;
        for (int i = 0; i < pathSegments.length; ++i) {
            ModelItem modelItem = currentModelItemAccessor.getChild(pathSegments[i]);
            if (modelItem == null) {
                return Collections.emptyList();
            }
            definitions.add(modelItem);
            if (!(modelItem instanceof ModelItemAccessor)) continue;
            currentModelItemAccessor = (ModelItemAccessor)((Object)modelItem);
        }
        return definitions;
    }

    public static boolean hasModelItemOfType(ModelItemAccessor container, String type) {
        for (ModelItem modelItem : container.getModelItems()) {
            if (type.equals(modelItem.getType().getId())) {
                return true;
            }
            if (!(modelItem instanceof ModelItemGroup) || !ModelHelper.hasModelItemOfType((ModelItemGroup)modelItem, type)) continue;
            return true;
        }
        return false;
    }

    public static List<ModelItem> findModelItemsByType(ModelItemAccessor container, String type) {
        ArrayList<ModelItem> items = new ArrayList<ModelItem>();
        for (ModelItem modelItem : container.getModelItems()) {
            if (type.equals(modelItem.getType().getId())) {
                items.add(modelItem);
                continue;
            }
            if (!(modelItem instanceof ModelItemGroup)) continue;
            items.addAll(ModelHelper.findModelItemsByType((ModelItemGroup)modelItem, type));
        }
        return items;
    }

    public static String getDefinitionPathFromDataPath(String dataPath) {
        return dataPath.replaceAll("\\[[0-9]+\\]", "");
    }

    public static boolean isGroupSwitchOn(ModelItem modelItem, Map<String, Object> values) {
        Pair<Boolean, ElementDefinition> isGroupActive = ModelHelper._isModelItemGroupActive(modelItem.getParent(), values);
        if (((Boolean)isGroupActive.getKey()).booleanValue()) {
            return true;
        }
        return modelItem.equals(isGroupActive.getValue());
    }

    private static Pair<Boolean, ElementDefinition> _isModelItemGroupActive(ModelItemGroup group, Map<String, Object> values) {
        if (group == null) {
            return new ImmutablePair((Object)true, null);
        }
        ElementDefinition<Boolean> groupSwitch = group.getSwitcher();
        if (groupSwitch == null) {
            return ModelHelper._isModelItemGroupActive(group.getParent(), values);
        }
        Object value = values.get(groupSwitch.getName());
        if (value == null) {
            value = groupSwitch.getDefaultValue();
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalStateException("The switcher value of group " + group.getName() + " is null or not a boolean");
        }
        return (Boolean)value != false ? ModelHelper._isModelItemGroupActive(group.getParent(), values) : new ImmutablePair((Object)false, groupSwitch);
    }

    public static String getDisableConditionAbsolutePath(DisableCondition condition, String relativePath) throws IllegalArgumentException {
        Object[] conditionPathSegments = StringUtils.split((String)condition.getName(), (String)"/");
        Object[] relativePathSegments = StringUtils.split((String)relativePath, (String)"/");
        int nbParentSegmentInConditionPath = 0;
        String conditionPathSegment = conditionPathSegments[nbParentSegmentInConditionPath];
        while ("..".equals(conditionPathSegment)) {
            conditionPathSegment = conditionPathSegments[++nbParentSegmentInConditionPath];
        }
        int prefixLength = relativePathSegments.length - (nbParentSegmentInConditionPath + 1);
        if (prefixLength < 0) {
            String message = String.format("Unable to retrieve the condition absolute path from condition '%s' and relative path '%s'. The condition path has to many relative parents segments.", condition.getName(), relativePath);
            throw new IllegalArgumentException(message);
        }
        String prefix = StringUtils.join((Object[])relativePathSegments, (String)"/", (int)0, (int)(relativePathSegments.length - (nbParentSegmentInConditionPath + 1)));
        String suffix = StringUtils.join((Object[])conditionPathSegments, (String)"/", (int)nbParentSegmentInConditionPath, (int)conditionPathSegments.length);
        return StringUtils.isNotBlank((CharSequence)prefix) ? prefix + "/" + suffix : suffix;
    }

    public static boolean hasDisableConditions(ModelItem modelItem) {
        return ModelHelper.hasDisableConditions(modelItem.getDisableConditions());
    }

    public static boolean hasDisableConditions(DisableConditions<? extends DisableCondition> disableConditions) {
        if (disableConditions == null) {
            return false;
        }
        if (!disableConditions.getConditions().isEmpty()) {
            return true;
        }
        return disableConditions.getSubConditions().stream().anyMatch(ModelHelper::hasDisableConditions);
    }

    public static ValidationResult validateValue(ElementDefinition definition, Object value) {
        return ModelHelper.validateValue(definition, value, true);
    }

    public static ValidationResult validateValue(ElementDefinition definition, Object value, boolean checkEnumerated) {
        ValidationResult result = new ValidationResult();
        ModelItemType type = definition.getType();
        if (value != null && !type.isCompatible(value)) {
            result.addError(new I18nizableText("plugin.core", "PLUGINS_CORE_ELEMENT_DEFINITION_VALUE_NOT_ALLOWED"));
        } else {
            Validator validator = definition.getValidator();
            if (validator != null) {
                result.addResult(validator.validate(value));
            }
            if (checkEnumerated) {
                if (definition.isMultiple()) {
                    Object[] values = (Object[])value;
                    if (values != null) {
                        for (Object singleValue : values) {
                            result.addResult(ModelHelper._validateEnumeration(definition, singleValue));
                        }
                    }
                } else {
                    result.addResult(ModelHelper._validateEnumeration(definition, value));
                }
            }
        }
        return result;
    }

    private static ValidationResult _validateEnumeration(ElementDefinition definition, Object value) {
        Enumerator<Object> enumerator;
        ValidationResult result = new ValidationResult();
        if (ModelHelper._checkValueEnumeration(value) && (enumerator = definition.getEnumerator()) != null) {
            try {
                I18nizableText entry = enumerator.getEntry(value);
                if (entry == null) {
                    result.addError(new I18nizableText("plugin.core", "PLUGINS_CORE_ELEMENT_DEFINITION_VALUE_NOT_ALLOWED"));
                }
            }
            catch (Exception e) {
                __LOGGER.warn("An error occured while checking enumerated value '{}' for '{}'", new Object[]{value, enumerator, e});
                result.addError(new I18nizableText("plugin.core", "PLUGINS_CORE_ELEMENT_DEFINITION_VALUE_LED_TO_EXCEPTION"));
            }
        }
        return result;
    }

    private static boolean _checkValueEnumeration(Object value) {
        if (value == null) {
            return false;
        }
        return value instanceof String ? StringUtils.isNotEmpty((CharSequence)((String)value)) : true;
    }
}

