/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.Collection;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public interface ModelItemAccessor {
    default public ModelItem getChild(String childName) {
        for (ModelItem modelItem : this.getModelItems()) {
            ModelItem item;
            if (Strings.CS.equals(modelItem.getName(), childName)) {
                return modelItem;
            }
            if (modelItem.getName() != null || !(modelItem instanceof ModelItemAccessor) || (item = ((ModelItemAccessor)((Object)modelItem)).getChild(childName)) == null) continue;
            return item;
        }
        return null;
    }

    default public ModelItem getModelItem(String itemPath) throws UndefinedItemPathException {
        Object[] pathSegments = StringUtils.split((String)itemPath, (String)"/");
        if (pathSegments.length > 0) {
            ModelItemAccessor currentAccessor = this;
            ModelItem child = null;
            for (int i = 0; i < pathSegments.length; ++i) {
                child = currentAccessor.getChild(pathSegments[i]);
                if (child == null) {
                    throw new UndefinedItemPathException("The item at path '" + itemPath + "' is not defined in the model item accessor '" + this.toString() + "'.");
                }
                if (i < pathSegments.length - 1 && !(child instanceof ModelItemAccessor)) {
                    String currentAccessorPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)0, (int)(i + 1));
                    String subItemPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)(i + 1), (int)pathSegments.length);
                    throw new UndefinedItemPathException("In the model item accessor '" + this.toString() + "', the item at path '" + currentAccessorPath + "' is not a model item accessor. So it can not access to a sub item with path '" + subItemPath + "'.");
                }
                if (!(child instanceof ModelItemAccessor)) continue;
                currentAccessor = (ModelItemAccessor)((Object)child);
            }
            return child;
        }
        throw new UndefinedItemPathException("The item at path '" + itemPath + "' is not defined in the model item accessor '" + this.toString() + "'.");
    }

    default public boolean hasModelItem(String itemPath) {
        try {
            this.getModelItem(itemPath);
            return true;
        }
        catch (UndefinedItemPathException e) {
            return false;
        }
    }

    public Collection<? extends ModelItem> getModelItems();
}

