/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.XMLUtils;
import org.ametys.runtime.model.AbstractModelItem;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ModelItemGroup
extends AbstractModelItem
implements ModelItemContainer {
    public static final String DEFAULT_TYPE_ID = "composite";
    private List<ModelItem> _children = new ArrayList<ModelItem>();
    private ElementDefinition<Boolean> _switcher;
    private ModelItemType _type;

    public ModelItemGroup() {
    }

    public ModelItemGroup(String name, ModelItem ... children) {
        super(name);
        Arrays.stream(children).forEach(item -> this.addChild((ModelItem)item));
    }

    public Collection<ModelItem> getModelItems() {
        return this.getChildren();
    }

    public List<ModelItem> getChildren() {
        return this.getChildren(true);
    }

    public List<ModelItem> getChildren(boolean withSwitch) {
        if (withSwitch || this._switcher == null) {
            return Collections.unmodifiableList(this._children);
        }
        ArrayList<ModelItem> childrenWithoutSwitcher = new ArrayList<ModelItem>(this._children);
        childrenWithoutSwitcher.remove(this._switcher);
        return childrenWithoutSwitcher;
    }

    public void addChild(ModelItem child) {
        this.addChild(child, false);
    }

    public void addChild(ModelItem child, boolean isGroupSwitch) {
        this._children.add(child);
        child.setParent(this);
        if (isGroupSwitch) {
            if (this._switcher == null) {
                ModelItemType type;
                if (child instanceof ElementDefinition && "boolean".equals((type = ((ElementDefinition)child).getType()).getId())) {
                    this._switcher = (ElementDefinition)child;
                }
                if (this._switcher == null) {
                    throw new RuntimeException("The group '" + String.valueOf(this.getLabel()) + "' has a switch '" + String.valueOf(child) + "' that is not valid because it is not a boolean.");
                }
            } else {
                throw new RuntimeException("At least two group-switches have been defined for the configuration group '" + String.valueOf(this.getLabel()) + "'. These parameters are '" + String.valueOf(this._switcher) + "' and '" + String.valueOf(child) + "'.");
            }
        }
    }

    public ElementDefinition<Boolean> getSwitcher() {
        return this._switcher;
    }

    @Override
    public void setModel(Model model) {
        super.setModel(model);
        for (ModelItem modelItem : this._children) {
            modelItem.setModel(model);
        }
    }

    @Override
    public ModelItemType getType() {
        return this._type;
    }

    @Override
    public void setType(ModelItemType type) {
        this._type = type;
    }

    @Override
    protected Map<String, Object> _toJSON(DefinitionContext context) {
        return this._toJSON(context, true);
    }

    public Map<String, Object> toJSON(DefinitionContext context, boolean includeChildren) {
        if (this._shouldJSONBeEmpty(context)) {
            return Map.of();
        }
        return this._toJSON(context, includeChildren);
    }

    protected Map<String, Object> _toJSON(DefinitionContext context, boolean includeChildren) {
        Map<String, Object> result = super._toJSON(context);
        ModelItemType type = this.getType();
        result.put("type", type != null ? type.getId() : DEFAULT_TYPE_ID);
        ElementDefinition<Boolean> switcher = this.getSwitcher();
        if (switcher != null) {
            HashMap<String, Object> switcherToJSON = new HashMap<String, Object>();
            switcherToJSON.put("id", switcher.getName());
            switcherToJSON.put("label", switcher.getLabel());
            if (switcher.getType() != null) {
                switcherToJSON.put("default-value", switcher.getType().valueToJSONForClient(switcher.getDefaultValue(), DataContext.newInstance()));
            }
            result.put("switcher", switcherToJSON);
        }
        List<ModelItem> children = this.getChildren(false);
        if (includeChildren && !children.isEmpty()) {
            LinkedHashMap<String, Map<String, Object>> elements = new LinkedHashMap<String, Map<String, Object>>();
            for (ModelItem child : children) {
                String name = child.getName();
                if (name == null) continue;
                elements.put(name, child.toJSON(context));
            }
            result.put("elements", elements);
        }
        return result;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        super.toSAX(contentHandler, context);
        ElementDefinition<Boolean> switcher = this.getSwitcher();
        if (switcher != null) {
            AttributesImpl switcherAttributes = new AttributesImpl();
            switcherAttributes.addCDATAAttribute("name", switcher.getName());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"switcher", (Attributes)switcherAttributes);
            XMLUtils.createI18nElementIfNotNull(contentHandler, "label", switcher.getLabel());
            if (switcher.getType() != null) {
                switcher.getType().valueToSAX(contentHandler, "default-value", switcher.getDefaultValue(), DataContext.newInstance());
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"switcher");
        }
    }

    public static ModelItemGroup of(String name, ModelItem ... children) {
        return new ModelItemGroup(name, children);
    }
}

