/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.util.SizeUtils;
import org.ametys.core.util.XMLUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.AbstractModelItem;
import org.ametys.runtime.model.AbstractViewItemGroup;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ModelViewItemGroup<T extends ModelItemGroup>
extends AbstractViewItemGroup
implements ModelViewItem<T> {
    @SizeUtils.ExcludeFromSizeCalculation
    private T _definition;
    @SizeUtils.ExcludeFromSizeCalculation
    private ViewItemAccessor _parent;

    public static ModelViewItemGroup of(ModelItemGroup modelItem) throws IllegalArgumentException {
        if (modelItem == null) {
            throw new IllegalArgumentException("Unable to create the view from a null model");
        }
        return (ModelViewItemGroup)ViewHelper.createViewItemAccessor(List.of(modelItem));
    }

    public static ModelViewItemGroup of(ModelItemGroup modelItem, String ... itemPaths) throws IllegalArgumentException, BadItemTypeException {
        if (modelItem == null) {
            throw new IllegalArgumentException("Unable to create the view from a null model");
        }
        return (ModelViewItemGroup)ViewHelper.createViewItemAccessor(List.of(modelItem), itemPaths);
    }

    @Override
    public T getDefinition() {
        return this._definition;
    }

    @Override
    public void setDefinition(T definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Try to set a null definition to the model view item group");
        }
        this._definition = definition;
    }

    @Override
    public ViewItemAccessor getParent() {
        return this._parent;
    }

    @Override
    public void setParent(ViewItemAccessor parent) {
        this._parent = parent;
    }

    @Override
    public String getName() {
        if (this._definition != null) {
            return ((AbstractModelItem)this._definition).getName();
        }
        return null;
    }

    @Override
    public I18nizableText getLabel() {
        I18nizableText label = super.getLabel();
        if (label != null) {
            return label;
        }
        return ((AbstractModelItem)this.getDefinition()).getLabel();
    }

    @Override
    public I18nizableText getDescription() {
        I18nizableText desc = super.getDescription();
        if (desc != null) {
            return desc;
        }
        return ((AbstractModelItem)this.getDefinition()).getDescription();
    }

    @Override
    public Map<String, Object> toJSON(DefinitionContext context) {
        ModelItem definition = this.getDefinition();
        if (definition != null) {
            Map<String, Object> result = ((ModelItemGroup)definition).toJSON(context, false);
            if (!result.isEmpty()) {
                result.put("label", this.getLabel());
                result.put("description", this.getDescription());
                result.put("role", this.getRole());
                if (StringUtils.isEmpty((CharSequence)this.getName())) {
                    result.put("unnamed-group", true);
                }
                result.putAll(this._childrenToJSON(context));
            }
            return result;
        }
        return Map.of();
    }

    protected Map<String, Object> _childrenToJSON(DefinitionContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<ViewItem> viewItems = this._getChildrenWithoutSwitcher();
        if (!viewItems.isEmpty()) {
            result.put("elements", ViewHelper.viewItemsToJSON(viewItems, context));
        }
        return result;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        ModelItem definition = this.getDefinition();
        if (definition != null) {
            String tagName = context.getItemTagName().orElse("item");
            AttributesImpl attributes = new AttributesImpl();
            attributes.addCDATAAttribute("name", ((AbstractModelItem)definition).getName());
            attributes.addCDATAAttribute("plugin", ((AbstractModelItem)definition).getPluginName());
            attributes.addCDATAAttribute("path", ((AbstractModelItem)definition).getPath());
            String typeId = ((ModelItemGroup)definition).getType() != null ? ((ModelItemGroup)definition).getType().getId() : "composite";
            attributes.addCDATAAttribute("type", typeId);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attributes);
            XMLUtils.createElementIfNotNull(contentHandler, "role", this.getRole());
            XMLUtils.createI18nElementIfNotNull(contentHandler, "label", this.getLabel());
            XMLUtils.createI18nElementIfNotNull(contentHandler, "description", this.getDescription());
            ((ModelItemGroup)definition).toSAX(contentHandler, context);
            for (ViewItem viewItem : this._getChildrenWithoutSwitcher()) {
                viewItem.toSAX(contentHandler, context);
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
        }
    }

    private List<ViewItem> _getChildrenWithoutSwitcher() {
        ElementDefinition<Boolean> switcher = ((ModelItemGroup)this.getDefinition()).getSwitcher();
        if (switcher == null) {
            return this.getViewItems();
        }
        ArrayList<ViewItem> childrenWithoutSwitcher = new ArrayList<ViewItem>();
        for (ViewItem child : this.getViewItems()) {
            ElementDefinition childDefinitonReference;
            if (!(child instanceof ViewElement) || switcher.equals(childDefinitonReference = ((ViewElement)child).getDefinition())) continue;
            childrenWithoutSwitcher.add(child);
        }
        return childrenWithoutSwitcher;
    }

    @Override
    public void copyTo(ViewItem item) {
        super.copyTo(item);
        assert (item instanceof ModelViewItemGroup);
        ((ModelViewItemGroup)item).setDefinition((T)this.getDefinition());
    }

    @Override
    public ModelViewItemGroup createInstance() {
        return new ModelViewItemGroup<T>();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this._definition);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelViewItemGroup other = (ModelViewItemGroup)obj;
        return Objects.equals(this._definition, other._definition);
    }

    public String toString() {
        return ((AbstractModelItem)this._definition).toString() + ": " + this._children.toString();
    }
}

