/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ametys.core.util.SizeUtils;
import org.ametys.core.util.XMLUtils;
import org.ametys.runtime.model.AbstractViewItemGroup;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SimpleViewItemGroup
extends AbstractViewItemGroup {
    @SizeUtils.ExcludeFromSizeCalculation
    private ViewItemAccessor _parent;
    private String _name;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public ViewItemAccessor getParent() {
        return this._parent;
    }

    @Override
    public void setParent(ViewItemAccessor parent) {
        this._parent = parent;
    }

    @Override
    public Map<String, Object> toJSON(DefinitionContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", this.getName());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        result.put("role", this.getRole());
        List<ViewItem> viewItems = this.getViewItems();
        if (!viewItems.isEmpty()) {
            result.put("elements", ViewHelper.viewItemsToJSON(viewItems, context));
        }
        return result;
    }

    @Override
    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        Optional.ofNullable(this.getName()).ifPresent(name -> attributes.addCDATAAttribute("name", name));
        Optional.ofNullable(this.getRole()).ifPresent(role -> attributes.addCDATAAttribute("role", role));
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"group", (Attributes)attributes);
        XMLUtils.createI18nElementIfNotNull(contentHandler, "label", this.getLabel());
        XMLUtils.createI18nElementIfNotNull(contentHandler, "description", this.getDescription());
        for (ViewItem viewItem : this.getViewItems()) {
            viewItem.toSAX(contentHandler, context);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"group");
    }

    public void includeView(View viewToInclude, View referenceView) {
        ViewHelper.addViewAccessorItems(this, viewToInclude, referenceView, "");
    }

    @Override
    public void copyTo(ViewItem item) {
        super.copyTo(item);
        assert (item instanceof SimpleViewItemGroup);
        ((SimpleViewItemGroup)item).setName(this.getName());
    }

    @Override
    public SimpleViewItemGroup createInstance() {
        return new SimpleViewItemGroup();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this._name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleViewItemGroup other = (SimpleViewItemGroup)obj;
        return Objects.equals(this._name, other._name);
    }

    public String toString() {
        return this._name + ": " + this._children.toString();
    }
}

