/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ametys.core.util.XMLUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.util.ModifiableLabelable;
import org.apache.cocoon.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class View
implements ViewItemContainer,
ModifiableLabelable {
    private String _name;
    private I18nizableText _label;
    private I18nizableText _description;
    private String _iconGlyph;
    private String _iconDecorator;
    private String _smallIcon;
    private String _mediumIcon;
    private String _largeIcon;
    private boolean _isInternal;
    private List<ViewItem> _items = new ArrayList<ViewItem>();

    public static View of(Model model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("Unable to create the view from a null model");
        }
        return (View)ViewHelper.createViewItemAccessor(List.of(model));
    }

    public static View of(Collection<? extends Model> models) throws IllegalArgumentException {
        return (View)ViewHelper.createViewItemAccessor(models);
    }

    public static View of(Model model, String ... itemPaths) throws IllegalArgumentException, BadItemTypeException {
        if (model == null) {
            throw new IllegalArgumentException("Unable to create the view from a null model");
        }
        return (View)ViewHelper.createViewItemAccessor(List.of(model), itemPaths);
    }

    public static View of(Collection<? extends Model> models, String ... itemPaths) throws IllegalArgumentException, BadItemTypeException {
        return (View)ViewHelper.createViewItemAccessor(models, itemPaths);
    }

    public static View of(ModelItem ... modelItems) {
        View view = new View();
        for (ModelItem modelItem : modelItems) {
            ViewHelper.addViewItem(modelItem.getPath(), (ViewItemAccessor)view, modelItem.getModel());
        }
        return view;
    }

    public void copyTo(View view) {
        view.setName(this.getName());
        view.setLabel(this.getLabel());
        view.setDescription(this.getDescription());
        view.setInternal(this.isInternal());
        view.setIconGlyph(this.getIconGlyph());
        view.setIconDecorator(this.getIconDecorator());
        view.setSmallIcon(this.getSmallIcon());
        view.setMediumIcon(this.getMediumIcon());
        view.setLargeIcon(this.getLargeIcon());
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    public String getIconGlyph() {
        return this._iconGlyph;
    }

    public void setIconGlyph(String iconGlyph) {
        this._iconGlyph = iconGlyph;
    }

    public String getIconDecorator() {
        return this._iconDecorator;
    }

    public void setIconDecorator(String iconDecorator) {
        this._iconDecorator = iconDecorator;
    }

    public String getSmallIcon() {
        return this._smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this._smallIcon = smallIcon;
    }

    public String getMediumIcon() {
        return this._mediumIcon;
    }

    public void setMediumIcon(String mediumIcon) {
        this._mediumIcon = mediumIcon;
    }

    public String getLargeIcon() {
        return this._largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this._largeIcon = largeIcon;
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public void setInternal(boolean isInternal) {
        this._isInternal = isInternal;
    }

    @Override
    public List<ViewItem> getViewItems() {
        return Collections.unmodifiableList(this._items);
    }

    @Override
    public void addViewItem(ViewItem item) {
        this._items.add(item);
        item.setParent(this);
    }

    @Override
    public void insertViewItem(ViewItem item, int index) {
        if (index < 0 || index > this._items.size()) {
            throw new IllegalArgumentException("Unable to insert an item at index " + index + ". This group contains " + this._items.size() + " items.");
        }
        this._items.add(index, item);
    }

    @Override
    public boolean removeViewItem(ViewItem item) {
        return this._items.remove(item);
    }

    @Override
    public void clear() {
        this._items.clear();
    }

    public Map<String, Object> toJSON(DefinitionContext context) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        DefinitionContext newContext = context.cloneContext().withView(this);
        result.put("name", this.getName());
        result.put("internal", this.isInternal());
        result.put("label", this.getLabel());
        result.put("description", this.getDescription());
        result.put("icon-glyph", this.getIconGlyph());
        result.put("icon-decorator", this.getIconDecorator());
        result.put("small-icon-path", this.getSmallIcon());
        result.put("medium-icon-path", this.getMediumIcon());
        result.put("large-icon-path", this.getLargeIcon());
        result.put("elements", ViewHelper.viewItemsToJSON(this.getViewItems(), newContext));
        return result;
    }

    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        Optional.ofNullable(this.getName()).ifPresent(name -> attributes.addCDATAAttribute("name", name));
        attributes.addCDATAAttribute("internal", String.valueOf(this.isInternal()));
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"view", (Attributes)attributes);
        XMLUtils.createI18nElementIfNotNull(contentHandler, "label", this.getLabel());
        XMLUtils.createI18nElementIfNotNull(contentHandler, "description", this.getDescription());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"icons");
        XMLUtils.createElementIfNotNull(contentHandler, "icon-glyph", this.getIconGlyph());
        XMLUtils.createElementIfNotNull(contentHandler, "icon-decorator", this.getIconDecorator());
        XMLUtils.createElementIfNotNull(contentHandler, "small-icon-path", this.getSmallIcon());
        XMLUtils.createElementIfNotNull(contentHandler, "medium-icon-path", this.getMediumIcon());
        XMLUtils.createElementIfNotNull(contentHandler, "large-icon-path", this.getLargeIcon());
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"icons");
        for (ViewItem viewItem : this.getViewItems()) {
            viewItem.toSAX(contentHandler, context);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"view");
    }

    public void includeView(View viewToInclude) {
        View referenceView = new View();
        referenceView.addViewItems(this.getViewItems());
        ViewHelper.addViewAccessorItems(this, viewToInclude, referenceView, "");
    }

    public int hashCode() {
        return Objects.hash(this._items, this._name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        View other = (View)obj;
        return Objects.equals(this._items, other._items) && Objects.equals(this._name, other._name);
    }

    public boolean equals(Object obj, boolean checkDetails) {
        if (!this.equals(obj)) {
            return false;
        }
        if (checkDetails) {
            View other = (View)obj;
            for (int i = 0; i < this._items.size(); ++i) {
                ViewItem otherItem;
                ViewItem item = this._items.get(i);
                if (item.equals(otherItem = other._items.get(i), checkDetails)) continue;
                return false;
            }
            return Objects.equals(this._description, other._description) && Objects.equals(this._iconDecorator, other._iconDecorator) && Objects.equals(this._iconGlyph, other._iconGlyph) && this._isInternal == other._isInternal && Objects.equals(this._label, other._label);
        }
        return true;
    }
}

