/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.Map;
import java.util.Objects;
import org.ametys.core.util.SizeUtils;
import org.ametys.core.util.XMLUtils;
import org.ametys.plugins.core.ui.help.HelpLink;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ViewElement
implements ModelViewItem<ElementDefinition> {
    @SizeUtils.ExcludeFromSizeCalculation
    private ElementDefinition _definition;
    @SizeUtils.ExcludeFromSizeCalculation
    private ViewItemAccessor _parent;
    private I18nizableText _label;
    private I18nizableText _description;

    @Override
    public ElementDefinition getDefinition() {
        return this._definition;
    }

    @Override
    public void setDefinition(ElementDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Try to set a null definition to the view element");
        }
        this._definition = definition;
    }

    @Override
    public ViewItemAccessor getParent() {
        return this._parent;
    }

    @Override
    public void setParent(ViewItemAccessor parent) {
        this._parent = parent;
    }

    @Override
    public String getName() {
        if (this._definition != null) {
            return this._definition.getName();
        }
        return null;
    }

    @Override
    public void setLabel(I18nizableText label) {
        this._label = label;
    }

    @Override
    public void setDescription(I18nizableText description) {
        this._description = description;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label != null ? this._label : this.getDefinition().getLabel();
    }

    @Override
    public I18nizableText getDescription() {
        return this._description != null ? this._description : this.getDefinition().getDescription();
    }

    @Override
    public Map<String, Object> toJSON(DefinitionContext context) {
        Map<String, Object> result;
        ElementDefinition definition = this.getDefinition();
        if (definition != null && !(result = definition.toJSON(context)).isEmpty()) {
            result.put("label", this.getLabel());
            result.put("description", this.getDescription());
            Model model = definition.getModel();
            if (model != null) {
                String modelId = model.getId();
                String family = model.getFamilyId();
                String path = definition.getPath();
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    path = Strings.CS.prependIfMissing(path, (CharSequence)"/", new CharSequence[0]);
                }
                String featureId = StringUtils.join((Object[])new String[]{modelId, path});
                featureId = Strings.CS.removeStart(featureId, (CharSequence)"/");
                HelpLink help = new HelpLink(family, featureId, null);
                result.put("help", help);
            }
            return result;
        }
        return Map.of();
    }

    @Override
    public void toSAX(ContentHandler contentHandler, DefinitionContext context) throws SAXException {
        ElementDefinition definition = this.getDefinition();
        if (definition != null) {
            String tagName = context.getItemTagName().orElse("item");
            AttributesImpl attributes = new AttributesImpl();
            attributes.addCDATAAttribute("name", definition.getName());
            attributes.addCDATAAttribute("plugin", definition.getPluginName());
            attributes.addCDATAAttribute("path", definition.getPath());
            attributes.addCDATAAttribute("type", definition.getType().getId());
            attributes.addCDATAAttribute("multiple", String.valueOf(definition.isMultiple()));
            XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attributes);
            XMLUtils.createI18nElementIfNotNull(contentHandler, "label", this.getLabel());
            XMLUtils.createI18nElementIfNotNull(contentHandler, "description", this.getDescription());
            definition.toSAX(contentHandler, context);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
        }
    }

    @Override
    public void copyTo(ViewItem item) {
        assert (item instanceof ViewElement);
        ViewElement viewElement = (ViewElement)item;
        viewElement.setDefinition(this.getDefinition());
        viewElement.setLabel(this.getLabel());
        viewElement.setDescription(this.getDescription());
    }

    @Override
    public ViewElement createInstance() {
        return new ViewElement();
    }

    public int hashCode() {
        return Objects.hash(this._definition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewElement other = (ViewElement)obj;
        return Objects.equals(this._definition, other._definition);
    }

    @Override
    public boolean equals(Object obj, boolean checkDetails) {
        if (!this.equals(obj)) {
            return false;
        }
        if (checkDetails) {
            ViewElement other = (ViewElement)obj;
            return Objects.equals(this._label, other._label) && Objects.equals(this._description, other._description);
        }
        return true;
    }

    public String toString() {
        return this._definition.toString();
    }
}

