/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.exception.BadItemTypeException;

public class ViewElementAccessor
extends ViewElement
implements ViewItemAccessor {
    private List<ViewItem> _viewItems = new ArrayList<ViewItem>();

    @Override
    public List<ViewItem> getViewItems() {
        return this._viewItems;
    }

    @Override
    public void addViewItem(ViewItem item) {
        this._viewItems.add(item);
        item.setParent(this);
    }

    @Override
    public void insertViewItem(ViewItem item, int index) {
        if (index < 0 || index > this._viewItems.size()) {
            throw new IllegalArgumentException("Unable to insert an item at index " + index + ". This group contains " + this._viewItems.size() + " items.");
        }
        this._viewItems.add(index, item);
        item.setParent(this);
    }

    @Override
    public boolean removeViewItem(ViewItem item) {
        return this._viewItems.remove(item);
    }

    @Override
    public void clear() {
        this._viewItems.clear();
    }

    public static ViewElementAccessor of(ModelItemAccessor modelItemAccessor) throws IllegalArgumentException {
        if (modelItemAccessor == null) {
            throw new IllegalArgumentException("Unable to create the view from a null model");
        }
        return (ViewElementAccessor)ViewHelper.createViewItemAccessor(List.of(modelItemAccessor));
    }

    public static ViewElementAccessor of(ModelItemAccessor modelItemAccessor, String ... itemPaths) throws IllegalArgumentException, BadItemTypeException {
        if (modelItemAccessor == null) {
            throw new IllegalArgumentException("Unable to create the view from a null model");
        }
        return (ViewElementAccessor)ViewHelper.createViewItemAccessor(List.of(modelItemAccessor), itemPaths);
    }

    @Override
    public void copyTo(ViewItem item, ViewItemAccessor referenceViewItemAccessor, String itemPath) {
        super.copyTo(item, referenceViewItemAccessor, itemPath);
        assert (item instanceof ViewElementAccessor);
        ViewHelper.addViewAccessorItems((ViewElementAccessor)item, this, referenceViewItemAccessor, itemPath);
    }

    @Override
    public ViewElementAccessor createInstance() {
        return new ViewElementAccessor();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this._viewItems);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewElementAccessor other = (ViewElementAccessor)obj;
        return Objects.equals(this._viewItems, other._viewItems);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this._viewItems.toString();
    }
}

