/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.SimpleViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewElementAccessor;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.ViewItemGroup;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public final class ViewHelper {
    private ViewHelper() {
    }

    public static ModelViewItem createModelViewItemInstance(ModelItem modelItem) {
        return modelItem instanceof ModelItemGroup ? new ModelViewItemGroup() : (modelItem instanceof ModelItemAccessor ? new ViewElementAccessor() : new ViewElement());
    }

    public static String getModelViewItemPath(ModelViewItem modelViewItem) {
        Object path = modelViewItem.getName();
        ViewItemAccessor parent = modelViewItem.getParent();
        while (parent != null) {
            ViewItemAccessor viewItemAccessor;
            if (parent instanceof ModelViewItem) {
                ModelViewItem parentModelViewItem = (ModelViewItem)((Object)parent);
                path = parentModelViewItem.getName() + "/" + (String)path;
            }
            if (parent instanceof ViewItem) {
                ViewItem parentViewItem = (ViewItem)((Object)parent);
                viewItemAccessor = parentViewItem.getParent();
            } else {
                viewItemAccessor = null;
            }
            parent = viewItemAccessor;
        }
        return path;
    }

    public static List<ViewItem> copyViewItems(List<ViewItem> viewItems) {
        return ViewHelper.copyViewItems(viewItems, ViewHelper::createViewItemInstance);
    }

    public static List<ViewItem> copyViewItems(List<ViewItem> viewItems, Function<ViewItem, ViewItem> createCopyInstance) {
        ArrayList<ViewItem> copies = new ArrayList<ViewItem>();
        for (ViewItem viewItem : viewItems) {
            ViewItem copy = createCopyInstance.apply(viewItem);
            viewItem.copyTo(copy);
            if (viewItem instanceof ViewItemAccessor) {
                ViewItemAccessor viewItemAccessor = (ViewItemAccessor)((Object)viewItem);
                List<ViewItem> copyChildren = ViewHelper.copyViewItems(viewItemAccessor.getViewItems(), createCopyInstance);
                ((ViewItemAccessor)((Object)copy)).addViewItems(copyChildren);
            }
            copies.add(copy);
        }
        return copies;
    }

    public static ViewItem createViewItemInstance(ViewItem viewItem) {
        return viewItem.createInstance();
    }

    public static void addViewAccessorItems(ViewItemAccessor currentAccessor, ViewItemAccessor accessorToInclude, ViewItemAccessor referenceViewItemAccessor, String accessorPath) {
        for (ViewItem itemToInclude : accessorToInclude.getViewItems()) {
            Object itemPath = accessorPath;
            if (itemToInclude instanceof ModelViewItem) {
                itemPath = (String)itemPath + (String)(StringUtils.isNotEmpty((CharSequence)accessorPath) ? "/" + itemToInclude.getName() : itemToInclude.getName());
            }
            if (itemToInclude instanceof ModelViewItem && referenceViewItemAccessor.hasModelViewItem((ModelViewItem)itemToInclude, "", (String)itemPath)) continue;
            ViewItem copy = itemToInclude.createInstance();
            currentAccessor.addViewItem(copy);
            itemToInclude.copyTo(copy, referenceViewItemAccessor, (String)itemPath);
        }
    }

    public static <T extends ViewItemAccessor> T createViewItemAccessor(Collection<? extends ModelItemAccessor> modelItemAccessors) throws IllegalArgumentException {
        T viewItemAccessor = ViewHelper.createEmptyViewItemAccessor(modelItemAccessors);
        for (ModelItemAccessor modelItemAccessor : modelItemAccessors) {
            for (ModelItem modelItem : modelItemAccessor.getModelItems()) {
                if (viewItemAccessor.hasModelViewItem(modelItem.getName())) continue;
                ViewHelper.addViewItem(modelItem.getName(), viewItemAccessor, new ModelItemAccessor[]{modelItemAccessor});
            }
        }
        return viewItemAccessor;
    }

    public static <T extends ViewItemAccessor> T createViewItemAccessor(Collection<? extends ModelItemAccessor> modelItemAccessors, String ... itemPaths) throws IllegalArgumentException, BadItemTypeException {
        T viewItemAccessor = ViewHelper.createEmptyViewItemAccessor(modelItemAccessors);
        for (String itemPath : itemPaths) {
            if (!ModelHelper.hasModelItem(itemPath, modelItemAccessors)) {
                String modelIds = modelItemAccessors.stream().map(modelItemContainer -> ViewHelper._getModelItemAccessorIdentifier(modelItemContainer)).flatMap(Optional::stream).collect(Collectors.joining(", "));
                throw new IllegalArgumentException("Item '" + itemPath + "' not found in models: '" + modelIds + "'.");
            }
            ViewHelper.addViewItem(itemPath, viewItemAccessor, modelItemAccessors.toArray(new ModelItemAccessor[modelItemAccessors.size()]));
        }
        return viewItemAccessor;
    }

    public static <T extends ViewItemAccessor> T createEmptyViewItemAccessor(Collection<? extends ModelItemAccessor> modelItemAccessors) throws IllegalArgumentException {
        if (modelItemAccessors.isEmpty()) {
            throw new IllegalArgumentException("The model is needed to create a view item container");
        }
        ModelItemAccessor firstModelItemAccessor = modelItemAccessors.iterator().next();
        if (firstModelItemAccessor instanceof ElementDefinition) {
            ViewElementAccessor viewItemAccesor = new ViewElementAccessor();
            viewItemAccesor.setDefinition((ElementDefinition)((Object)firstModelItemAccessor));
            return (T)viewItemAccesor;
        }
        if (firstModelItemAccessor instanceof ModelItemGroup) {
            ModelViewItemGroup<ModelItemGroup> viewItemAccessor = new ModelViewItemGroup<ModelItemGroup>();
            viewItemAccessor.setDefinition((ModelItemGroup)firstModelItemAccessor);
            return (T)viewItemAccessor;
        }
        return (T)new View();
    }

    public static ModelViewItem addViewItem(String relativePath, ViewItemAccessor viewItemAccessor, ModelItemAccessor ... modelItemAccessors) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException {
        return ViewHelper.addViewItem(relativePath, viewItemAccessor, true, true, modelItemAccessors);
    }

    public static ModelViewItem addViewItem(String relativePath, ViewItemAccessor viewItemAccessor, boolean expandContainers, boolean mergeContainers, ModelItemAccessor ... modelItemAccessors) throws IllegalArgumentException, UndefinedItemPathException, BadItemTypeException {
        int firstIndexOfItemPathSeparator = relativePath.indexOf("/");
        String firstPathSegment = firstIndexOfItemPathSeparator > -1 ? relativePath.substring(0, relativePath.indexOf("/")) : relativePath;
        ModelItem modelItem = ModelHelper.getModelItem(firstPathSegment, Arrays.asList(modelItemAccessors));
        ModelViewItem<ElementDefinition> viewItem = null;
        if (modelItem instanceof ModelItemAccessor) {
            if (mergeContainers && viewItemAccessor.hasModelViewItem(firstPathSegment)) {
                viewItem = viewItemAccessor.getModelViewItem(firstPathSegment);
            } else {
                viewItem = modelItem instanceof ModelItemGroup ? new ModelViewItemGroup() : new ViewElementAccessor();
                viewItem.setDefinition((ElementDefinition)modelItem);
                viewItemAccessor.addViewItem(viewItem);
            }
        } else {
            viewItem = new ViewElement();
            viewItem.setDefinition((ElementDefinition)modelItem);
            viewItemAccessor.addViewItem(viewItem);
        }
        if (firstIndexOfItemPathSeparator > -1) {
            if (modelItem instanceof ModelItemAccessor) {
                String subPath = relativePath.substring(firstIndexOfItemPathSeparator + 1);
                return ViewHelper.addViewItem(subPath, (ViewItemAccessor)((Object)viewItem), expandContainers, mergeContainers, (ModelItemAccessor)((Object)modelItem));
            }
            throw new BadItemTypeException("The segments inside the items' paths can only refer to an accessor. The path '" + relativePath + "' refers to the item '" + modelItem.getPath() + "' that is not an accessor");
        }
        if (modelItem instanceof ModelItemContainer && expandContainers) {
            for (ModelItem modelItem2 : ((ModelItemContainer)((Object)modelItem)).getModelItems()) {
                String newRelativePath = Strings.CS.removeStart(modelItem2.getPath(), (CharSequence)(modelItem.getPath() + "/"));
                ViewHelper.addViewItem(newRelativePath, (ViewItemAccessor)((Object)viewItem), expandContainers, mergeContainers, (ModelItemContainer)((Object)modelItem));
            }
        }
        return viewItem;
    }

    private static Optional<String> _getModelItemAccessorIdentifier(ModelItemAccessor accessor) {
        if (accessor instanceof Model) {
            return Optional.ofNullable(((Model)accessor).getId());
        }
        if (accessor instanceof ModelItem) {
            return Optional.ofNullable(((ModelItem)((Object)accessor)).getName());
        }
        return Optional.empty();
    }

    public static SimpleViewItemGroup getSimpleViewItemGroup(ViewItemAccessor viewItemAccessor, String groupPath) {
        Object[] pathSegments = groupPath.split("/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to retrieve the group at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            String groupName = groupPath;
            return Optional.ofNullable(viewItemAccessor.getViewItem(groupName)).filter(SimpleViewItemGroup.class::isInstance).map(SimpleViewItemGroup.class::cast).orElseThrow(() -> new UndefinedItemPathException("Unable to retrieve the group with the name '" + groupName + "'. No group with this name has been found in view item accessor '" + ViewHelper._getViewItemAccessorName(viewItemAccessor) + "'"));
        }
        SimpleViewItemGroup simpleViewItemGroup = ViewHelper.getSimpleViewItemGroup(viewItemAccessor, pathSegments[0]);
        String subGroupPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)1, (int)pathSegments.length);
        return ViewHelper.getSimpleViewItemGroup(simpleViewItemGroup, subGroupPath);
    }

    public static ViewItem getViewItem(ViewItemAccessor viewItemAccessor, String viewItemPath) {
        Object[] pathSegments = viewItemPath.split("/");
        if (pathSegments == null || pathSegments.length < 1) {
            throw new IllegalArgumentException("Unable to retrieve the view item at the given path. This path is empty.");
        }
        if (pathSegments.length == 1) {
            String viewItemName = viewItemPath;
            return Optional.ofNullable(viewItemAccessor.getViewItem(viewItemName)).orElseThrow(() -> new UndefinedItemPathException("Unable to retrieve the view item with the name '" + viewItemName + "'. No view item with this name has been found in view item accessor '" + ViewHelper._getViewItemAccessorName(viewItemAccessor) + "'"));
        }
        ViewItemAccessor newViewItemAccessor = viewItemAccessor.getViewItems().stream().filter(arg_0 -> ViewHelper.lambda$getViewItem$3((String[])pathSegments, arg_0)).filter(ViewItemAccessor.class::isInstance).map(ViewItemAccessor.class::cast).findFirst().orElseThrow(() -> ViewHelper.lambda$getViewItem$4((String[])pathSegments, viewItemAccessor));
        String subviewItemPath = StringUtils.join((Object[])pathSegments, (String)"/", (int)1, (int)pathSegments.length);
        return ViewHelper.getViewItem(newViewItemAccessor, subviewItemPath);
    }

    public static void insertViewItemAfter(ViewItemAccessor viewItemAccessor, ViewItem viewItemToInsert, String insertAfter) throws IllegalArgumentException, UndefinedItemPathException {
        ViewHelper.insertItemAfterOrBefore(viewItemAccessor, viewItemToInsert, insertAfter, InsertMode.AFTER);
    }

    public static void insertItemBefore(ViewItemAccessor viewItemAccessor, ViewItem viewItemToInsert, String insertBefore) throws IllegalArgumentException, UndefinedItemPathException {
        ViewHelper.insertItemAfterOrBefore(viewItemAccessor, viewItemToInsert, insertBefore, InsertMode.BEFORE);
    }

    public static void insertItemAfterOrBefore(ViewItemAccessor viewItemAccessor, ViewItem itemToInsert, String insertAfterOrBefore, InsertMode insertMode) throws IllegalArgumentException, UndefinedItemPathException {
        if (StringUtils.isBlank((CharSequence)insertAfterOrBefore)) {
            throw new IllegalArgumentException("Unable to insert view item " + itemToInsert.getName() + " " + insertMode.toString() + " the view item with the given name. This name is empty.");
        }
        if (insertAfterOrBefore.contains("/")) {
            throw new IllegalArgumentException("Unable to insert view item " + itemToInsert.getName() + " " + insertMode.toString() + " the view item with the name '" + insertAfterOrBefore + "'. This name is a path.");
        }
        if (!ViewHelper._doInsertItemAfterOrBefore(viewItemAccessor, itemToInsert, insertAfterOrBefore, insertMode)) {
            throw new UndefinedItemPathException("Unable to insert view item " + itemToInsert.getName() + " " + insertMode.toString() + " the view item at path " + insertAfterOrBefore + ". No view item has been found at this path in view item accessor '" + ViewHelper._getViewItemAccessorName(viewItemAccessor) + "'");
        }
    }

    private static boolean _doInsertItemAfterOrBefore(ViewItemAccessor viewItemAccessor, ViewItem itemToInsert, String insertAfterOrBefore, InsertMode insertMode) {
        List<ViewItem> viewItems = viewItemAccessor.getViewItems();
        for (int indexInAccessor = 0; indexInAccessor < viewItems.size(); ++indexInAccessor) {
            ModelViewItem modelViewItem;
            ViewItem viewItem = viewItems.get(indexInAccessor);
            if (!insertAfterOrBefore.equals(viewItem.getName())) continue;
            if (viewItemAccessor instanceof ModelViewItem && !((ModelItemAccessor)(modelViewItem = (ModelViewItem)((Object)viewItemAccessor)).getDefinition()).hasModelItem(itemToInsert.getName())) {
                throw new UndefinedItemPathException("Unable to insert view item " + itemToInsert.getName() + " " + insertMode.toString() + " the view item at path " + insertAfterOrBefore + ". The item to insert is not defined by the model.");
            }
            viewItemAccessor.insertViewItem(itemToInsert, indexInAccessor + insertMode.getPositionFromReferencedViewItem());
            return true;
        }
        return false;
    }

    private static String _getViewItemAccessorName(ViewItemAccessor viewItemAccessor) {
        String string;
        if (viewItemAccessor instanceof View) {
            View view = (View)viewItemAccessor;
            string = view.getName();
        } else if (viewItemAccessor instanceof ViewItem) {
            ViewItem viewItem = (ViewItem)((Object)viewItemAccessor);
            string = viewItem.getName();
        } else {
            string = viewItemAccessor.toString();
        }
        return string;
    }

    public static Set<String> getModelItemsPathsFromView(View view) {
        return ViewHelper._getModelItemsFromViewItemContainer(view).keySet();
    }

    public static Collection<ModelItem> getModelItemsFromView(View view) {
        return ViewHelper._getModelItemsFromViewItemContainer(view).values();
    }

    private static Map<String, ModelItem> _getModelItemsFromViewItemContainer(ViewItemContainer viewItemContainer) {
        HashMap<String, ModelItem> result = new HashMap<String, ModelItem>();
        for (ViewItem viewItem : viewItemContainer.getViewItems()) {
            if (viewItem instanceof ModelViewItem) {
                Object modelItem = ((ModelViewItem)viewItem).getDefinition();
                result.put(modelItem.getPath(), (ModelItem)modelItem);
            }
            if (!(viewItem instanceof ViewItemContainer)) continue;
            result.putAll(ViewHelper._getModelItemsFromViewItemContainer((ViewItemContainer)((Object)viewItem)));
        }
        return result;
    }

    public static boolean areItemsPresentsOnlyOnce(View view) {
        return ViewHelper._areItemsPresentsOnlyOnce(view, new HashSet<String>());
    }

    private static boolean _areItemsPresentsOnlyOnce(ViewItemContainer containerToCheck, Set<String> paths) {
        for (ViewItem viewItem : containerToCheck.getViewItems()) {
            if (viewItem instanceof ModelViewItem) {
                String viewItemPath = ((ModelViewItem)viewItem).getDefinition().getPath();
                if (paths.contains(viewItemPath)) {
                    return false;
                }
                paths.add(viewItemPath);
            }
            if (!(viewItem instanceof ViewItemContainer) || ViewHelper._areItemsPresentsOnlyOnce((ViewItemContainer)((Object)viewItem), paths)) continue;
            return false;
        }
        return true;
    }

    public static View getTruncatedView(View originalView) {
        View view = new View();
        view.addViewItems(ViewHelper._copyItemsForTruncatedView(originalView));
        return view;
    }

    private static List<ViewItem> _copyItemsForTruncatedView(ViewItemContainer currentOrigContainer) {
        ArrayList<ViewItem> copies = new ArrayList<ViewItem>();
        for (ViewItem origChild : currentOrigContainer.getViewItems()) {
            if (!ViewHelper._isEditable(origChild)) continue;
            ViewItem destChild = origChild.createInstance();
            origChild.copyTo(destChild);
            if (origChild instanceof ViewItemContainer) {
                ((ViewItemContainer)((Object)destChild)).addViewItems(ViewHelper._copyItemsForTruncatedView((ViewItemContainer)((Object)origChild)));
            }
            copies.add(destChild);
        }
        return copies;
    }

    private static boolean _isEditable(ViewItem viewItem) {
        boolean bl;
        if (viewItem instanceof ViewElement) {
            ViewElement viewElement = (ViewElement)viewItem;
            bl = viewElement.getDefinition().isEditable();
        } else {
            bl = true;
        }
        return bl;
    }

    public static <T extends ViewItemAccessor> T mergeDuplicatedItems(T originalViewItemAccessor) {
        ViewItemAccessor destinationViewItemAccessor;
        if (originalViewItemAccessor instanceof View) {
            View originalView = (View)originalViewItemAccessor;
            View destinationView = new View();
            originalView.copyTo(destinationView);
            destinationViewItemAccessor = destinationView;
        } else {
            ViewItem destinationViewItem = ((ViewItem)((Object)originalViewItemAccessor)).createInstance();
            ((ViewItem)((Object)originalViewItemAccessor)).copyTo(destinationViewItem);
            destinationViewItemAccessor = (ViewItemAccessor)((Object)destinationViewItem);
        }
        ViewHelper._mergeDuplicatedItems(originalViewItemAccessor, destinationViewItemAccessor, destinationViewItemAccessor, "");
        return (T)destinationViewItemAccessor;
    }

    private static void _mergeDuplicatedItems(ViewItemAccessor currentOrigAccessor, ViewItemAccessor currentDestAccessor, ViewItemAccessor destinationViewItemAccessor, String accessorPath) {
        for (ViewItem origChild : currentOrigAccessor.getViewItems()) {
            if (origChild instanceof ModelViewItem) {
                ViewItem destChild;
                String itemPath;
                String string = itemPath = StringUtils.isNotEmpty((CharSequence)accessorPath) ? accessorPath + "/" + origChild.getName() : origChild.getName();
                if (ViewHelper.hasModelViewItem(destinationViewItemAccessor, itemPath)) {
                    if (!(origChild instanceof ViewItemAccessor)) continue;
                    destChild = ViewHelper.getModelViewItem(destinationViewItemAccessor, itemPath);
                    ViewHelper._mergeDuplicatedItems((ViewItemAccessor)((Object)origChild), (ViewItemAccessor)((Object)destChild), destinationViewItemAccessor, itemPath);
                    continue;
                }
                destChild = origChild.createInstance();
                currentDestAccessor.addViewItem(destChild);
                if (origChild instanceof ViewItemAccessor) {
                    origChild.copyTo(destChild);
                    ViewHelper._mergeDuplicatedItems((ViewItemAccessor)((Object)origChild), (ViewItemAccessor)((Object)destChild), destinationViewItemAccessor, itemPath);
                    continue;
                }
                origChild.copyTo(destChild, destinationViewItemAccessor, itemPath);
                continue;
            }
            ViewItem destChild = origChild.createInstance();
            currentDestAccessor.addViewItem(destChild);
            origChild.copyTo(destChild);
            ViewHelper._mergeDuplicatedItems((ViewItemAccessor)((Object)origChild), (ViewItemAccessor)((Object)destChild), destinationViewItemAccessor, accessorPath);
        }
    }

    public static boolean hasModelViewItem(ViewItemAccessor viewItemAccessor, String itemPath) {
        try {
            ViewHelper.getModelViewItem(viewItemAccessor, itemPath);
            return true;
        }
        catch (BadItemTypeException | UndefinedItemPathException e) {
            return false;
        }
    }

    public static Map<String, Object> viewItemsToJSON(List<ViewItem> viewItems, DefinitionContext context) {
        LinkedHashMap<String, Object> elements = new LinkedHashMap<String, Object>();
        for (ViewItem item : viewItems) {
            Map<String, Object> itemAsJSON = item.toJSON(context);
            if (itemAsJSON.isEmpty()) continue;
            String itemUUID = item.getName();
            if (StringUtils.isEmpty((CharSequence)itemUUID)) {
                itemUUID = UUID.randomUUID().toString();
            }
            elements.put(itemUUID, itemAsJSON);
        }
        return elements;
    }

    public static ModelViewItem getModelViewItem(ViewItemAccessor viewItemAccessor, String itemPath) throws UndefinedItemPathException, BadItemTypeException {
        return new ViewItemGetter(viewItemAccessor).getViewItem(itemPath);
    }

    public static ViewElement getViewElement(ViewItemAccessor viewItemAccessor, String itemPath) throws UndefinedItemPathException, BadItemTypeException {
        return new ViewItemGetter(viewItemAccessor).getModelViewItem(itemPath);
    }

    public static ModelViewItemGroup getModelViewItemGroup(ViewItemAccessor viewItemAccessor, String itemPath) throws UndefinedItemPathException, BadItemTypeException {
        return new ViewItemGetter(viewItemAccessor).getViewItemContainer(itemPath);
    }

    public static Collection<ModelItem> getModelItems(ViewItemAccessor viewItemAccessor) {
        HashSet<ModelItem> modelItems = new HashSet<ModelItem>();
        for (ViewItem viewItem : viewItemAccessor.getViewItems()) {
            if (viewItem instanceof ViewItemGroup) {
                ViewItemGroup viewItemGroup = (ViewItemGroup)viewItem;
                modelItems.addAll(ViewHelper.getModelItems(viewItemGroup));
                continue;
            }
            if (!(viewItem instanceof ViewElement)) continue;
            ViewElement viewElement = (ViewElement)viewItem;
            modelItems.add(viewElement.getDefinition());
        }
        return modelItems;
    }

    public static Optional<View> getView(ViewItemAccessor viewItemAccessor) {
        if (viewItemAccessor instanceof View) {
            View view = (View)viewItemAccessor;
            return Optional.of(view);
        }
        if (viewItemAccessor instanceof ViewItem) {
            ViewItem viewItem = (ViewItem)((Object)viewItemAccessor);
            ViewItemAccessor parent = viewItem.getParent();
            return ViewHelper.getView(parent);
        }
        return Optional.empty();
    }

    private static /* synthetic */ UndefinedItemPathException lambda$getViewItem$4(String[] pathSegments, ViewItemAccessor viewItemAccessor) {
        return new UndefinedItemPathException("Unable to retrieve the view item accessor with the name '" + pathSegments[0] + "'. No view item accessor with this name has been found in view item accessor '" + ViewHelper._getViewItemAccessorName(viewItemAccessor) + "'");
    }

    private static /* synthetic */ boolean lambda$getViewItem$3(String[] pathSegments, ViewItem viewItem) {
        return pathSegments[0].equals(viewItem.getName());
    }

    public static enum InsertMode {
        BEFORE(0),
        AFTER(1);

        private final int _positionFromReferencedViewItem;

        private InsertMode(int offsetFromViewItem) {
            this._positionFromReferencedViewItem = offsetFromViewItem;
        }

        public int getPositionFromReferencedViewItem() {
            return this._positionFromReferencedViewItem;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    private static class ViewItemGetter {
        private final ViewItemAccessor _viewItemAccessor;
        private String _wholePath;

        ViewItemGetter(ViewItemAccessor viewItemAccessor) {
            this._viewItemAccessor = viewItemAccessor;
        }

        ModelViewItem getViewItem(String wholePath) throws UndefinedItemPathException, BadItemTypeException {
            this._wholePath = wholePath;
            BiFunction<ViewItemAccessor, String, ModelViewItem> lastPartGetter = (viewItemAccessor, lastPart) -> this._getDirectViewItem((ViewItemAccessor)viewItemAccessor, (String)lastPart, (Class)ModelViewItem.class);
            return this._getModelViewItem(lastPartGetter);
        }

        ViewElement getModelViewItem(String wholePath) throws UndefinedItemPathException, BadItemTypeException {
            this._wholePath = wholePath;
            BiFunction<ViewItemAccessor, String, ViewElement> lastPartGetter = (viewItemAccessor, lastPart) -> this._getDirectViewItem((ViewItemAccessor)viewItemAccessor, (String)lastPart, (Class)ViewElement.class);
            return this._getModelViewItem(lastPartGetter);
        }

        ModelViewItemGroup getViewItemContainer(String wholePath) throws UndefinedItemPathException, BadItemTypeException {
            this._wholePath = wholePath;
            BiFunction<ViewItemAccessor, String, ModelViewItemGroup> lastPartGetter = (viewItemAccessor, lastPart) -> this._getDirectModelViewItemGroup((ViewItemAccessor)viewItemAccessor, (String)lastPart);
            return this._getModelViewItem(lastPartGetter);
        }

        private <T> T _getModelViewItem(BiFunction<ViewItemAccessor, String, T> lastPartGetter) throws UndefinedItemPathException, BadItemTypeException {
            ArrayDeque<String> parts = new ArrayDeque<String>(Arrays.asList(this._wholePath.split("/")));
            String lastPart = (String)parts.removeLast();
            ViewItemAccessor currentViewItemAccessor = this._viewItemAccessor;
            while (!parts.isEmpty()) {
                String currentPart = (String)parts.pop();
                currentViewItemAccessor = this._getDirectViewItem(currentViewItemAccessor, currentPart, ViewItemAccessor.class);
            }
            return lastPartGetter.apply(currentViewItemAccessor, lastPart);
        }

        private ModelViewItemGroup _getDirectModelViewItemGroup(ViewItemAccessor viewItemAccessor, String itemName) throws UndefinedItemPathException, BadItemTypeException {
            return this._getDirectViewItem(viewItemAccessor, itemName, ModelViewItemGroup.class);
        }

        private <T> T _getDirectViewItem(ViewItemAccessor viewItemAccessor, String itemName, Class<T> resultClass) throws UndefinedItemPathException, BadItemTypeException {
            if (!viewItemAccessor.hasModelViewItem(itemName)) {
                throw new UndefinedItemPathException("For path '" + this._wholePath + "', the part '" + itemName + "' is not defined");
            }
            ModelViewItem modelViewItem = viewItemAccessor.getModelViewItem(itemName);
            if (resultClass.isInstance(modelViewItem)) {
                return resultClass.cast(modelViewItem);
            }
            throw new BadItemTypeException("For path '" + this._wholePath + "', the part '" + itemName + "' does not point to a '" + String.valueOf(resultClass) + "' (got a '" + modelViewItem.getClass().getName() + "')");
        }
    }
}

