/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model;

import java.util.List;
import org.ametys.runtime.model.ModelViewItem;
import org.ametys.runtime.model.ViewItem;
import org.apache.commons.lang3.StringUtils;

public interface ViewItemAccessor {
    public List<ViewItem> getViewItems();

    public void addViewItem(ViewItem var1);

    public void insertViewItem(ViewItem var1, int var2);

    public boolean removeViewItem(ViewItem var1);

    public void clear();

    default public void addViewItems(List<? extends ViewItem> items) {
        for (ViewItem viewItem : items) {
            this.addViewItem(viewItem);
        }
    }

    default public boolean hasModelViewItem(ModelViewItem item) {
        return this.hasModelViewItem(item, "", item.getDefinition().getPath());
    }

    default public boolean hasModelViewItem(ModelViewItem item, String currentAccessorPath, String itemPath) {
        for (ViewItem currentItem : this.getViewItems()) {
            Object currentItemPath = currentAccessorPath;
            if (currentItem instanceof ModelViewItem && ((String)(currentItemPath = (String)currentItemPath + (String)(StringUtils.isNotEmpty((CharSequence)currentAccessorPath) ? "/" + currentItem.getName() : currentItem.getName()))).equals(itemPath) && currentItem.equals(item)) {
                return true;
            }
            if (!(currentItem instanceof ViewItemAccessor) || !((ViewItemAccessor)((Object)currentItem)).hasModelViewItem(item, (String)currentItemPath, itemPath)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasModelViewItem(String itemName) {
        return this.getModelViewItem(itemName) != null;
    }

    default public ModelViewItem getModelViewItem(String itemName) {
        if (StringUtils.isEmpty((CharSequence)itemName)) {
            return null;
        }
        for (ViewItem item : this.getViewItems()) {
            ViewItemAccessor viewItemAccessor;
            ModelViewItem modelViewItem;
            if (item instanceof ModelViewItem) {
                ModelViewItem modelViewItem2 = (ModelViewItem)item;
                if (!itemName.equals(item.getName())) continue;
                return modelViewItem2;
            }
            if (!(item instanceof ViewItemAccessor) || (modelViewItem = (viewItemAccessor = (ViewItemAccessor)((Object)item)).getModelViewItem(itemName)) == null) continue;
            return modelViewItem;
        }
        return null;
    }

    default public ViewItem getViewItem(String itemName) {
        return this.getViewItems().stream().filter(viewItem -> itemName.equals(viewItem.getName())).findFirst().orElse(null);
    }
}

