/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.checker;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerDescriptor;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class ItemCheckerParser {
    protected ThreadSafeComponentManager<ItemChecker> _parameterCheckerManager;
    protected String _pluginName;
    private final Map<ItemCheckerDescriptor, String> _parameterCheckersToLookup = new HashMap<ItemCheckerDescriptor, String>();

    public ItemCheckerParser(ThreadSafeComponentManager<ItemChecker> paramCheckerManager) {
        this._parameterCheckerManager = paramCheckerManager;
    }

    public ItemCheckerDescriptor parseParameterChecker(String pluginName, Configuration paramCheckerConfig) throws ConfigurationException {
        Configuration largeIconConfig;
        Object largeIconPath;
        Configuration mediumIconConfig;
        Object mediumIconPath;
        ItemCheckerDescriptor parameterChecker = this._getParameterCheckerDescriptorInstance();
        String parameterId = paramCheckerConfig.getAttribute("id");
        String concreteClass = paramCheckerConfig.getAttribute("class");
        Configuration smallIconConfig = paramCheckerConfig.getChild("icon-small");
        Object smallIconPath = smallIconConfig.getValue("");
        if (StringUtils.isNotEmpty((CharSequence)smallIconPath)) {
            String plugin = smallIconConfig.getAttribute("plugin", pluginName);
            smallIconPath = "/plugins/" + plugin + "/resources/" + (String)smallIconPath;
        }
        if (StringUtils.isNotEmpty((CharSequence)(mediumIconPath = (mediumIconConfig = paramCheckerConfig.getChild("icon-medium")).getValue("")))) {
            String plugin = mediumIconConfig.getAttribute("plugin", pluginName);
            mediumIconPath = "/plugins/" + plugin + "/resources/" + (String)mediumIconPath;
        }
        if (StringUtils.isNotEmpty((CharSequence)(largeIconPath = (largeIconConfig = paramCheckerConfig.getChild("icon-large")).getValue("")))) {
            String plugin = largeIconConfig.getAttribute("plugin", pluginName);
            largeIconPath = "/plugins/" + plugin + "/resources/" + (String)largeIconPath;
        }
        ItemParserHelper.ConfigurationAndPluginName checkerConfigAndPluginName = new ItemParserHelper.ConfigurationAndPluginName(paramCheckerConfig, pluginName);
        I18nizableText label = ItemParserHelper.parseI18nizableText(checkerConfigAndPluginName, "label");
        I18nizableText description = ItemParserHelper.parseI18nizableText(checkerConfigAndPluginName, "description");
        Configuration uiRefConfig = paramCheckerConfig.getChild("ui-ref");
        int uiRefOrder = uiRefConfig.getChild("order").getValueAsInteger(1);
        String uiRefLocation = null;
        Configuration uiRefLocationConfig = uiRefConfig.getChild("location", false);
        if (uiRefLocationConfig != null) {
            uiRefLocation = uiRefLocationConfig.getAttribute("path");
        }
        LinkedHashSet<String> linkedParamsPaths = new LinkedHashSet<String>();
        for (Configuration linkedParamConfig : paramCheckerConfig.getChild("linked-params").getChildren("param-ref")) {
            linkedParamsPaths.add(linkedParamConfig.getAttribute("id"));
        }
        parameterChecker.setName(parameterId);
        parameterChecker.setLabel(label);
        parameterChecker.setDescription(description);
        parameterChecker.setClass(concreteClass);
        parameterChecker.setSmallIconPath((String)smallIconPath);
        parameterChecker.setMediumIconPath((String)mediumIconPath);
        parameterChecker.setLargeIconPath((String)largeIconPath);
        parameterChecker.setUiRefOrder(uiRefOrder);
        parameterChecker.setUiRefLocation(uiRefLocation);
        parameterChecker.setLinkedParamsPaths(linkedParamsPaths);
        this._setParameterChecker(pluginName, parameterChecker, parameterId, paramCheckerConfig);
        return parameterChecker;
    }

    protected void _setParameterChecker(String pluginName, ItemCheckerDescriptor parameterChecker, String parameterCheckerId, Configuration parameterCheckerConfig) throws ConfigurationException {
        if (parameterCheckerConfig != null) {
            String parameterCheckerClassName = parameterCheckerConfig.getAttribute("class");
            try {
                Class<?> parameterCheckerClass = Class.forName(parameterCheckerClassName);
                this._parameterCheckerManager.addComponent(pluginName, null, parameterCheckerId, parameterCheckerClass, parameterCheckerConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate parameter checker for class: " + parameterCheckerClassName, (Throwable)e);
            }
            this._parameterCheckersToLookup.put(parameterChecker, parameterCheckerId);
        }
    }

    public void lookupComponents() throws Exception {
        this._parameterCheckerManager.initialize();
        for (Map.Entry<ItemCheckerDescriptor, String> entry : this._parameterCheckersToLookup.entrySet()) {
            ItemCheckerDescriptor parameterChecker = entry.getKey();
            String parameterCheckerRole = entry.getValue();
            try {
                parameterChecker.setParameterChecker(this._parameterCheckerManager.lookup(parameterCheckerRole));
            }
            catch (ComponentException e) {
                throw new Exception("Unable to lookup parameter checker role: '" + parameterCheckerRole + "' for parameter: " + String.valueOf(parameterChecker), e);
            }
        }
    }

    protected ItemCheckerDescriptor _getParameterCheckerDescriptorInstance() {
        return new ItemCheckerDescriptor();
    }
}

