/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.disableconditions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemAccessor;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.model.type.ModelItemType;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class AbstractRelativeDisableCondition
implements DisableCondition {
    protected String _id;
    protected String _name;
    protected DisableCondition.OPERATOR _operator;
    protected String _value;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public DisableCondition.OPERATOR getOperator() {
        return this._operator;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public void init(Model model, ModelItem definition) throws Exception {
        try {
            List<ModelItem> allModelItemsInPath = this.getAllModelItemsInPath(model, definition);
            int conditionPathSize = allModelItemsInPath.size();
            for (int i = 0; i < conditionPathSize; ++i) {
                ModelItem modelItem = allModelItemsInPath.get(i);
                this.checkModelItemPathSegment(model, definition, modelItem, i, conditionPathSize);
            }
        }
        catch (UndefinedItemPathException e) {
            String message = String.format("Disable conditions: the disable condition '%s' on model item '%s' in model '%s' references a non existing element", this.getName(), definition.getPath(), model.getId());
            throw new ConfigurationException(message, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Disable conditions: the path of the disable condition '%s' on model item '%s' in model '%s' is not correct.", this.getName(), definition.getPath(), model.getId());
            throw new ConfigurationException(message, (Throwable)e);
        }
    }

    protected List<ModelItem> getAllModelItemsInPath(Model model, ModelItem definition) throws UndefinedItemPathException, IllegalArgumentException {
        String conditionPath = ModelHelper.getDisableConditionAbsolutePath(this, definition.getPath());
        return ModelHelper.getAllModelItemsInPath(conditionPath, List.of(model));
    }

    protected void checkModelItemPathSegment(Model model, ModelItem definition, ModelItem segmentModelItem, int segmentIndex, int conditionPathSize) throws ConfigurationException {
        if (segmentIndex == conditionPathSize - 1 && !(segmentModelItem instanceof ElementDefinition)) {
            String message = String.format("Disable conditions: the disable condition '%s' on model item '%s' in model '%s' references an item that is not an element", this.getName(), definition.getPath(), model.getId());
            throw new ConfigurationException(message);
        }
    }

    @Override
    public <T> boolean evaluate(ModelItem definition, String dataPath, Optional<String> oldDataPath, Map<String, Object> values, Optional<T> object, Map<String, Object> contextualParameters) throws UndefinedItemPathException, BadItemTypeException {
        RelativeDefinitionAndValue definitionAndValue = this._getConditionDefinitionAndValue(definition, dataPath, oldDataPath, values, object, contextualParameters);
        ElementDefinition conditionDefinition = definitionAndValue.definition();
        ModelItemType type = conditionDefinition.getType();
        String valueFromCondition = this.getValue();
        try {
            Object typedvalueFromCondition = type.castValue(valueFromCondition);
            Object value = definitionAndValue.value();
            DisableCondition.OPERATOR operator = this.getOperator();
            if (value != null && value.getClass().isArray()) {
                if (operator == DisableCondition.OPERATOR.EQ) {
                    return Arrays.stream((Object[])value).anyMatch(v -> this.evaluateDisableConditionValue(typedvalueFromCondition, operator, v));
                }
                return Arrays.stream((Object[])value).allMatch(v -> this.evaluateDisableConditionValue(typedvalueFromCondition, operator, v));
            }
            return this.evaluateDisableConditionValue(typedvalueFromCondition, operator, value);
        }
        catch (BadItemTypeException e) {
            throw new IllegalStateException("Cannot convert the condition value '" + valueFromCondition + "' to a '" + type.getId() + "' for model item '" + this.getName() + "'", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred while comparing values in type '" + type.getId() + "' for model item '" + this.getName() + "'.", e);
        }
    }

    protected <T> RelativeDefinitionAndValue _getConditionDefinitionAndValue(ModelItem definition, String dataPath, Optional<String> oldDataPath, Map<String, Object> values, Optional<T> object, Map<String, Object> contextualParameters) throws UndefinedItemPathException, BadItemTypeException {
        String conditionAbsoluteDataPath = ModelHelper.getDisableConditionAbsolutePath(this, dataPath);
        Optional<String> oldConditionAbsoluteDataPath = oldDataPath.map(path -> ModelHelper.getDisableConditionAbsolutePath(this, path));
        ModelItem conditionModelItem = this.getModelItem(definition.getModel(), conditionAbsoluteDataPath, contextualParameters);
        if (!(conditionModelItem instanceof ElementDefinition)) {
            throw new BadItemTypeException("Unable to evaluate disable condition '" + conditionAbsoluteDataPath + "'. This condition referenced does not reference an element");
        }
        ElementDefinition conditionDefinition = (ElementDefinition)conditionModelItem;
        Object conditionValue = this.containsRelativeValue(definition.getModel(), conditionAbsoluteDataPath, values, contextualParameters) ? this.getRelativeValueFromMap(definition.getModel(), conditionAbsoluteDataPath, values, contextualParameters) : (object.isPresent() ? this.getStoredRelativeValue(conditionAbsoluteDataPath, oldConditionAbsoluteDataPath, object.get(), contextualParameters) : null);
        return new RelativeDefinitionAndValue(conditionDefinition, conditionValue);
    }

    protected ModelItem getModelItem(ModelItemAccessor modelItemAccessor, String dataPath, Map<String, Object> contextualParameters) throws UndefinedItemPathException {
        return ModelHelper.getModelItem(dataPath, List.of(modelItemAccessor));
    }

    protected boolean containsRelativeValue(ModelItemAccessor modelItemAccessor, String conditionDataPath, Map<String, Object> values, Map<String, Object> contextualParameters) {
        return values.containsKey(conditionDataPath);
    }

    protected Object getRelativeValueFromMap(ModelItemAccessor modelItemAccessor, String conditionDataPath, Map<String, Object> values, Map<String, Object> contextualParameters) {
        return values.get(conditionDataPath);
    }

    protected abstract <T> Object getStoredRelativeValue(String var1, Optional<String> var2, T var3, Map<String, Object> var4);

    protected boolean evaluateDisableConditionValue(Object conditionValue, DisableCondition.OPERATOR conditionOperator, Object value) {
        if ((value == null || value instanceof Comparable) && (conditionValue == null || conditionValue instanceof Comparable)) {
            Comparable comparableParameterValue = (Comparable)AbstractRelativeDisableCondition._emptyStringToNull(value);
            Comparable comparableCompareValue = (Comparable)AbstractRelativeDisableCondition._emptyStringToNull(conditionValue);
            int comparison = comparableParameterValue != null && comparableCompareValue != null ? comparableParameterValue.compareTo(comparableCompareValue) : (comparableCompareValue != null ? -1 : (comparableParameterValue != null ? 1 : 0));
            switch (conditionOperator) {
                case NEQ: {
                    return comparison != 0;
                }
                case GEQ: {
                    return comparison >= 0;
                }
                case GT: {
                    return comparison > 0;
                }
                case LT: {
                    return comparison < 0;
                }
                case LEQ: {
                    return comparison <= 0;
                }
            }
            return comparison == 0;
        }
        throw new IllegalStateException("Values '" + String.valueOf(value) + "' and '" + String.valueOf(conditionValue) + "' are not comparable");
    }

    protected static Object _emptyStringToNull(Object value) {
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    public record RelativeDefinitionAndValue(ElementDefinition definition, Object value) {
    }
}

