/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.disableconditions;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.UUID;
import org.ametys.runtime.model.disableconditions.AbstractDisableConditions;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.ametys.runtime.util.ParameterizedTypesHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public abstract class AbstractStaticRelativeDisableConditions<T extends DisableCondition>
extends AbstractDisableConditions<T>
implements Component,
Serviceable,
Contextualizable,
Configurable,
Disposable,
LogEnabled,
PluginAware {
    private Context _context;
    private ServiceManager _manager;
    private String _pluginName;
    private String _featureName;
    private ThreadSafeComponentManager<DisableConditions> _disableConditionsManager;
    private ThreadSafeComponentManager<T> _disableConditionManager;
    private Logger _logger;
    private Class<T> _conditionType = ParameterizedTypesHelper.getFirstActualClassArgument(AbstractDisableConditions.class, this.getClass());

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._disableConditionsManager = new ThreadSafeComponentManager();
        this._disableConditionsManager.setLogger(this.getLogger());
        this._disableConditionsManager.contextualize(this._context);
        this._disableConditionsManager.service(this._manager);
        this._disableConditionManager = new ThreadSafeComponentManager();
        this._disableConditionManager.setLogger(this.getLogger());
        this._disableConditionManager.contextualize(this._context);
        this._disableConditionManager.service(this._manager);
        ArrayList<CallSite> conditionsRoles = new ArrayList<CallSite>();
        ArrayList<String> conditionRoles = new ArrayList<String>();
        for (Configuration conditionConfiguration : configuration.getChildren()) {
            String tagName = conditionConfiguration.getName();
            if (tagName.equals("conditions")) {
                String conditionsRole = this.getClass().getName() + "$" + UUID.randomUUID().toString();
                this._disableConditionsManager.addComponent(this._pluginName, this._featureName, conditionsRole, this.getClass(), conditionConfiguration);
                conditionsRoles.add((CallSite)((Object)conditionsRole));
                continue;
            }
            if (!tagName.equals("condition")) continue;
            String conditionRole = this.configureDisableCondition(conditionConfiguration);
            conditionRoles.add(conditionRole);
        }
        try {
            this._disableConditionsManager.initialize();
            for (String string : conditionsRoles) {
                DisableConditions conditions = this._disableConditionsManager.lookup(string);
                this.getSubConditions().add(conditions);
            }
            this._disableConditionManager.initialize();
            for (String string : conditionRoles) {
                DisableCondition condition = (DisableCondition)this._disableConditionManager.lookup(string);
                this.getConditions().add(condition);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to configure disable conditions", configuration, (Throwable)e);
        }
        this.setAssociation(DisableConditions.ASSOCIATION_TYPE.valueOf(configuration.getAttribute("type", "and").toUpperCase()));
    }

    protected String configureDisableCondition(Configuration conditionConfiguration) throws ConfigurationException {
        String id = conditionConfiguration.getAttribute("id", null);
        if (id != null) {
            String conditionRole = id + "$" + UUID.randomUUID().toString();
            this.addDisableConditionComponent(conditionRole, this._conditionType, conditionConfiguration);
            return conditionRole;
        }
        throw new ConfigurationException("Unable to configure a condition with no specified id of relative item", conditionConfiguration);
    }

    protected void addDisableConditionComponent(String conditionRole, Class<T> conditionClass, Configuration conditionConfiguration) {
        this._disableConditionManager.addComponent(this._pluginName, this._featureName, conditionRole, conditionClass, conditionConfiguration);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
    }

    protected Logger getLogger() {
        return this._logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void dispose() {
        this._disableConditionsManager.dispose();
        this._disableConditionsManager = null;
        this._disableConditionManager.dispose();
        this._disableConditionManager = null;
    }
}

