/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.disableconditions;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.disableconditions.DisableConditionsEvaluator;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UndefinedItemPathException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;

public class DefaultDisableConditionsEvaluator
extends AbstractLogEnabled
implements Component,
DisableConditionsEvaluator {
    public static final String ROLE = DefaultDisableConditionsEvaluator.class.getName();

    @Override
    public boolean evaluateDisableConditions(ModelItem definition, String dataPath, Map<String, Object> values) throws UndefinedItemPathException, BadItemTypeException {
        return this.evaluateDisableConditions(definition, definition.getDisableConditions(), dataPath, Optional.empty(), values, Optional.empty(), new HashMap<String, Object>());
    }

    @Override
    public <T> boolean evaluateDisableConditions(ModelItem definition, String dataPath, T object) throws UndefinedItemPathException, BadItemTypeException {
        return this.evaluateDisableConditions(definition, definition.getDisableConditions(), dataPath, Optional.empty(), Map.of(), Optional.ofNullable(object), new HashMap<String, Object>());
    }

    @Override
    public <T> boolean evaluateDisableConditions(ModelItem definition, String dataPath, Optional<String> oldDataPath, Map<String, Object> values, T object, Map<String, Object> contextualParameters) throws UndefinedItemPathException, BadItemTypeException {
        return this.evaluateDisableConditions(definition, definition.getDisableConditions(), dataPath, oldDataPath, values, Optional.ofNullable(object), contextualParameters);
    }

    protected <T> boolean evaluateDisableConditions(ModelItem definition, DisableConditions<? extends DisableCondition> disableConditions, String dataPath, Optional<String> oldDataPath, Map<String, Object> values, Optional<T> object, Map<String, Object> contextualParameters) throws UndefinedItemPathException, BadItemTypeException {
        boolean result;
        boolean andOperator;
        if (!ModelHelper.hasDisableConditions(disableConditions)) {
            return false;
        }
        boolean disabled = andOperator = disableConditions.getAssociationType() == DisableConditions.ASSOCIATION_TYPE.AND;
        for (DisableConditions<? extends DisableCondition> disableConditions2 : disableConditions.getSubConditions()) {
            result = this.evaluateDisableConditions(definition, disableConditions2, dataPath, oldDataPath, values, object, contextualParameters);
            if (this._resultIsSufficient(andOperator, result)) {
                return result;
            }
            disabled = andOperator ? disabled && result : disabled || result;
        }
        for (DisableCondition disableCondition : disableConditions.getConditions()) {
            result = disableCondition.evaluate(definition, dataPath, oldDataPath, values, object, contextualParameters);
            if (this._resultIsSufficient(andOperator, result)) {
                return result;
            }
            disabled = andOperator ? disabled && result : disabled || result;
        }
        return disabled;
    }

    protected boolean _resultIsSufficient(boolean andOperator, boolean result) {
        return andOperator && !result || !andOperator && result;
    }
}

