/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ViewItem;
import org.apache.commons.lang3.StringUtils;

public class DataContext {
    private List<String> _fullDataPath = new ArrayList<String>();
    private List<String> _dataPath = new ArrayList<String>();
    private Optional<ModelItem> _modelItem = Optional.empty();
    private Optional<ViewItem> _viewItem = Optional.empty();
    private Locale _locale;
    private boolean _renderEmptyValues = true;
    private boolean _renderDisabledValues;

    protected DataContext() {
    }

    protected DataContext(DataContext context) {
        this.withDataPath(context.getDataPath());
        this.withFullDataPath(context.getFullDataPath());
        this.withModelItem(context.getModelItem().orElse(null));
        this.withViewItem(context.getViewItem().orElse(null));
        this.withLocale(context.getLocale());
        this.withEmptyValues(context.renderEmptyValues());
        this.withDisabledValues(context.renderDisabledValues());
    }

    public static DataContext newInstance() {
        return new DataContext();
    }

    public static DataContext newInstance(DataContext context) {
        return new DataContext(context);
    }

    public DataContext cloneContext() {
        return DataContext.newInstance(this);
    }

    public String getDataPath() {
        return StringUtils.join(this._dataPath, (String)"/");
    }

    public String getDataPathLastSegment() {
        return this._dataPath.get(this._dataPath.size() - 1);
    }

    public <T extends DataContext> T withDataPath(String dataPath) {
        this._dataPath = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)dataPath)) {
            this._dataPath.add(dataPath);
            this._fullDataPath.add(dataPath);
        }
        return (T)this;
    }

    public String getFullDataPath() {
        return StringUtils.join(this._fullDataPath, (String)"/");
    }

    public <T extends DataContext> T withFullDataPath(String fullDataPath) {
        this._fullDataPath = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)fullDataPath)) {
            this._fullDataPath.add(fullDataPath);
        }
        return (T)this;
    }

    public <T extends DataContext> T addSegmentToDataPath(String segment) {
        this._dataPath.add(segment);
        this._fullDataPath.add(segment);
        return (T)this;
    }

    public <T extends DataContext> T addSuffixToLastSegment(String suffix) {
        int segmentIndex = this._dataPath.size() - 1;
        this._dataPath.set(segmentIndex, this._dataPath.get(segmentIndex) + suffix);
        segmentIndex = this._fullDataPath.size() - 1;
        this._fullDataPath.set(segmentIndex, this._fullDataPath.get(segmentIndex) + suffix);
        return (T)this;
    }

    public Optional<ModelItem> getModelItem() {
        return this._modelItem;
    }

    public <T extends DataContext> T withModelItem(ModelItem modelItem) {
        this._modelItem = Optional.ofNullable(modelItem);
        return (T)this;
    }

    public Optional<ViewItem> getViewItem() {
        return this._viewItem;
    }

    public <T extends DataContext> T withViewItem(ViewItem viewItem) {
        this._viewItem = Optional.ofNullable(viewItem);
        return (T)this;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public <T extends DataContext> T withLocale(Locale locale) {
        this._locale = locale;
        return (T)this;
    }

    public boolean renderEmptyValues() {
        return this._renderEmptyValues;
    }

    public <T extends DataContext> T withEmptyValues(boolean renderEmptyValues) {
        this._renderEmptyValues = renderEmptyValues;
        return (T)this;
    }

    public boolean renderDisabledValues() {
        return this._renderDisabledValues;
    }

    public <T extends DataContext> T withDisabledValues(boolean renderDisabledValues) {
        this._renderDisabledValues = renderDisabledValues;
        return (T)this;
    }
}

