/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.model.type.xml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.ElementType;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public interface XMLElementType<T>
extends ElementType<T> {
    default public Object read(Configuration parentConfiguration, String name) throws ConfigurationException {
        Configuration elementConfiguration = parentConfiguration.getChild(name);
        return this.readValueFromNode(elementConfiguration);
    }

    default public Object readValueFromNode(Configuration elementConfiguration) throws ConfigurationException {
        if (elementConfiguration == null) {
            return null;
        }
        Configuration[] valuesConfiguration = elementConfiguration.getChildren("value");
        if (valuesConfiguration.length > 0) {
            ArrayList values = new ArrayList();
            for (Configuration valueConfiguration : valuesConfiguration) {
                Object value = this.parseConfiguration(valueConfiguration);
                if (value == null) continue;
                values.add(value);
            }
            return Array.newInstance(this.getManagedClass(), values.size());
        }
        return this.parseConfiguration(elementConfiguration);
    }

    default public void write(ContentHandler contentHandler, String name, Object value) throws SAXException, BadItemTypeException {
        if (value == null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)name);
        } else if (this.getManagedClass().isInstance(value)) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)name, (String)StringUtils.defaultString((String)this.toString(value)));
        } else if (this.getManagedClassArray().isInstance(value)) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)name);
            for (Object singleValue : (Object[])value) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)"value", (String)StringUtils.defaultString((String)this.toString(singleValue)));
            }
            XMLUtils.endElement((ContentHandler)contentHandler, (String)name);
        } else {
            throw new BadItemTypeException("Try to write the non " + this.getManagedClass().getName() + " value '" + String.valueOf(value) + "' on element named '" + name + "'");
        }
    }
}

