/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.slf4j.LoggerFactory;

public class DefaultValidator
extends AbstractLogEnabled
implements Validator,
Configurable,
PluginAware,
Serviceable {
    protected boolean _isMandatory;
    protected Pattern _regexp;
    protected I18nizableText _invalidText;
    protected String _pluginName;
    protected ServiceManager _smanager;

    public DefaultValidator() {
    }

    public DefaultValidator(String regexp, boolean mandatory) {
        this._isMandatory = mandatory;
        if (regexp != null) {
            this._regexp = Pattern.compile(regexp);
        }
        this.enableLogging((Logger)new SLF4JLoggerAdapter(LoggerFactory.getLogger(this.getClass())));
    }

    public DefaultValidator(String regexp, I18nizableText invalidText, boolean mandatory) {
        this._isMandatory = mandatory;
        if (regexp != null) {
            this._regexp = Pattern.compile(regexp);
        }
        this._invalidText = invalidText;
        this.enableLogging((Logger)new SLF4JLoggerAdapter(LoggerFactory.getLogger(this.getClass())));
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration textConfig;
        Configuration validatorConfig = configuration.getChild("validation");
        this._isMandatory = validatorConfig.getChild("mandatory", false) != null;
        String regexp = validatorConfig.getChild("regexp").getValue(null);
        if (regexp != null) {
            this._regexp = Pattern.compile(regexp);
        }
        if ((textConfig = validatorConfig.getChild("invalidText", false)) != null) {
            this._invalidText = I18nizableText.parseI18nizableText(textConfig, "plugin." + this._pluginName);
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("mandatory", this._isMandatory);
        if (this._regexp != null) {
            configuration.put("regexp", this._regexp);
        }
        if (this._invalidText != null) {
            configuration.put("invalidText", this._invalidText);
        }
        return configuration;
    }

    @Override
    public ValidationResult validate(Object value) {
        return value != null && value.getClass().isArray() ? this.validateArrayValues((Object[])value) : this.validateSingleValue(value);
    }

    protected ValidationResult validateSingleValue(Object value) {
        ValidationResult result = new ValidationResult();
        if (this._isMandatory && (value == null || value.toString().length() == 0)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The validator refused a missing or empty value for a mandatory parameter");
            }
            result.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY"));
        }
        if (this._regexp != null && value != null && value.toString().length() != 0 && !this._regexp.matcher(value.toString()).matches()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The validator refused a value for a parameter that should respect a regexep");
            }
            result.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_DEFAULT_VALIDATOR_PATTERN_FAILED"));
        }
        return result;
    }

    protected ValidationResult validateArrayValues(Object[] values) {
        ValidationResult result = new ValidationResult();
        if (this._isMandatory && (values == null || values.length == 0)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The validator refused a missing or empty value for a mandatory parameter");
            }
            result.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_DEFAULT_VALIDATOR_MANDATORY"));
        }
        if (this._regexp != null && values != null && !this._matchRegexp(values)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The validator refused a value for a parameter that should respect a regexep");
            }
            result.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_DEFAULT_VALIDATOR_PATTERN_FAILED"));
        }
        return result;
    }

    private boolean _matchRegexp(Object[] values) {
        for (Object value : values) {
            if (this._regexp.matcher(value.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._invalidText == null ? 0 : this._invalidText.hashCode());
        result = 31 * result + (this._isMandatory ? 1231 : 1237);
        result = 31 * result + (this._pluginName == null ? 0 : this._pluginName.hashCode());
        result = 31 * result + (this._regexp == null ? 0 : this._regexp.hashCode());
        result = 31 * result + (this._smanager == null ? 0 : this._smanager.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultValidator other = (DefaultValidator)obj;
        if (this._invalidText == null ? other._invalidText != null : !this._invalidText.equals(other._invalidText)) {
            return false;
        }
        if (this._isMandatory != other._isMandatory) {
            return false;
        }
        if (this._regexp == null) {
            if (other._regexp != null) {
                return false;
            }
        } else {
            if (other._regexp == null) {
                return false;
            }
            if (!this._regexp.pattern().equals(other._regexp.pattern())) {
                return false;
            }
        }
        return true;
    }
}

