/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ametys.runtime.i18n.I18nizableText;

public class ValidationResult {
    private List<I18nizableText> _infos = new ArrayList<I18nizableText>();
    private List<I18nizableText> _warnings = new ArrayList<I18nizableText>();
    private List<I18nizableText> _errors = new ArrayList<I18nizableText>();

    public boolean hasInfos() {
        return !this._infos.isEmpty();
    }

    public List<I18nizableText> getInfos() {
        return Collections.unmodifiableList(this._infos);
    }

    public void addInfo(I18nizableText infoLabel) {
        this._infos.add(infoLabel);
    }

    public void addInfos(List<I18nizableText> infoLabels) {
        this._infos.addAll(infoLabels);
    }

    public boolean hasWarnings() {
        return !this._warnings.isEmpty();
    }

    public List<I18nizableText> getWarnings() {
        return Collections.unmodifiableList(this._warnings);
    }

    public void addWarning(I18nizableText warningLabel) {
        this._warnings.add(warningLabel);
    }

    public void addWarnings(List<I18nizableText> warningLabels) {
        this._warnings.addAll(warningLabels);
    }

    public boolean hasErrors() {
        return !this._errors.isEmpty();
    }

    public List<I18nizableText> getErrors() {
        return Collections.unmodifiableList(this._errors);
    }

    public void addError(I18nizableText errorLabel) {
        this._errors.add(errorLabel);
    }

    public void addErrors(List<I18nizableText> errorLabels) {
        this._errors.addAll(errorLabels);
    }

    public void addResult(ValidationResult result) {
        this.addInfos(result.getInfos());
        this.addWarnings(result.getWarnings());
        this.addErrors(result.getErrors());
    }

    public boolean isEmpty() {
        return !this.hasErrors() && !this.hasWarnings() && !this.hasInfos();
    }

    public static ValidationResult empty() {
        return new ValidationResult();
    }
}

