/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.parameter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.ValidationResult;

public class ValidationResults {
    private Map<String, ValidationResult> _results = new LinkedHashMap<String, ValidationResult>();

    public boolean hasInfos() {
        return this._results.values().stream().anyMatch(ValidationResult::hasInfos);
    }

    public Map<String, List<I18nizableText>> getAllInfos() {
        return this._results.entrySet().stream().filter(entry -> ((ValidationResult)entry.getValue()).hasInfos()).map(entry -> Map.entry((String)entry.getKey(), ((ValidationResult)entry.getValue()).getInfos())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean hasWarnings() {
        return this._results.values().stream().anyMatch(ValidationResult::hasWarnings);
    }

    public Map<String, List<I18nizableText>> getAllWarnings() {
        return this._results.entrySet().stream().filter(entry -> ((ValidationResult)entry.getValue()).hasWarnings()).map(entry -> Map.entry((String)entry.getKey(), ((ValidationResult)entry.getValue()).getWarnings())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean hasErrors() {
        return this._results.values().stream().anyMatch(ValidationResult::hasErrors);
    }

    public Map<String, List<I18nizableText>> getAllErrors() {
        return this._results.entrySet().stream().filter(entry -> ((ValidationResult)entry.getValue()).hasErrors()).map(entry -> Map.entry((String)entry.getKey(), ((ValidationResult)entry.getValue()).getErrors())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, ValidationResult> getResults() {
        return this._results;
    }

    public void addResult(String dataPath, ValidationResult result) {
        this._results.put(dataPath, result);
    }

    public void addResults(ValidationResults results) {
        this._results.putAll(results.getResults());
    }

    public String toString() {
        return this._results.toString();
    }
}

