/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.CorrectedDependencies;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.IncomingDeactivation;
import org.ametys.runtime.plugin.LoadedFeaturesDump;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureActivator
implements FeatureActivator {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, Plugin> _allPlugins;
    protected boolean _safeMode;
    protected CorrectedDependencies _correctedDependencies;

    AbstractFeatureActivator(Map<String, Plugin> allPlugins) {
        this._allPlugins = allPlugins;
    }

    protected Map<String, Plugin> computeActivePlugins(Collection<String> excludedPlugins, Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Map<String, ExtensionPointDefinition> extensionPoints, Collection<PluginIssue> errors) {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        for (String pluginName : this._allPlugins.keySet()) {
            if (!excludedPlugins.contains(pluginName)) {
                Plugin plugin = this._allPlugins.get(pluginName);
                plugins.put(pluginName, plugin);
                this._logger.info("Plugin '{}' loaded", (Object)pluginName);
                Map<String, ExtensionPointDefinition> extPoints = plugin.getExtensionPointDefinitions();
                for (String point : extPoints.keySet()) {
                    ExtensionPointDefinition definition = extPoints.get(point);
                    if (this._safeMode && !definition._safe) continue;
                    if (extensionPoints.containsKey(point)) {
                        String message = "The extension point '" + point + "', defined in the plugin '" + pluginName + "' is already defined in another plugin. ";
                        PluginIssue issue = new PluginIssue(pluginName, null, PluginIssue.PluginIssueCode.EXTENSIONPOINT_ALREADY_EXIST, definition._configuration.getLocation(), message);
                        if (!this._safeMode) {
                            this._logger.error(message);
                            errors.add(issue);
                            continue;
                        }
                        this._logger.debug("[Safe mode] {}", (Object)message);
                        continue;
                    }
                    extensionPoints.put(point, definition);
                }
                Map<String, Feature> features = plugin.getFeatures();
                for (String id : features.keySet()) {
                    Feature feature = features.get(id);
                    if (!this._safeMode || feature.isSafe()) {
                        initialFeatures.put(id, feature);
                        continue;
                    }
                    inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.NOT_SAFE, null));
                }
                continue;
            }
            this._logger.debug("Plugin '{}' is excluded", (Object)pluginName);
        }
        return plugins;
    }

    protected Map<String, Collection<IncomingDeactivation>> computeIncomingDeactivations(Map<String, Feature> features) {
        HashMap<String, Collection<IncomingDeactivation>> incomingDeactivations = new HashMap<String, Collection<IncomingDeactivation>>();
        for (String id : features.keySet()) {
            Feature feature = features.get(id);
            Collection<String> deactivations = feature.getDeactivations();
            this._fillDeactivationsByFeature(id, deactivations, incomingDeactivations);
            Collection<String> overrides = feature.getOverrides();
            this._fillOverridesByFeature(id, overrides, incomingDeactivations);
        }
        this._checkNoMultipleOverriders(incomingDeactivations);
        return incomingDeactivations;
    }

    private void _fillDeactivationsByFeature(String featureIdTriggeringDeactivation, Collection<String> deactivations, Map<String, Collection<IncomingDeactivation>> incomingDeactivations) {
        for (String deactivatedFeature : deactivations) {
            Collection deps = incomingDeactivations.computeIfAbsent(deactivatedFeature, __ -> new ArrayList());
            deps.add(new IncomingDeactivation(IncomingDeactivation.Type.DEACTIVATED, featureIdTriggeringDeactivation));
        }
    }

    private void _fillOverridesByFeature(String featureIdTriggeringOverride, Collection<String> overrides, Map<String, Collection<IncomingDeactivation>> incomingDeactivations) {
        for (String overriddenFeature : overrides) {
            Collection deps = incomingDeactivations.computeIfAbsent(overriddenFeature, __ -> new ArrayList());
            deps.add(new IncomingDeactivation(IncomingDeactivation.Type.OVERRIDDEN, featureIdTriggeringOverride));
        }
    }

    private void _checkNoMultipleOverriders(Map<String, Collection<IncomingDeactivation>> incomingDeactivations) {
        for (Map.Entry<String, Collection<IncomingDeactivation>> incomingDeactivation : incomingDeactivations.entrySet()) {
            Collection overriders = incomingDeactivation.getValue().stream().filter(deactivator -> deactivator.getType() == IncomingDeactivation.Type.OVERRIDDEN).collect(Collectors.toList());
            if (overriders.size() <= 1) continue;
            String overriddenFeature = incomingDeactivation.getKey();
            throw new IllegalStateException(String.format("Feature '%s' is overridden by %s. It cannot be overridden by 2 features. The application will not be able to boot.", overriddenFeature, overriders));
        }
    }

    protected void removeInactiveFeatures(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Map<String, Collection<IncomingDeactivation>> incomingDeactivations, Map<String, String> componentsConfig) {
        Iterator<String> it = initialFeatures.keySet().iterator();
        while (it.hasNext()) {
            Collection<IncomingDeactivation> deactivations;
            String id = it.next();
            Feature feature = initialFeatures.get(id);
            if (incomingDeactivations.containsKey(id) && !(deactivations = incomingDeactivations.get(id)).isEmpty()) {
                this._logger.debug("Removing feature {} deactivated by features {}.", (Object)id, deactivations);
                it.remove();
                List<String> sources = deactivations.stream().map(IncomingDeactivation::getFeatureId).toList();
                inactiveFeatures.put(id, new PluginsManager.InactivityStatus(this._getCause(deactivations), sources));
                continue;
            }
            Map<String, String> components = feature.getComponentsIds();
            for (String role : components.keySet()) {
                String componentId = components.get(role);
                String selectedId = componentsConfig.get(role);
                if (selectedId == null || selectedId.equals(componentId)) continue;
                this._logger.debug("Removing feature '{}' as it contains the component id '{}' for role '{}' but the user selected the id '{}' for that role.", new Object[]{id, componentId, role, selectedId});
                it.remove();
                inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.COMPONENT, null));
            }
        }
    }

    protected void removeWrongPointReferences(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Map<String, ExtensionPointDefinition> extensionPoints, Collection<PluginIssue> errors) {
        Set<String> ids = initialFeatures.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            Feature feature = initialFeatures.get(id);
            Map<String, Collection<String>> extensionsIds = feature.getExtensionsIds();
            boolean hasBeenRemoved = false;
            for (String point : extensionsIds.keySet()) {
                if (extensionPoints.containsKey(point)) continue;
                String message = "In feature '" + id + "' an extension references the non-existing point '" + point + "'.";
                this._logger.error(message);
                PluginIssue issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.INVALID_POINT, null, message);
                errors.add(issue);
                if (hasBeenRemoved) continue;
                it.remove();
                inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.INVALID_POINT, null));
                hasBeenRemoved = true;
            }
        }
    }

    protected Map<String, Feature> processOutgoingDependencies(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Collection<PluginIssue> errors) {
        boolean processDependencies = true;
        while (processDependencies) {
            processDependencies = false;
            Set<String> ids = initialFeatures.keySet();
            Iterator<String> it = ids.iterator();
            while (it.hasNext()) {
                String id = (String)it.next();
                if (!this._processOutgoingDependenciesForFeature(it, initialFeatures, inactiveFeatures, id)) continue;
                processDependencies = true;
            }
        }
        LinkedHashMap<String, Feature> resultFeatures = new LinkedHashMap<String, Feature>();
        for (String featureId : initialFeatures.keySet()) {
            this._computeFeaturesDependencies(featureId, initialFeatures, resultFeatures, Collections.singletonList(featureId), errors);
        }
        return resultFeatures;
    }

    private boolean _processOutgoingDependenciesForFeature(Iterator<String> initialFeatureIterator, Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, String currentInitialFeatureId) {
        Feature currentInitialFeature = initialFeatures.get(currentInitialFeatureId);
        Collection<String> dependencies = this._correctedDependencies.getCorrectedDependencies(currentInitialFeature);
        for (String dependency : dependencies) {
            if (initialFeatures.containsKey(dependency)) continue;
            this._logger.debug("The feature '{}' depends on '{}' which is not present. It will be ignored.", (Object)currentInitialFeatureId, (Object)dependency);
            initialFeatureIterator.remove();
            inactiveFeatures.put(currentInitialFeatureId, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.DEPENDENCY, dependencies));
            return true;
        }
        return false;
    }

    private void _computeFeaturesDependencies(String featureId, Map<String, Feature> initialFeatures, Map<String, Feature> resultFeatures, List<String> involvedFeaturesInDependencyChain, Collection<PluginIssue> errors) {
        Feature feature = Objects.requireNonNull(initialFeatures.get(featureId), String.format("Feature '%s' cannot be found", featureId));
        Collection<String> dependencies = this._correctedDependencies.getCorrectedDependencies(feature);
        for (String dependency : dependencies) {
            if (involvedFeaturesInDependencyChain.contains(dependency)) {
                String stringDependencyChain = Stream.concat(involvedFeaturesInDependencyChain.stream(), Stream.of(dependency)).collect(Collectors.joining("->"));
                String message = "Circular dependency detected for feature: " + feature.getFeatureId() + ". The dependency chain is: \n" + stringDependencyChain;
                this._logger.error(message);
                PluginIssue issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.CIRCULAR_DEPENDENCY, null, message);
                errors.add(issue);
                continue;
            }
            if (resultFeatures.containsKey(dependency)) continue;
            List dependencyChain = ListUtils.union(involvedFeaturesInDependencyChain, Collections.singletonList(dependency));
            this._computeFeaturesDependencies(dependency, initialFeatures, resultFeatures, dependencyChain, errors);
        }
        resultFeatures.put(featureId, feature);
    }

    protected Map<String, Collection<String>> computeIncomingDependencies(Map<String, Feature> features) {
        HashMap<String, Collection<String>> incomingDependencies = new HashMap<String, Collection<String>>();
        for (String id : features.keySet()) {
            Feature feature = features.get(id);
            Collection<String> dependencies = this._correctedDependencies.getCorrectedDependencies(feature);
            for (String dependency : dependencies) {
                ArrayList<String> deps = (ArrayList<String>)incomingDependencies.get(dependency);
                if (deps == null) {
                    deps = new ArrayList<String>();
                    incomingDependencies.put(dependency, deps);
                }
                deps.add(id);
            }
        }
        return incomingDependencies;
    }

    protected Map<String, Collection<String>> computeOutgoingDependencies(Map<String, Feature> features) {
        HashMap<String, Collection<String>> outgoingDependencies = new HashMap<String, Collection<String>>();
        for (String id : features.keySet()) {
            Feature feature = features.get(id);
            Collection<String> dependencies = this._correctedDependencies.getCorrectedDependencies(feature);
            outgoingDependencies.put(id, dependencies);
        }
        return outgoingDependencies;
    }

    protected void removeUnusedPassiveFeatures(Map<String, Feature> features, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Map<String, Collection<String>> incomingDependencies) {
        Set<String> ids = features.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            Feature feature = features.get(id);
            if (!feature.isPassive() || incomingDependencies.containsKey(id)) continue;
            this._logger.debug("Remove passive feature '{}'", (Object)id);
            it.remove();
            inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.PASSIVE, null));
        }
    }

    protected Map<String, Map<String, ExtensionDefinition>> computeExtensions(Map<String, Feature> features, Collection<PluginIssue> errors) {
        HashMap<String, Map<String, ExtensionDefinition>> extensionsDefinitions = new HashMap<String, Map<String, ExtensionDefinition>>();
        for (Feature feature : features.values()) {
            Map<String, Map<String, ExtensionDefinition>> extensionsConfs = feature.getExtensions();
            for (String point : extensionsConfs.keySet()) {
                Map<String, ExtensionDefinition> featureExtensions = extensionsConfs.get(point);
                LinkedHashMap<String, ExtensionDefinition> globalExtensions = (LinkedHashMap<String, ExtensionDefinition>)extensionsDefinitions.get(point);
                if (globalExtensions == null) {
                    globalExtensions = new LinkedHashMap<String, ExtensionDefinition>(featureExtensions);
                    extensionsDefinitions.put(point, globalExtensions);
                    continue;
                }
                for (String id : featureExtensions.keySet()) {
                    if (globalExtensions.containsKey(id)) {
                        String message = "The extension '" + id + "' to point '" + point + "' is already defined in another feature.";
                        this._logger.error(message);
                        PluginIssue issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.EXTENSION_ALREADY_EXIST, null, message);
                        errors.add(issue);
                        continue;
                    }
                    ExtensionDefinition definition = featureExtensions.get(id);
                    globalExtensions.put(id, definition);
                }
            }
        }
        return extensionsDefinitions;
    }

    protected Map<String, ComponentDefinition> computeComponents(Map<String, Feature> features, Map<String, String> componentsConfig, Collection<PluginIssue> errors) {
        HashMap<String, ComponentDefinition> components = new HashMap<String, ComponentDefinition>();
        for (Feature feature : features.values()) {
            Map<String, ComponentDefinition> featureComponents = feature.getComponents();
            for (String role : featureComponents.keySet()) {
                PluginIssue issue;
                String message;
                ComponentDefinition definition = featureComponents.get(role);
                ComponentDefinition globalDefinition = (ComponentDefinition)components.get(role);
                if (globalDefinition == null) {
                    components.put(role, definition);
                    continue;
                }
                String id = definition.getId();
                if (id.equals(globalDefinition.getId())) {
                    message = "The component for role '" + role + "' and id '" + id + "' is defined both in feature '" + definition.getPluginName() + "/" + definition.getFeatureName() + "' and in feature '" + globalDefinition.getPluginName() + "/" + globalDefinition.getFeatureName() + "'.";
                    this._logger.error(message);
                    issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.COMPONENT_ALREADY_EXIST, null, message);
                    errors.add(issue);
                    continue;
                }
                message = "The component for role '" + role + "' is defined with id '" + id + "' in the feature '" + definition.getPluginName() + "/" + definition.getFeatureName() + "' and with id '" + globalDefinition.getId() + "' in the feature '" + globalDefinition.getPluginName() + "/" + globalDefinition.getFeatureName() + "'. One of them should be chosen in the runtime.xml.";
                this._logger.error(message);
                issue = new PluginIssue(feature.getPluginName(), feature.getFeatureName(), PluginIssue.PluginIssueCode.COMPONENT_ALREADY_EXIST, null, message);
                errors.add(issue);
            }
        }
        for (String role : componentsConfig.keySet()) {
            String requiredId = componentsConfig.get(role);
            ComponentDefinition definition = (ComponentDefinition)components.get(role);
            if (definition != null && definition.getId().equals(requiredId)) continue;
            String message = "The component for role '" + role + "' should point to id '" + requiredId + "' but no component match.";
            this._logger.error(message);
            PluginIssue issue = new PluginIssue(null, null, PluginIssue.PluginIssueCode.COMPONENT_NOT_DECLARED, null, message);
            errors.add(issue);
        }
        return components;
    }

    @Override
    public String fullDump(FeatureActivator.PluginsInformation pluginInfo) {
        return new LoadedFeaturesDump(this).fullDump(pluginInfo);
    }

    PluginsManager.InactivityCause _getCause(Collection<IncomingDeactivation> deactivatedBy) {
        if (deactivatedBy.isEmpty()) {
            throw new IllegalStateException("collection 'deactivatedBy' cannot be empty");
        }
        if (deactivatedBy.size() == 1) {
            return deactivatedBy.iterator().next().getType().getInactivityCause();
        }
        return deactivatedBy.stream().map(IncomingDeactivation::getType).map(IncomingDeactivation.Type::getInactivityCause).filter(PluginsManager.InactivityCause.OVERRIDDEN::equals).findAny().orElse(PluginsManager.InactivityCause.DEACTIVATED);
    }
}

