/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.IncomingDeactivation;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;

class CorrectedDependencies {
    private Map<String, Feature> _allFeatures;
    private Map<Feature, Collection<String>> _correctedDependencies = new ConcurrentHashMap<Feature, Collection<String>>();
    private Map<String, Collection<IncomingDeactivation>> _incomingDeactivations;
    private Logger _logger;

    CorrectedDependencies(Map<String, Feature> allFeatures, Map<String, Collection<IncomingDeactivation>> incomingDeactivations, Logger logger) {
        this._allFeatures = allFeatures;
        this._incomingDeactivations = incomingDeactivations;
        this._logger = logger;
        this._computeCorrectedDependencies();
    }

    private void _computeCorrectedDependencies() {
        for (Feature feature : this._allFeatures.values()) {
            this._correctedDependencies.put(feature, this._computeCorrectedDependencies(feature));
        }
    }

    Collection<String> getCorrectedDependencies(Feature feature) {
        return this._correctedDependencies.get(feature);
    }

    private Collection<String> _computeCorrectedDependencies(Feature feature) {
        Collection<String> dependencies = feature.getDependencies();
        List<String> correctedDependencies = dependencies.stream().map(dependency -> this._maybeReplaceDependencyByDeactivators((String)dependency, feature)).flatMap(Collection::stream).collect(Collectors.toList());
        return correctedDependencies;
    }

    private Collection<String> _maybeReplaceDependencyByDeactivators(String dependency, Feature originalFeature) {
        Collection<IncomingDeactivation> deactivators = this._incomingDeactivations.get(dependency);
        if (CollectionUtils.isEmpty(deactivators)) {
            return Collections.singleton(dependency);
        }
        if (this._hasDeactivatorsAndNoOverride(deactivators)) {
            this._logger.debug("Dependency '{}' (of feature '{}') is deactivated by one or more feature(s) ({}). Nothing special made.", new Object[]{dependency, originalFeature.getFeatureId(), deactivators});
            return Collections.singleton(dependency);
        }
        String overrider = this._getOverride(deactivators);
        this._logger.info("Dependency '{}' (of feature '{}') is overridden by one feature, it is replaced by it: '{}'.", new Object[]{dependency, originalFeature.getFeatureId(), overrider});
        Collection<String> recursiveOverride = this._maybeReplaceDependencyByDeactivators(overrider, this._allFeatures.get(overrider));
        if (CollectionUtils.isNotEmpty(recursiveOverride)) {
            overrider = recursiveOverride.iterator().next();
        }
        return Collections.singleton(overrider);
    }

    private String _getOverride(Collection<IncomingDeactivation> deactivators) {
        return this._onlyOverriden(deactivators).findAny().map(IncomingDeactivation::getFeatureId).orElseThrow();
    }

    private Stream<IncomingDeactivation> _onlyOverriden(Collection<IncomingDeactivation> deactivators) {
        return deactivators.stream().filter(deactivator -> deactivator.getType() == IncomingDeactivation.Type.OVERRIDDEN);
    }

    private boolean _hasDeactivatorsAndNoOverride(Collection<IncomingDeactivation> deactivators) {
        return this._onlyOverriden(deactivators).findAny().isEmpty();
    }

    public String toString() {
        return this._correctedDependencies.entrySet().stream().collect(Collectors.toMap(e -> ((Feature)e.getKey()).getFeatureId(), e -> (Collection)e.getValue())).toString();
    }
}

