/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.plugin.AbstractFeatureActivator;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.CorrectedDependencies;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.IncomingDeactivation;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.PluginsManager;

public final class ExcludePolicyFeatureActivator
extends AbstractFeatureActivator {
    private Collection<String> _excludedPlugins;
    private Collection<String> _excludedFeatures;

    public ExcludePolicyFeatureActivator(Map<String, Plugin> allPlugins, Collection<String> excludedPlugins, Collection<String> excludedFeatures) {
        super(allPlugins);
        this._excludedPlugins = excludedPlugins;
        this._excludedFeatures = excludedFeatures;
    }

    @Override
    public FeatureActivator.PluginsInformation computeActiveFeatures(Map<String, String> componentsConfig, boolean safeMode) {
        this._safeMode = safeMode;
        HashMap<String, Feature> initialFeatures = new HashMap<String, Feature>();
        HashMap<String, ExtensionPointDefinition> extensionPoints = new HashMap<String, ExtensionPointDefinition>();
        HashMap<String, PluginsManager.InactivityStatus> inactiveFeatures = new HashMap<String, PluginsManager.InactivityStatus>();
        ArrayList<PluginIssue> errors = new ArrayList<PluginIssue>();
        Map<String, Plugin> plugins = this.computeActivePlugins(this._excludedPlugins, initialFeatures, inactiveFeatures, extensionPoints, errors);
        Map<String, Collection<IncomingDeactivation>> incomingDeactivations = this.computeIncomingDeactivations(initialFeatures);
        this._correctedDependencies = new CorrectedDependencies(initialFeatures, incomingDeactivations, this._logger);
        this._removeUserExcludedFeatures(initialFeatures, inactiveFeatures);
        this.removeInactiveFeatures(initialFeatures, inactiveFeatures, incomingDeactivations, componentsConfig);
        this.removeWrongPointReferences(initialFeatures, inactiveFeatures, extensionPoints, errors);
        Map<String, Feature> features = this.processOutgoingDependencies(initialFeatures, inactiveFeatures, errors);
        Map<String, Collection<String>> incomingDependencies = this.computeIncomingDependencies(features);
        this.removeUnusedPassiveFeatures(features, inactiveFeatures, incomingDependencies);
        Map<String, Map<String, ExtensionDefinition>> extensions = this.computeExtensions(features, errors);
        Map<String, ComponentDefinition> components = this.computeComponents(features, componentsConfig, errors);
        return new FeatureActivator.PluginsInformation(plugins, features, inactiveFeatures, extensionPoints, extensions, components, errors);
    }

    private void _removeUserExcludedFeatures(Map<String, Feature> initialFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures) {
        Set<String> ids = initialFeatures.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (!this._excludedFeatures.contains(id)) continue;
            this._logger.debug("Remove excluded feature '{}'", (Object)id);
            it.remove();
            inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.EXCLUDED, null));
        }
    }

    @Override
    public String shortDump(FeatureActivator.PluginsInformation pluginInfo) {
        return "";
    }
}

