/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.runtime.config.ConfigParameterInfo;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;

public class Feature {
    public static final String DEFAULT_NAME = "_default";
    private String _pluginName;
    private String _featureName;
    private Configuration _configuration;
    private boolean _safe;
    private boolean _passive;
    private Collection<String> _dependencies = new ArrayList<String>();
    private Collection<String> _deactivations = new ArrayList<String>();
    private Collection<String> _overrides = new ArrayList<String>();
    private Map<String, ConfigParameterInfo> _configParameters = new LinkedHashMap<String, ConfigParameterInfo>();
    private Collection<String> _configParametersRefs = new ArrayList<String>();
    private Map<String, ConfigParameterInfo> _paramCheckers = new LinkedHashMap<String, ConfigParameterInfo>();
    private Map<String, Map<String, ExtensionDefinition>> _extensions = new LinkedHashMap<String, Map<String, ExtensionDefinition>>();
    private Map<String, ComponentDefinition> _components = new LinkedHashMap<String, ComponentDefinition>();

    Feature(String pluginName, String featureName) {
        this._pluginName = pluginName;
        this._featureName = featureName;
    }

    public String getPluginName() {
        return this._pluginName;
    }

    public String getFeatureName() {
        return this._featureName;
    }

    public String getFeatureId() {
        return this._pluginName + "/" + this._featureName;
    }

    public boolean isPassive() {
        return this._passive;
    }

    public boolean isSafe() {
        return this._safe;
    }

    public Map<String, Collection<String>> getExtensionsIds() {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (String point : this._extensions.keySet()) {
            result.put(point, this._extensions.get(point).keySet());
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getComponentsIds() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String role : this._components.keySet()) {
            result.put(role, this._components.get(role).getId());
        }
        return Collections.unmodifiableMap(result);
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    Collection<String> getDependencies() {
        return this._dependencies;
    }

    Collection<String> getDeactivations() {
        return this._deactivations;
    }

    Collection<String> getOverrides() {
        return this._overrides;
    }

    Map<String, Map<String, ExtensionDefinition>> getExtensions() {
        return this._extensions;
    }

    Map<String, ComponentDefinition> getComponents() {
        return this._components;
    }

    public Map<String, ConfigParameterInfo> getConfigParameters() {
        return this._configParameters;
    }

    public Collection<String> getConfigParametersReferences() {
        return this._configParametersRefs;
    }

    Map<String, ConfigParameterInfo> getParameterCheckers() {
        return this._paramCheckers;
    }

    void configure(Configuration configuration) {
        this._configuration = configuration;
        this._passive = configuration.getAttributeAsBoolean("passive", false);
        this._safe = configuration.getAttributeAsBoolean("safe", false);
        this._configureDependencies();
        this._configureDeactivations();
        this._configureOverrides();
        this._configureExtensions();
        this._configureComponents();
        Configuration configConfiguration = configuration.getChild("config");
        this._configureConfigParameters(configConfiguration);
        this._configureConfigParameterReferences(configConfiguration);
        this._configureParametersCheckers(configConfiguration);
    }

    private void _configureDependencies() {
        String depends = this._configuration.getAttribute("depends", null);
        if (depends != null) {
            List dependencies = Arrays.stream(StringUtils.split((String)depends, (char)',')).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            for (String dependency : dependencies) {
                Object dependingFeatureId = dependency;
                int i = dependency.indexOf(47);
                if (i == -1) {
                    dependingFeatureId = this._pluginName + "/" + dependency;
                }
                this._dependencies.add((String)dependingFeatureId);
            }
        }
    }

    private void _configureDeactivations() {
        this._deactivations.addAll(Feature._configureDeactivationsOrOverrides(this._configuration, "deactivates", this._pluginName));
    }

    private void _configureOverrides() {
        this._overrides.addAll(Feature._configureDeactivationsOrOverrides(this._configuration, "overrides", this._pluginName));
    }

    private static Collection<String> _configureDeactivationsOrOverrides(Configuration configuration, String attributeName, String pluginName) {
        ArrayList<String> result = new ArrayList<String>();
        String deactivates = configuration.getAttribute(attributeName, null);
        if (deactivates != null) {
            List deactivations = Arrays.stream(StringUtils.split((String)deactivates, (char)',')).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            for (String deactivation : deactivations) {
                Object deactivatedFeatureId = deactivation;
                int i = deactivation.indexOf(47);
                if (i == -1) {
                    deactivatedFeatureId = pluginName + "/" + deactivation;
                }
                result.add((String)deactivatedFeatureId);
            }
        }
        return result;
    }

    private void _configureConfigParameters(Configuration configConfiguration) {
        Configuration[] parameterConfigurations;
        for (Configuration parameterConfiguration : parameterConfigurations = configConfiguration.getChildren("param")) {
            String id = parameterConfiguration.getAttribute("id", null);
            this._configParameters.put(id, new ConfigParameterInfo(id, this._pluginName, parameterConfiguration));
        }
    }

    private void _configureConfigParameterReferences(Configuration configConfiguration) {
        Configuration[] parameterConfigurations;
        for (Configuration parameterConfiguration : parameterConfigurations = configConfiguration.getChildren("param-ref")) {
            String id = parameterConfiguration.getAttribute("id", null);
            this._configParametersRefs.add(id);
        }
    }

    private void _configureParametersCheckers(Configuration configConfiguration) {
        Configuration[] parameterConfigurations;
        for (Configuration parameterConfiguration : parameterConfigurations = configConfiguration.getChildren("param-checker")) {
            String id = parameterConfiguration.getAttribute("id", null);
            this._paramCheckers.put(id, new ConfigParameterInfo(id, this._pluginName, parameterConfiguration));
        }
    }

    private void _configureExtensions() {
        Configuration[] extsConf;
        for (Configuration extConf : extsConf = this._configuration.getChild("extensions").getChildren("extension")) {
            String id = extConf.getAttribute("id", null);
            String point = extConf.getAttribute("point", null);
            Map<String, ExtensionDefinition> confs = this._extensions.get(point);
            if (confs == null) {
                confs = new HashMap<String, ExtensionDefinition>();
                this._extensions.put(point, confs);
            }
            confs.put(id, new ExtensionDefinition(id, point, this._pluginName, this._featureName, extConf));
        }
    }

    private void _configureComponents() {
        Configuration[] componentsConf;
        for (Configuration componentConf : componentsConf = this._configuration.getChild("components").getChildren("component")) {
            String clazz = componentConf.getAttribute("class", null);
            String role = componentConf.getAttribute("role", clazz);
            String id = componentConf.getAttribute("id", clazz);
            this._components.put(role, new ComponentDefinition(id, role, this._pluginName, this._featureName, componentConf));
        }
    }
}

