/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.plugin.AbstractFeatureActivator;
import org.ametys.runtime.plugin.ComponentDefinition;
import org.ametys.runtime.plugin.CorrectedDependencies;
import org.ametys.runtime.plugin.ExtensionDefinition;
import org.ametys.runtime.plugin.ExtensionPointDefinition;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.IncludedFeatureConsistencyChecker;
import org.ametys.runtime.plugin.IncomingDeactivation;
import org.ametys.runtime.plugin.LoadedFeaturesDump;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.commons.collections4.ListUtils;

public final class IncludePolicyFeatureActivator
extends AbstractFeatureActivator {
    static String[] __KERNEL_DEPENDENCIES_NEEDED = new String[]{"core/core.observation", "core/core.migration"};
    private Collection<IncludedFeature> _includedFeatures;

    public IncludePolicyFeatureActivator(Map<String, Plugin> allPlugins, Collection<IncludedFeature> includedFeatures) {
        super(allPlugins);
        this._includedFeatures = includedFeatures;
    }

    @Override
    public FeatureActivator.PluginsInformation computeActiveFeatures(Map<String, String> componentsConfig, boolean safeMode) {
        this._safeMode = safeMode;
        HashMap<String, Feature> initialFeatures = new HashMap<String, Feature>();
        HashMap<String, ExtensionPointDefinition> extensionPoints = new HashMap<String, ExtensionPointDefinition>();
        HashMap<String, PluginsManager.InactivityStatus> inactiveFeatures = new HashMap<String, PluginsManager.InactivityStatus>();
        ArrayList<PluginIssue> errors = new ArrayList<PluginIssue>();
        Map<String, Plugin> plugins = this.computeActivePlugins(Collections.emptySet(), initialFeatures, inactiveFeatures, extensionPoints, errors);
        this.removeWrongPointReferences(initialFeatures, inactiveFeatures, extensionPoints, errors);
        Map<String, Collection<IncomingDeactivation>> incomingDeactivations = this.computeIncomingDeactivations(initialFeatures);
        new IncludedFeatureConsistencyChecker(this._includedFeatures, initialFeatures, incomingDeactivations).checkConsistency();
        this._correctedDependencies = new CorrectedDependencies(initialFeatures, incomingDeactivations, this._logger);
        Map<String, Feature> activeFeatures = this.processOutgoingDependencies(initialFeatures, inactiveFeatures, errors);
        Map<String, Collection<String>> outgoingDependencies = this.computeOutgoingDependencies(activeFeatures);
        List<String> includedFeatures = this._getIncludedFeatures();
        List<String> dependencies = this._getDependencies(includedFeatures, outgoingDependencies);
        List includedFeaturesAndDependencies = ListUtils.union(includedFeatures, dependencies);
        this._removeUnusedFeatures(activeFeatures, inactiveFeatures, includedFeaturesAndDependencies);
        Map<String, Collection<IncomingDeactivation>> featuresToDeactivate = this._getFeaturesToDeactivate(incomingDeactivations, includedFeaturesAndDependencies);
        List<String> dependenciesNowUnused = this._computeDependenciesNowUnused(featuresToDeactivate.keySet(), outgoingDependencies, includedFeatures, activeFeatures);
        this._removeDeactivatedFeatures(activeFeatures, inactiveFeatures, featuresToDeactivate, dependenciesNowUnused);
        Map<String, Map<String, ExtensionDefinition>> extensions = this.computeExtensions(activeFeatures, errors);
        Map<String, ComponentDefinition> components = this.computeComponents(activeFeatures, componentsConfig, errors);
        return new FeatureActivator.PluginsInformation(plugins, activeFeatures, inactiveFeatures, extensionPoints, extensions, components, errors);
    }

    private List<String> _getIncludedFeatures() {
        return Stream.concat(Stream.of(__KERNEL_DEPENDENCIES_NEEDED), this._includedFeatures.stream().map(IncludedFeature::featureId)).collect(Collectors.toList());
    }

    private List<String> _getDependencies(List<String> featuresToProcess, Map<String, Collection<String>> outgoingDependencies) {
        ArrayList<String> dependencies = new ArrayList<String>();
        this._fillRecursiveDependencies(featuresToProcess, outgoingDependencies, dependencies, false);
        return dependencies;
    }

    private void _fillRecursiveDependencies(Collection<String> featuresToProcess, Map<String, Collection<String>> outgoingDependencies, List<String> dependencyListToFill, boolean addFeaturesToProcess) {
        for (String featureToProcess : featuresToProcess) {
            Collection<String> deps;
            if (addFeaturesToProcess) {
                dependencyListToFill.add(featureToProcess);
            }
            if ((deps = outgoingDependencies.get(featureToProcess)) == null) continue;
            this._fillRecursiveDependencies(deps, outgoingDependencies, dependencyListToFill, true);
        }
    }

    private void _removeUnusedFeatures(Map<String, Feature> activeFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Collection<String> featuresToKeep) {
        Set<String> ids = activeFeatures.keySet();
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (featuresToKeep.contains(id)) continue;
            this._logger.info("Remove unused feature '{}'", (Object)id);
            it.remove();
            if (inactiveFeatures.containsKey(id)) continue;
            inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.UNUSED, null));
        }
    }

    private Map<String, Collection<IncomingDeactivation>> _getFeaturesToDeactivate(Map<String, Collection<IncomingDeactivation>> incomingDeactivations, List<String> includedFeatures) {
        HashMap<String, Collection<IncomingDeactivation>> result = new HashMap<String, Collection<IncomingDeactivation>>();
        for (String id : includedFeatures) {
            Collection<IncomingDeactivation> deactivatedBy;
            if (!incomingDeactivations.containsKey(id) || !IncomingDeactivation.containsAny(includedFeatures, deactivatedBy = incomingDeactivations.get(id))) continue;
            result.put(id, IncomingDeactivation.intersection(includedFeatures, deactivatedBy));
        }
        return result;
    }

    private List<String> _computeDependenciesNowUnused(Collection<String> featuresToDeactivate, Map<String, Collection<String>> outgoingDependencies, List<String> includedFeatures, Map<String, Feature> allFeatures) {
        ArrayList<String> dependenciesNowUnused = new ArrayList<String>();
        Map<String, Collection<String>> incomingDependencies = this.computeIncomingDependencies(allFeatures);
        for (String featureToDeactivate : featuresToDeactivate) {
            Collection<String> dependencies = outgoingDependencies.get(featureToDeactivate);
            for (String dependency : dependencies) {
                Collection<String> incomingDependency = incomingDependencies.get(dependency);
                if (incomingDependency.size() != 1 || !incomingDependency.iterator().next().equals(featureToDeactivate) || includedFeatures.contains(dependency)) continue;
                dependenciesNowUnused.add(dependency);
            }
        }
        return dependenciesNowUnused;
    }

    private void _removeDeactivatedFeatures(Map<String, Feature> activeFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures, Map<String, Collection<IncomingDeactivation>> featuresToDeactivate, List<String> dependenciesNowUnused) {
        Iterator<String> it = activeFeatures.keySet().iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (featuresToDeactivate.containsKey(id)) {
                Collection<IncomingDeactivation> deactivatedBy = featuresToDeactivate.get(id);
                this._logger.debug("Remove feature {} deactivated by features {}", (Object)id, deactivatedBy);
                it.remove();
                PluginsManager.InactivityCause cause = this._getCause(deactivatedBy);
                List<String> sources = deactivatedBy.stream().map(IncomingDeactivation::getFeatureId).toList();
                inactiveFeatures.put(id, new PluginsManager.InactivityStatus(cause, sources));
                continue;
            }
            if (!dependenciesNowUnused.contains(id)) continue;
            this._logger.debug("Remove unused dependency '{}'", (Object)id);
            it.remove();
            if (inactiveFeatures.containsKey(id)) continue;
            inactiveFeatures.put(id, new PluginsManager.InactivityStatus(PluginsManager.InactivityCause.UNUSED, null));
        }
    }

    @Override
    public String shortDump(FeatureActivator.PluginsInformation pluginInfo) {
        return new LoadedFeaturesDump(this).shortDump(pluginInfo, this._includedFeatures);
    }

    public static final class IncludedFeature {
        private String _featureId;
        private String _cause;

        private IncludedFeature(String featureId, String cause) {
            this._featureId = featureId;
            this._cause = cause;
        }

        public static IncludedFeature of(String featureId, String cause) {
            return new IncludedFeature(featureId, cause);
        }

        public String featureId() {
            return this._featureId;
        }

        public String cause() {
            return this._cause;
        }

        public String toString() {
            return String.format("%s [included by %s]", this._featureId, this._cause);
        }
    }
}

