/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.IncludePolicyFeatureActivator;
import org.ametys.runtime.plugin.IncomingDeactivation;

class IncludedFeatureConsistencyChecker {
    private Collection<IncludePolicyFeatureActivator.IncludedFeature> _includedFeatures;
    private Map<String, Feature> _initialFeatures;
    private Map<String, Collection<IncomingDeactivation>> _incomingDeactivations;

    IncludedFeatureConsistencyChecker(Collection<IncludePolicyFeatureActivator.IncludedFeature> includedFeatures, Map<String, Feature> initialFeatures, Map<String, Collection<IncomingDeactivation>> incomingDeactivations) {
        this._includedFeatures = includedFeatures;
        this._initialFeatures = initialFeatures;
        this._incomingDeactivations = incomingDeactivations;
    }

    void checkConsistency() {
        List includedFeatures = this._includedFeatures.stream().map(IncludePolicyFeatureActivator.IncludedFeature::featureId).collect(Collectors.toList());
        for (String includedFeatureId : includedFeatures) {
            this._checkFeature(includedFeatureId);
        }
    }

    private void _checkFeature(String featureId) {
        Feature feature = Objects.requireNonNull(this._initialFeatures.get(featureId), String.format("Feature '%s' cannot be found.", featureId));
        Collection<String> dependencies = feature.getDependencies();
        for (String dependency : dependencies) {
            if (this._incomingDeactivations.containsKey(dependency) && this._allDeactivationsAreDeactivatedType(dependency)) {
                throw new IllegalStateException(String.format("Problem of consistency with included features %s. At least one of them is deactivated by another. The application will not be able to boot.", this._includedFeatures));
            }
            this._checkFeature(dependency);
        }
    }

    private boolean _allDeactivationsAreDeactivatedType(String dependency) {
        Collection<IncomingDeactivation> incomingDeactivations = this._incomingDeactivations.get(dependency);
        return incomingDeactivations.stream().map(IncomingDeactivation::getType).allMatch(IncomingDeactivation.Type.DEACTIVATED::equals);
    }
}

