/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.commons.collections4.CollectionUtils;

class IncomingDeactivation {
    private Type _type;
    private String _featureId;

    IncomingDeactivation(Type type, String featureId) {
        this._type = type;
        this._featureId = featureId;
    }

    static boolean containsAny(List<String> includedFeatures, Collection<IncomingDeactivation> deactivatedBy) {
        if (deactivatedBy == null) {
            return false;
        }
        Collection deactivatedByIds = deactivatedBy.stream().map(IncomingDeactivation::getFeatureId).collect(Collectors.toList());
        return CollectionUtils.containsAny(includedFeatures, (Collection)deactivatedByIds);
    }

    static Collection<IncomingDeactivation> intersection(List<String> includedFeatures, Collection<IncomingDeactivation> deactivatedBy) {
        return deactivatedBy.stream().filter(incomingDeactivation -> includedFeatures.contains(incomingDeactivation.getFeatureId())).collect(Collectors.toList());
    }

    Type getType() {
        return this._type;
    }

    String getFeatureId() {
        return this._featureId;
    }

    public String toString() {
        return String.format("IncomingDeactivation(%s, %s)", this._featureId, this._type.name());
    }

    static enum Type {
        DEACTIVATED(PluginsManager.InactivityCause.DEACTIVATED),
        OVERRIDDEN(PluginsManager.InactivityCause.OVERRIDDEN);

        private PluginsManager.InactivityCause _cause;

        private Type(PluginsManager.InactivityCause cause) {
            this._cause = cause;
        }

        PluginsManager.InactivityCause getInactivityCause() {
            return this._cause;
        }
    }
}

