/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import com.google.common.base.Predicates;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.runtime.plugin.AbstractFeatureActivator;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.FeatureActivator;
import org.ametys.runtime.plugin.IncludePolicyFeatureActivator;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginIssue;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

class LoadedFeaturesDump {
    private AbstractFeatureActivator _featureActivator;

    LoadedFeaturesDump(AbstractFeatureActivator featureActivator) {
        this._featureActivator = featureActivator;
    }

    String fullDump(FeatureActivator.PluginsInformation pluginInfo) {
        Map<String, PluginsManager.InactivityStatus> inactiveFeatures = pluginInfo.getInactiveFeatures();
        Collection<PluginIssue> errors = pluginInfo.getErrors();
        Collection<String> excludedPlugins = RuntimeConfig.getInstance().getExcludedPlugins();
        StringBuilder sb = new StringBuilder();
        for (String pluginName : this._featureActivator._allPlugins.keySet()) {
            Plugin plugin = this._featureActivator._allPlugins.get(pluginName);
            this._fullDumpPlugin(sb, plugin, excludedPlugins, inactiveFeatures);
        }
        if (!errors.isEmpty()) {
            sb.append("\nErrors :\n");
            errors.forEach(issue -> sb.append(issue.toString()).append('\n'));
        }
        return sb.toString();
    }

    private void _fullDumpPlugin(StringBuilder sb, Plugin plugin, Collection<String> excludedPlugins, Map<String, PluginsManager.InactivityStatus> inactiveFeatures) {
        Collection<String> extensionPoints;
        Set<String> paramCheckers;
        String pluginName = plugin.getName();
        sb.append("Plugin ").append(pluginName);
        if (excludedPlugins.contains(pluginName)) {
            sb.append("   *** excluded ***");
        }
        sb.append('\n');
        Set<String> configParameters = plugin.getConfigParameters().keySet();
        if (!CollectionUtils.isEmpty(configParameters)) {
            sb.append("  Config parameters : \n");
            configParameters.forEach(param -> sb.append("    ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(paramCheckers = plugin.getParameterCheckers().keySet())) {
            sb.append("  Parameters checkers : \n");
            paramCheckers.forEach(param -> sb.append("    ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(extensionPoints = plugin.getExtensionPoints())) {
            sb.append("  Extension points : \n");
            extensionPoints.forEach(point -> sb.append("    ").append((String)point).append('\n'));
        }
        Map<String, Feature> features = plugin.getFeatures();
        for (String featureId : features.keySet()) {
            Feature feature = features.get(featureId);
            this._fullDumpFeature(sb, feature, inactiveFeatures);
        }
        sb.append('\n');
    }

    private void _fullDumpFeature(StringBuilder sb, Feature feature, Map<String, PluginsManager.InactivityStatus> inactiveFeatures) {
        Map<String, Collection<String>> extensionsIds;
        Map<String, String> componentsIds;
        Set<String> featureParamCheckers;
        Collection<String> configParametersReferences;
        String featureId = feature.getFeatureId();
        sb.append("  Feature ").append(featureId);
        if (feature.isPassive()) {
            sb.append(" (passive)");
        }
        if (feature.isSafe()) {
            sb.append(" (safe)");
        }
        if (inactiveFeatures != null && inactiveFeatures.containsKey(featureId)) {
            sb.append("   *** inactive (").append(inactiveFeatures.get(featureId)).append(") ***");
        }
        sb.append('\n');
        Set<String> featureConfigParameters = feature.getConfigParameters().keySet();
        if (!CollectionUtils.isEmpty(featureConfigParameters)) {
            sb.append("    Config parameters : \n");
            featureConfigParameters.forEach(param -> sb.append("      ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(configParametersReferences = feature.getConfigParametersReferences())) {
            sb.append("    Config parameters references : \n");
            configParametersReferences.forEach(param -> sb.append("      ").append((String)param).append('\n'));
        }
        if (!CollectionUtils.isEmpty(featureParamCheckers = feature.getParameterCheckers().keySet())) {
            sb.append("    Parameters checkers : \n");
            featureParamCheckers.forEach(param -> sb.append("    ").append((String)param).append('\n'));
        }
        if (!(componentsIds = feature.getComponentsIds()).isEmpty()) {
            sb.append("    Components : \n");
            for (String role : componentsIds.keySet()) {
                String id2 = componentsIds.get(role);
                sb.append("      ").append(role).append(" : ").append(id2).append('\n');
            }
            sb.append('\n');
        }
        if (!(extensionsIds = feature.getExtensionsIds()).isEmpty()) {
            sb.append("    Extensions : \n");
            for (Map.Entry<String, Collection<String>> extensionEntry : extensionsIds.entrySet()) {
                String point = extensionEntry.getKey();
                Collection<String> ids = extensionEntry.getValue();
                sb.append("      ").append(point).append(" :\n");
                ids.forEach(id -> sb.append("        ").append((String)id).append('\n'));
            }
            sb.append('\n');
        }
    }

    String shortDump(FeatureActivator.PluginsInformation pluginInfo, Collection<IncludePolicyFeatureActivator.IncludedFeature> includedFeatures) {
        Collection<PluginIssue> errors = pluginInfo.getErrors();
        Map<String, PluginsManager.InactivityStatus> inactiveFeatures = pluginInfo.getInactiveFeatures();
        Map<String, Collection<String>> dependencies = this._featureActivator.computeIncomingDependencies(pluginInfo.getFeatures());
        StringBuilder sb = new StringBuilder();
        String separatorLine = new String(new char[66]).replace('\u0000', '-') + "\n";
        sb.append(separatorLine);
        this._dumpLoaded(sb, separatorLine, pluginInfo);
        sb.append(separatorLine);
        List pluginNames = this._featureActivator._allPlugins.keySet().stream().sorted().collect(Collectors.toList());
        for (String pluginName : pluginNames) {
            Plugin plugin = this._featureActivator._allPlugins.get(pluginName);
            this._shortDumpPlugin(sb, plugin, dependencies, includedFeatures, inactiveFeatures);
        }
        if (!errors.isEmpty()) {
            sb.append("\nErrors :\n");
            errors.forEach(issue -> sb.append(issue.toString()).append('\n'));
        }
        sb.append(separatorLine);
        return sb.toString();
    }

    private void _dumpLoaded(StringBuilder sb, String separatorLine, FeatureActivator.PluginsInformation pluginInfo) {
        Map<String, Feature> loadedFeatures = pluginInfo.getFeatures();
        int nbLoadedFeatures = loadedFeatures.size();
        long nbLoadedComponents = loadedFeatures.values().parallelStream().map(Feature::getComponents).map(Map::values).flatMap(Collection::parallelStream).count();
        long nbLoadedExtensions = loadedFeatures.values().parallelStream().map(Feature::getExtensions).map(Map::values).flatMap(Collection::parallelStream).map(Map::values).flatMap(Collection::parallelStream).count();
        int nbInactiveFeatures = pluginInfo.getInactiveFeatures().size();
        Set<String> inactiveFeatureIds = pluginInfo.getInactiveFeatures().keySet();
        Supplier<Stream> inactiveFeatures = () -> this._featureActivator._allPlugins.values().stream().map(Plugin::getFeatures).map(Map::values).flatMap(Collection::parallelStream).filter(Predicates.compose(inactiveFeatureIds::contains, Feature::getFeatureId));
        long nbInactiveComponents = inactiveFeatures.get().map(Feature::getComponentsIds).mapToInt(Map::size).sum();
        long nbInactiveExtensions = inactiveFeatures.get().map(Feature::getExtensionsIds).map(Map::values).flatMap(Collection::parallelStream).flatMap(Collection::parallelStream).count();
        this._addCell(sb, "\\");
        this._addCell(sb, "loaded");
        this._addCell(sb, "inactive");
        this._addCell(sb, "total");
        this._addCell(sb, "load factor");
        sb.append("|\n");
        sb.append(separatorLine);
        this._addCell(sb, "features");
        this._addCell(sb, String.valueOf(nbLoadedFeatures));
        this._addCell(sb, String.valueOf(nbInactiveFeatures));
        int nbTotalFeatures = nbLoadedFeatures + nbInactiveFeatures;
        this._addCell(sb, String.valueOf(nbTotalFeatures));
        this._addCell(sb, new BigDecimal((double)nbLoadedFeatures / (double)nbTotalFeatures).setScale(3, RoundingMode.HALF_UP));
        sb.append("|\n");
        sb.append(separatorLine);
        this._addCell(sb, "components");
        this._addCell(sb, String.valueOf(nbLoadedComponents));
        this._addCell(sb, String.valueOf(nbInactiveComponents));
        long nbTotalComponents = nbLoadedComponents + nbInactiveComponents;
        this._addCell(sb, String.valueOf(nbTotalComponents));
        this._addCell(sb, new BigDecimal((double)nbLoadedComponents / (double)nbTotalComponents).setScale(3, RoundingMode.HALF_UP));
        sb.append("|\n");
        sb.append(separatorLine);
        this._addCell(sb, "extensions");
        this._addCell(sb, String.valueOf(nbLoadedExtensions));
        this._addCell(sb, String.valueOf(nbInactiveExtensions));
        long nbTotalExtensions = nbLoadedExtensions + nbInactiveExtensions;
        this._addCell(sb, String.valueOf(nbTotalExtensions));
        this._addCell(sb, new BigDecimal((double)nbLoadedExtensions / (double)nbTotalExtensions).setScale(3, RoundingMode.HALF_UP));
        sb.append("|\n");
    }

    private void _addCell(StringBuilder sb, Object content) {
        int limit = 12;
        String limitedContent = String.valueOf(content);
        if (limitedContent.length() >= 12) {
            limitedContent = limitedContent.substring(0, 12);
        } else {
            int missing = 12 - limitedContent.length();
            int half = missing / 2;
            char[] characters = new char[12];
            Arrays.fill(characters, ' ');
            int startPosTarget = missing - half;
            System.arraycopy(limitedContent.toCharArray(), 0, characters, startPosTarget, limitedContent.length());
            limitedContent = new String(characters);
        }
        sb.append("|");
        sb.append(limitedContent);
    }

    private void _shortDumpPlugin(StringBuilder sb, Plugin plugin, Map<String, Collection<String>> dependencies, Collection<IncludePolicyFeatureActivator.IncludedFeature> includedFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures) {
        String pluginName = plugin.getName();
        sb.append("Plugin ").append(pluginName);
        sb.append("\n\n");
        Map<String, Feature> activeFeatures = plugin.getFeatures();
        List featureIds = activeFeatures.keySet().stream().sorted().collect(Collectors.toList());
        for (String featureId : featureIds) {
            Feature feature = activeFeatures.get(featureId);
            this._shortDumpFeature(sb, feature, dependencies, includedFeatures, inactiveFeatures);
        }
        sb.append('\n');
    }

    private void _shortDumpFeature(StringBuilder sb, Feature feature, Map<String, Collection<String>> dependencies, Collection<IncludePolicyFeatureActivator.IncludedFeature> includedFeatures, Map<String, PluginsManager.InactivityStatus> inactiveFeatures) {
        String featureId = feature.getFeatureId();
        if (!inactiveFeatures.containsKey(featureId)) {
            Optional<String> causes;
            sb.append("  Feature ").append(featureId);
            ArrayList<String> dependenciesOfFeature = new ArrayList<String>();
            if (dependencies.containsKey(featureId)) {
                dependenciesOfFeature.addAll(dependencies.get(featureId));
            }
            if ((causes = this._findIncludedFeatureCauses(featureId, includedFeatures)).isPresent()) {
                dependenciesOfFeature.add(0, "INCLUDED_FEATURE BY " + causes.get());
            }
            if (ArrayUtils.contains((Object[])IncludePolicyFeatureActivator.__KERNEL_DEPENDENCIES_NEEDED, (Object)featureId)) {
                dependenciesOfFeature.add(0, "KERNEL");
            }
            if (!dependenciesOfFeature.isEmpty()) {
                sb.append("\n    --> brought by ").append(this._dependenciesToString(dependenciesOfFeature));
            }
            sb.append("\n\n");
        }
    }

    private String _dependenciesToString(List<String> dependenciesOfFeature) {
        switch (dependenciesOfFeature.size()) {
            case 0: 
            case 1: {
                return dependenciesOfFeature.toString();
            }
        }
        String indent1 = "                   ";
        String indent2 = "                       ";
        return "[\n                       " + String.join((CharSequence)",\n                       ", dependenciesOfFeature) + "\n                   ]";
    }

    private Optional<String> _findIncludedFeatureCauses(String featureId, Collection<IncludePolicyFeatureActivator.IncludedFeature> includedFeatures) {
        List causes = includedFeatures.stream().filter((Predicate<IncludePolicyFeatureActivator.IncludedFeature>)Predicates.compose((com.google.common.base.Predicate)Predicates.equalTo((Object)featureId), IncludePolicyFeatureActivator.IncludedFeature::featureId)).map(IncludePolicyFeatureActivator.IncludedFeature::cause).collect(Collectors.toList());
        switch (causes.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((String)causes.get(0));
            }
        }
        return Optional.of("{" + String.join((CharSequence)" & ", causes) + "}");
    }
}

