/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.source.OptionalSourceFallbackExtensionPoint;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;

public class PluginSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable {
    private static final Pattern __SOURCE_PATTERN = Pattern.compile("^[\\w]+:([a-zA-Z0-9](?:[a-zA-Z0-9-_\\.]*[a-zA-Z0-9])?)(\\?)?://(.*)$");
    private SourceResolver _resolver;
    private OptionalSourceFallbackExtensionPoint _optionalSourceFallbackExtensionPoint;
    private ServiceManager _manager;

    public Source getSource(String location, Map parameters) throws IOException {
        Matcher m = __SOURCE_PATTERN.matcher(location);
        if (!m.matches()) {
            throw new MalformedURLException("URI must be like protocol:<plugin name>://path/to/resource. Location was '" + location + "'");
        }
        String pluginName = m.group(1);
        String optional = m.group(2);
        String path = m.group(3);
        String resourceURI = PluginsManager.getInstance().getResourceURI(pluginName);
        if (resourceURI == null) {
            File pluginLocation = PluginsManager.getInstance().getPluginLocation(pluginName);
            if (pluginLocation == null) {
                if (optional == null) {
                    String errorMessage = "The plugin '" + pluginName + "' does not exist.";
                    this.getLogger().warn(errorMessage);
                    throw new SourceNotFoundException(errorMessage);
                }
                String fallback = this._getOptionalSourceFallbackExtensionPoint().fallback(location);
                if (fallback == null) {
                    String errorMessage = "While resolving the url '" + location + "', the plugin '" + pluginName + "' does not exist and no fallback is matching it.";
                    this.getLogger().warn(errorMessage);
                    throw new SourceNotFoundException(errorMessage);
                }
                try {
                    Source source = this._resolver.resolveURI(fallback);
                    if (!source.exists()) {
                        String errorMessage = "While resolving the url '" + location + "', the plugin '" + pluginName + "' does not exist and the fallback '" + fallback + "' does not exist.";
                        this.getLogger().warn(errorMessage);
                        throw new SourceNotFoundException(errorMessage);
                    }
                    return source;
                }
                catch (SourceNotFoundException e) {
                    throw new SourceNotFoundException("While resolving the url '" + location + "', the plugin '" + pluginName + "' does not exist and the fallback '" + fallback + "' does not exist.", (Throwable)e);
                }
            }
            return new FileSource("file", new File(pluginLocation, path));
        }
        return this._resolver.resolveURI(resourceURI + "/" + path);
    }

    public void release(Source source) {
    }

    private synchronized OptionalSourceFallbackExtensionPoint _getOptionalSourceFallbackExtensionPoint() {
        if (this._optionalSourceFallbackExtensionPoint == null) {
            try {
                this._optionalSourceFallbackExtensionPoint = (OptionalSourceFallbackExtensionPoint)this._manager.lookup(OptionalSourceFallbackExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Unable to get the OptionalSourceFallbacksExtensionPoint extension point.", e);
            }
        }
        return this._optionalSourceFallbackExtensionPoint;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }
}

