/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PluginsGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"list");
        Map<String, Plugin> plugins = PluginsManager.getInstance().getPlugins();
        Map<String, PluginsManager.InactivityStatus> inactiveFeatures = PluginsManager.getInstance().getInactiveFeatures();
        this._saxPlugins(plugins, inactiveFeatures);
        this._saxExtensionPoints();
        this._saxComponents();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"list");
        this.contentHandler.endDocument();
    }

    private void _saxPlugins(Map<String, Plugin> plugins, Map<String, PluginsManager.InactivityStatus> inactiveFeatures) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"plugins");
        for (String pluginName : plugins.keySet()) {
            AttributesImpl psAttrs = new AttributesImpl();
            psAttrs.addCDATAAttribute("name", pluginName);
            String version = PluginsManager.getInstance().getVersion(pluginName);
            if (StringUtils.isNotBlank((CharSequence)version)) {
                psAttrs.addCDATAAttribute("version", version);
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"plugin", (Attributes)psAttrs);
            Plugin plugin = plugins.get(pluginName);
            Map<String, Feature> features = plugin.getFeatures();
            for (String featureId : features.keySet()) {
                Feature feature = features.get(featureId);
                AttributesImpl pAttrs = new AttributesImpl();
                pAttrs.addCDATAAttribute("name", feature.getFeatureName());
                PluginsManager.InactivityStatus cause = inactiveFeatures.get(featureId);
                if (cause != null) {
                    pAttrs.addCDATAAttribute("inactive", "true");
                    pAttrs.addCDATAAttribute("cause", cause.cause().toString());
                    Collection<String> sources = cause.features();
                    if (sources != null && !sources.isEmpty()) {
                        pAttrs.addCDATAAttribute("source", sources.iterator().next());
                    }
                }
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"feature", (Attributes)pAttrs);
                Map<String, Collection<String>> exts = feature.getExtensionsIds();
                for (String extensionPoint : exts.keySet()) {
                    AttributesImpl epAttrs = new AttributesImpl();
                    epAttrs.addCDATAAttribute("name", extensionPoint);
                    XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"extensionPoint", (Attributes)epAttrs);
                    for (String extension : exts.get(extensionPoint)) {
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"extension", (String)extension);
                    }
                    XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"extensionPoint");
                }
                Map<String, String> componentsIds = feature.getComponentsIds();
                for (String componentRole : componentsIds.keySet()) {
                    String component = componentsIds.get(componentRole);
                    AttributesImpl cmpAttrs = new AttributesImpl();
                    cmpAttrs.addCDATAAttribute("role", componentRole);
                    XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"component", (Attributes)cmpAttrs, (String)component);
                }
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"feature");
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"plugin");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"plugins");
    }

    private void _saxExtensionPoints() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"extension-points");
        for (String extPoint : PluginsManager.getInstance().getExtensionPoints().keySet()) {
            AttributesImpl ePAttrs = new AttributesImpl();
            ePAttrs.addCDATAAttribute("id", extPoint);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"extension-point", (Attributes)ePAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"extension-points");
    }

    private void _saxComponents() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"components");
        for (String componentRole : PluginsManager.getInstance().getComponents()) {
            AttributesImpl cmpAttrs = new AttributesImpl();
            cmpAttrs.addCDATAAttribute("id", componentRole);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"component", (Attributes)cmpAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"components");
    }
}

