/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.datasource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.DataSourceClientInteraction;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.core.datasource.DataSourceConsumerExtensionPoint;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.xml.sax.SAXException;

public class DeleteDataSourceClientSideElement
extends StaticClientSideElement {
    private SQLDataSourceManager _sqlDataSourceManager;
    private LDAPDataSourceManager _ldapSourceManager;
    private DataSourceConsumerExtensionPoint _dataSourceConsumerEP;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sqlDataSourceManager = (SQLDataSourceManager)smanager.lookup(SQLDataSourceManager.ROLE);
        this._ldapSourceManager = (LDAPDataSourceManager)smanager.lookup(LDAPDataSourceManager.ROLE);
        this._dataSourceConsumerEP = (DataSourceConsumerExtensionPoint)smanager.lookup(DataSourceConsumerExtensionPoint.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getStatus(Map<String, String> datasourceIds) throws ConfigurationException, SAXException, IOException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("allright-datasources", new ArrayList());
        results.put("internal-datasources", new ArrayList());
        results.put("inuse-datasources", new ArrayList());
        results.put("unknown-datasources", new ArrayList());
        for (String id : datasourceIds.keySet()) {
            AbstractDataSourceManager.DataSourceDefinition dsDef = null;
            boolean isInUse = false;
            DataSourceClientInteraction.DataSourceType type = DataSourceClientInteraction.DataSourceType.valueOf(datasourceIds.get(id));
            switch (type) {
                case SQL: {
                    boolean bl;
                    dsDef = this._sqlDataSourceManager.getDataSourceDefinition(id);
                    if (dsDef != null) {
                        DataSourceConsumer.TypeOfUse[] typeOfUseArray = new DataSourceConsumer.TypeOfUse[2];
                        typeOfUseArray[0] = this._dataSourceConsumerEP.isInUse(id);
                        DataSourceConsumer.TypeOfUse typeOfUse = typeOfUseArray[1] = dsDef.isDefault() ? this._dataSourceConsumerEP.isInUse(this._sqlDataSourceManager.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED;
                        bl = DataSourceConsumer.TypeOfUse.merge(typeOfUseArray) != DataSourceConsumer.TypeOfUse.NOT_USED;
                    } else {
                        bl = false;
                    }
                    isInUse = bl;
                    break;
                }
                case LDAP: {
                    boolean bl;
                    dsDef = this._ldapSourceManager.getDataSourceDefinition(id);
                    if (dsDef != null) {
                        DataSourceConsumer.TypeOfUse[] typeOfUseArray = new DataSourceConsumer.TypeOfUse[2];
                        typeOfUseArray[0] = this._dataSourceConsumerEP.isInUse(id);
                        DataSourceConsumer.TypeOfUse typeOfUse = typeOfUseArray[1] = dsDef.isDefault() ? this._dataSourceConsumerEP.isInUse(this._ldapSourceManager.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED;
                        bl = DataSourceConsumer.TypeOfUse.merge(typeOfUseArray) != DataSourceConsumer.TypeOfUse.NOT_USED;
                    } else {
                        bl = false;
                    }
                    isInUse = bl;
                    break;
                }
            }
            if (dsDef != null) {
                if (dsDef.getId().equals("SQL-ametys-internal")) {
                    List internalDataSource = (List)results.get("internal-datasources");
                    internalDataSource.add(this._getDataSourceParameters(dsDef));
                    continue;
                }
                if (isInUse) {
                    List inUseDataSources = (List)results.get("inuse-datasources");
                    inUseDataSources.add(this._getDataSourceParameters(dsDef));
                    continue;
                }
                List allRightDataSources = (List)results.get("allright-datasources");
                allRightDataSources.add(this._getDataSourceParameters(dsDef));
                continue;
            }
            List unknownDataSources = (List)results.get("unknown-datasources");
            unknownDataSources.add(id);
        }
        return results;
    }

    private Map<String, Object> _getDataSourceParameters(AbstractDataSourceManager.DataSourceDefinition datasource) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", datasource.getId());
        params.put("name", datasource.getName());
        return params;
    }
}

